/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;

public interface IDegreeModuleToEvaluate {
    public static final Comparator<IDegreeModuleToEvaluate> COMPARATOR_BY_EXECUTION_PERIOD = new Comparator<IDegreeModuleToEvaluate>(){

        @Override
        public int compare(IDegreeModuleToEvaluate o1, IDegreeModuleToEvaluate o2) {
            return o1.getExecutionPeriod().compareTo(o2.getExecutionPeriod());
        }
    };
    public static final Comparator<IDegreeModuleToEvaluate> COMPARATOR_BY_CONTEXT = new Comparator<IDegreeModuleToEvaluate>(){

        @Override
        public int compare(IDegreeModuleToEvaluate o1, IDegreeModuleToEvaluate o2) {
            return o1.getContext().compareTo(o2.getContext());
        }
    };

    public CurriculumGroup getCurriculumGroup();

    public Context getContext();

    public DegreeModule getDegreeModule();

    public boolean isFor(DegreeModule var1);

    public ExecutionSemester getExecutionPeriod();

    public boolean isLeaf();

    public boolean isOptional();

    public boolean isEnroled();

    public boolean isEnroling();

    public boolean isDissertation();

    public boolean canCollectRules();

    public String getName();

    public String getYearFullLabel();

    public boolean isOptionalCurricularCourse();

    public String getKey();

    public Double getEctsCredits();

    public Double getEctsCredits(ExecutionSemester var1);

    public double getAccumulatedEctsCredits(ExecutionSemester var1);

    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester var1);

    public Set<ICurricularRule> getCurricularRulesFromCurriculumGroup(ExecutionSemester var1);

    public boolean isAnnualCurricularCourse(ExecutionYear var1);
}

