/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;

public class ResidenceEventWrapper
implements Wrapper {
    private final ResidenceEvent event;

    public ResidenceEventWrapper(ResidenceEvent event) {
        this.event = event;
    }

    @Override
    public String getStudentNumber() {
        if (this.event.getPerson().getStudent() != null) {
            return this.event.getPerson().getStudent().getNumber().toString();
        }
        return "--";
    }

    @Override
    public String getStudentName() {
        return this.event.getPerson().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.event.getPerson().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        return "--";
    }

    @Override
    public String getExecutionYear() {
        return "--";
    }

    @Override
    public String getDegreeName() {
        return "--";
    }

    @Override
    public String getDegreeType() {
        return "--";
    }

    @Override
    public String getPhdProgramName() {
        return "--";
    }

    @Override
    public String getEnrolledECTS() {
        return "--";
    }

    @Override
    public String getRegime() {
        return "--";
    }

    @Override
    public String getEnrolmentModel() {
        return "--";
    }

    @Override
    public String getResidenceYear() {
        return this.event.getResidenceMonth().getYear().getYear().toString();
    }

    @Override
    public String getResidenceMonth() {
        return this.event.getResidenceMonth().getMonth().getName();
    }

    @Override
    public String getStudiesType() {
        return "--";
    }

    @Override
    public String getTotalDiscount() {
        return this.event.getTotalDiscount().toPlainString();
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return false;
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        return null;
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        return null;
    }

    @Override
    public String getRelatedEventExternalId() {
        return "--";
    }

    @Override
    public String getDebtorFiscalId() {
        return "--";
    }

    @Override
    public String getDebtorName() {
        return "--";
    }
}

