/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.specializationDegree;

import java.util.Collection;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.specializationDegree.SpecializationDegreeRegistrationEvent;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountWithPenaltyPR;
import org.fenixedu.academic.domain.accounting.postingRules.specializationDegree.SpecializationDegreeRegistrationPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class SpecializationDegreeRegistrationPR
extends SpecializationDegreeRegistrationPR_Base {
    public SpecializationDegreeRegistrationPR() {
    }

    public SpecializationDegreeRegistrationPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty) {
        this();
        super.init(EntryType.REGISTRATION_FEE, EventType.SPECIALIZATION_DEGREE_REGISTRATION, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty);
    }

    protected boolean hasPenalty(Event event, DateTime when) {
        return this.hasPenaltyForRegistration((SpecializationDegreeRegistrationEvent)((Object)event));
    }

    private boolean hasPenaltyForRegistration(SpecializationDegreeRegistrationEvent specializationDegreeRegistrationEvent) {
        return specializationDegreeRegistrationEvent.hasRegistrationPeriodInDegreeCurricularPlan() && !specializationDegreeRegistrationEvent.getRegistrationPeriodInDegreeCurricularPlan().containsDate(specializationDegreeRegistrationEvent.getRegistrationDate());
    }

    public FixedAmountWithPenaltyPR edit(Money fixedAmount, Money penaltyAmount) {
        this.deactivate();
        return new SpecializationDegreeRegistrationPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, penaltyAmount);
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        this.checkPreconditionsToProcess(event);
        return super.internalProcess(user, entryDTOs, event, fromAccount, toAccount, transactionDetail);
    }

    private void checkPreconditionsToProcess(Event event) {
        SpecializationDegreeRegistrationEvent specializationDegreeRegistrationEvent = (SpecializationDegreeRegistrationEvent)((Object)event);
        if (!specializationDegreeRegistrationEvent.hasRegistrationPeriodInDegreeCurricularPlan()) {
            throw new DomainException("error.accounting.postingRules.specializationDegree.SpecializationDegreeRegistrationPR.cannot.process.without.registration.period.defined", new String[0]);
        }
    }
}

