/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.ApprovementCertificateRequestPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class ApprovementCertificateRequestPR
extends ApprovementCertificateRequestPR_Base {
    private ApprovementCertificateRequestPR() {
    }

    public ApprovementCertificateRequestPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.init(EntryType.APPROVEMENT_CERTIFICATE_REQUEST_FEE, EventType.APPROVEMENT_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    public Money getAmountForUnits(Integer numberOfUnits) {
        if (numberOfUnits <= 1) {
            return Money.ZERO;
        }
        Money totalAmountOfUnits = this.getAmountPerUnit().multiply(new BigDecimal(numberOfUnits - 1));
        if (this.getMaximumAmount().greaterThan(Money.ZERO) && totalAmountOfUnits.greaterThan(this.getMaximumAmount())) {
            totalAmountOfUnits = this.getMaximumAmount();
        }
        return totalAmountOfUnits;
    }

    public ApprovementCertificateRequestPR edit(Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.deactivate();
        return new ApprovementCertificateRequestPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }
}

