/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.penaltyExemptionJustifications;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemption;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.penaltyExemptionJustifications.PenaltyExemptionJustificationByDispatch_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.YearMonthDay;

public class PenaltyExemptionJustificationByDispatch
extends PenaltyExemptionJustificationByDispatch_Base {
    protected PenaltyExemptionJustificationByDispatch() {
    }

    public PenaltyExemptionJustificationByDispatch(PenaltyExemption penaltyExemption, PenaltyExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this();
        this.init(penaltyExemption, justificationType, reason, dispatchDate);
    }

    private void init(PenaltyExemption penaltyExemption, PenaltyExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        super.init(penaltyExemption, justificationType, reason);
        this.checkParameters(justificationType, dispatchDate, reason);
        super.setPenaltyExemptionDispatchDate(dispatchDate);
    }

    private void checkParameters(PenaltyExemptionJustificationType justificationType, YearMonthDay dispatchDate, String reason) {
        if (dispatchDate == null || StringUtils.isEmpty((String)reason)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.events.penaltyExemptionJustifications.PenaltyExemptionJustificationByDispatch.dispatchDate.and.reason.are.required", new LabelFormatter(justificationType.getQualifiedName(), "resources.EnumerationResources"));
        }
    }

    public void setPenaltyExemptionDispatchDate(YearMonthDay penaltyExemptionDispatchDate) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.penaltyExemptionJustifications.PenaltyExemptionJustificationByDispatch.cannot.modify.penaltyExemptionDispatchDate", new String[0]);
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(this.getPenaltyExemptionJustificationType().getQualifiedName(), "resources.EnumerationResources");
        String penaltyExemptionDate = this.getPenaltyExemptionDispatchDate() != null ? this.getPenaltyExemptionDispatchDate().toString("dd/MM/yyyy") : "-";
        labelFormatter.appendLabel(" (").appendLabel("label.in", "resources.ApplicationResources").appendLabel(" ").appendLabel(penaltyExemptionDate).appendLabel(")");
        return labelFormatter;
    }
}

