/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentProjectDepartmentGroup;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="project")
@Deprecated
public class ProjectDepartmentGroup
extends FenixGroup {
    private static final long serialVersionUID = -4923251690424095397L;
    @GroupArgument
    private Project project;

    private ProjectDepartmentGroup() {
    }

    private ProjectDepartmentGroup(Project project) {
        this.project = project;
    }

    public static ProjectDepartmentGroup get(Project project) {
        return new ProjectDepartmentGroup(project);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.project.getName()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (Department department : this.project.getDeparmentsSet()) {
            for (Teacher teacher : department.getAllCurrentTeachers()) {
                User user = teacher.getPerson().getUser();
                if (user == null) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null || user.getPerson().getTeacher() == null) {
            return false;
        }
        Teacher teacher = user.getPerson().getTeacher();
        Department department = teacher.getDepartment();
        if (department != null) {
            return this.project.getDeparmentsSet().contains((Object)department);
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentProjectDepartmentGroup.getInstance(this.project);
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectDepartmentGroup) {
            return Objects.equal((Object)((Object)this.project), (Object)((Object)((ProjectDepartmentGroup)((Object)object)).project));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.project});
    }
}

