/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.SchoolClass_Base;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ResourceAllocationRolePredicates;
import org.fenixedu.bennu.core.domain.Bennu;

public class SchoolClass
extends SchoolClass_Base {
    public static final Comparator<SchoolClass> COMPARATOR_BY_NAME = new Comparator<SchoolClass>(){

        @Override
        public int compare(SchoolClass o1, SchoolClass o2) {
            int i = o1.getNome().compareTo(o2.getNome());
            return i == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : i;
        }
    };

    public SchoolClass(ExecutionDegree executionDegree, ExecutionSemester executionSemester, String name, Integer curricularYear) {
        this.checkIfExistsSchoolClassWithSameName(executionDegree, executionSemester, curricularYear, name);
        this.setRootDomainObject(Bennu.getInstance());
        this.setExecutionDegree(executionDegree);
        this.setExecutionPeriod(executionSemester);
        this.setAnoCurricular(curricularYear);
        this.setNome(name);
    }

    public SchoolClass(ExecutionDegree executionDegree, AcademicInterval academicInterval, String name, Integer curricularYear) {
        ExecutionSemester executionInterval = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(academicInterval));
        this.checkIfExistsSchoolClassWithSameName(executionDegree, executionInterval, curricularYear, name);
        this.setRootDomainObject(Bennu.getInstance());
        this.setExecutionDegree(executionDegree);
        this.setExecutionPeriod(executionInterval);
        this.setAnoCurricular(curricularYear);
        this.setNome(name);
    }

    public void edit(String name) {
        SchoolClass otherClassWithSameNewName;
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageSchoolClass);
        if (name != null && !StringUtils.isEmpty((String)name.trim()) && (otherClassWithSameNewName = this.getExecutionDegree().findSchoolClassesByExecutionPeriodAndName(this.getExecutionPeriod(), name.trim())) != null && !otherClassWithSameNewName.equals((Object)this)) {
            throw new DomainException("Duplicate Entry: " + otherClassWithSameNewName.getNome(), new String[0]);
        }
        this.setNome(name);
    }

    public void delete() {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageSchoolClass);
        this.getAssociatedShiftsSet().clear();
        this.getRegistrationsSet().clear();
        super.setExecutionDegree(null);
        super.setExecutionPeriod(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        if (executionDegree == null) {
            throw new DomainException("error.SchoolClass.empty.executionDegree", new String[0]);
        }
        super.setExecutionDegree(executionDegree);
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        if (executionSemester == null) {
            throw new DomainException("error.SchoolClass.empty.executionPeriod", new String[0]);
        }
        super.setExecutionPeriod(executionSemester);
    }

    public void setAnoCurricular(Integer anoCurricular) {
        if (anoCurricular == null || anoCurricular < 1) {
            throw new DomainException("error.SchoolClass.invalid.curricularYear", new String[0]);
        }
        super.setAnoCurricular(anoCurricular);
    }

    public void setNome(String name) {
        if (name == null || StringUtils.isEmpty((String)name.trim())) {
            throw new DomainException("error.SchoolClass.empty.name", new String[0]);
        }
        DegreeCurricularPlan degreeCurricularPlan = this.getExecutionDegree().getDegreeCurricularPlan();
        Degree degree = degreeCurricularPlan.getDegree();
        super.setNome(this.constructName(degree, name.trim(), this.getAnoCurricular()));
    }

    private void checkIfExistsSchoolClassWithSameName(ExecutionDegree executionDegree, ExecutionSemester executionSemester, Integer curricularYear, String className) {
        if (executionDegree != null && executionSemester != null && curricularYear != null && className != null) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            Set<SchoolClass> classes = executionDegree.findSchoolClassesByExecutionPeriodAndCurricularYear(executionSemester, curricularYear);
            Degree degree = degreeCurricularPlan.getDegree();
            String schoolClassName = degree.constructSchoolClassPrefix(curricularYear) + className;
            for (SchoolClass schoolClass : classes) {
                if (schoolClass.equals((Object)this) || !schoolClassName.equalsIgnoreCase(schoolClass.getNome())) continue;
                throw new DomainException("Duplicate Entry: " + className + " for curricular year " + curricularYear + " and degree curricular plan " + degreeCurricularPlan.getName(), new String[0]);
            }
        }
    }

    protected String constructName(Degree degree, String name, Integer curricularYear) {
        return degree.constructSchoolClassPrefix(curricularYear) + name;
    }

    public void associateShift(Shift shift) {
        if (shift == null) {
            throw new NullPointerException();
        }
        if (!this.getAssociatedShiftsSet().contains((Object)shift)) {
            this.getAssociatedShiftsSet().add(shift);
        }
        if (!shift.getAssociatedClassesSet().contains((Object)this)) {
            shift.getAssociatedClassesSet().add(this);
        }
    }

    public Set<Shift> findAvailableShifts() {
        ExecutionDegree executionDegree = this.getExecutionDegree();
        DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
        HashSet<Shift> shifts = new HashSet<Shift>();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            if (!curricularCourse.hasScopeForCurricularYear(this.getAnoCurricular(), this.getExecutionPeriod())) continue;
            for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                if (executionCourse.getExecutionPeriod() != this.getExecutionPeriod()) continue;
                shifts.addAll(executionCourse.getAssociatedShifts());
            }
        }
        shifts.removeAll(this.getAssociatedShiftsSet());
        return shifts;
    }

    public Object getEditablePartOfName() {
        DegreeCurricularPlan degreeCurricularPlan = this.getExecutionDegree().getDegreeCurricularPlan();
        Degree degree = degreeCurricularPlan.getDegree();
        return StringUtils.substringAfter((String)this.getNome(), (String)degree.constructSchoolClassPrefix(this.getAnoCurricular()));
    }

    public AcademicInterval getAcademicInterval() {
        return this.getExecutionPeriod().getAcademicInterval();
    }
}

