/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.QualificationBean;
import org.fenixedu.academic.domain.QualificationType;
import org.fenixedu.academic.domain.Qualification_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class Qualification
extends Qualification_Base {
    public static Comparator<Qualification> COMPARATOR_BY_YEAR = new Comparator<Qualification>(){

        @Override
        public int compare(Qualification o1, Qualification o2) {
            int year2;
            if (o1.getDateYearMonthDay() == null && o2.getDateYearMonthDay() == null) {
                return 0;
            }
            if (o1.getDateYearMonthDay() == null) {
                return -1;
            }
            if (o2.getDateYearMonthDay() == null) {
                return 1;
            }
            int year1 = o1.getDateYearMonthDay().getYear();
            return year1 < (year2 = o2.getDateYearMonthDay().getYear()) ? -1 : (year1 == year2 ? 0 : 1);
        }
    };
    public static Comparator<Qualification> COMPARATOR_BY_MOST_RECENT_ATTENDED_END = new Comparator<Qualification>(){

        @Override
        public int compare(Qualification o1, Qualification o2) {
            if (o1.getAttendedEnd() == null) {
                return 1;
            }
            if (o2.getAttendedEnd() == null) {
                return -1;
            }
            return -1 * o1.getAttendedEnd().compareTo((ReadablePartial)o2.getAttendedEnd());
        }
    };

    public Qualification() {
        this.setRootDomainObject(Bennu.getInstance());
        Person personLogin = AccessControl.getPerson();
        if (personLogin != null) {
            this.setCreator(personLogin);
            this.setModifiedBy(personLogin);
        }
        this.setLastModificationDateDateTime(new DateTime());
        this.setWhenCreated(new LocalDate());
    }

    public Qualification(Person person, PrecedentDegreeInformation precedentDegreeInformation) {
        this();
        this.setPerson(person);
        this.setMark(precedentDegreeInformation.getConclusionGrade() == null ? null : precedentDegreeInformation.getConclusionGrade());
        this.setSchool(precedentDegreeInformation.getInstitution() == null ? null : precedentDegreeInformation.getInstitution().getName());
        this.setDegree(precedentDegreeInformation.getDegreeDesignation() == null ? null : precedentDegreeInformation.getDegreeDesignation());
        this.setDateYearMonthDay(precedentDegreeInformation.getConclusionYear() == null ? null : new YearMonthDay(precedentDegreeInformation.getConclusionYear().intValue(), 1, 1));
        this.setCountry(precedentDegreeInformation.getCountry() == null ? null : precedentDegreeInformation.getCountry());
    }

    public Qualification(Person person, QualificationBean bean) {
        this();
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("error.Qualification.invalid.person", args);
        }
        this.checkAttendedPartials(bean.getAttendedBegin(), bean.getAttendedEnd());
        this.setPerson(person);
        this.setType(bean.getType());
        this.setSchool(bean.getSchool());
        this.setDegree(bean.getDegree());
        this.setAttendedBegin(bean.getAttendedBegin());
        this.setAttendedEnd(bean.getAttendedEnd());
        this.setMark(bean.getMark());
    }

    private void checkAttendedPartials(Partial attendedBegin, Partial attendedEnd) {
        if (attendedBegin != null && attendedEnd != null && attendedBegin.isAfter((ReadablePartial)attendedEnd)) {
            throw new DomainException("error.Qualification.invalid.attended.dates", new String[0]);
        }
    }

    public void setPerson(Person person) {
        super.setPerson(person);
    }

    public void delete() {
        super.setPerson(null);
        super.setCreator(null);
        this.setModifiedBy(null);
        this.setCountry(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public void edit(Person person, Country country, String branch, YearMonthDay dateYearMonthDay, String degree, String degreeRecognition, YearMonthDay equivalenceDateYearMonthDay, String equivalenceSchool, String mark, String school, String specializationArea, String title, QualificationType type, String year, String designation, Partial attendedBegin, Partial attendedEnd) {
        Person personLogin = AccessControl.getPerson();
        if (personLogin != null) {
            this.setModifiedBy(personLogin);
        }
        this.setBranch(branch);
        this.setDateYearMonthDay(dateYearMonthDay);
        this.setDegree(degree);
        this.setDegreeRecognition(degreeRecognition);
        this.setEquivalenceDateYearMonthDay(equivalenceDateYearMonthDay);
        this.setEquivalenceSchool(equivalenceSchool);
        this.setLastModificationDateDateTime(new DateTime());
        this.setMark(mark);
        this.setSchool(school);
        this.setSpecializationArea(specializationArea);
        this.setTitle(title);
        this.setType(type);
        this.setYear(year);
        this.setDesignation(designation);
        this.setAttendedBegin(attendedBegin);
        this.setAttendedEnd(attendedEnd);
        this.setPerson(person);
        this.setCountry(country);
    }

    @Deprecated
    public Date getDate() {
        YearMonthDay ymd = this.getDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setDate(Date date) {
        if (date == null) {
            this.setDateYearMonthDay(null);
        } else {
            this.setDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEquivalenceDate() {
        YearMonthDay ymd = this.getEquivalenceDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEquivalenceDate(Date date) {
        if (date == null) {
            this.setEquivalenceDateYearMonthDay(null);
        } else {
            this.setEquivalenceDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getLastModificationDate() {
        DateTime dt = this.getLastModificationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setLastModificationDate(Date date) {
        if (date == null) {
            this.setLastModificationDateDateTime(null);
        } else {
            this.setLastModificationDateDateTime(new DateTime(date.getTime()));
        }
    }
}

