/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Branch_Base;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.branch.BranchType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class Branch
extends Branch_Base {
    public Branch() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Branch(String name, String nameEn, String code, DegreeCurricularPlan degreeCurricularPlan) {
        this();
        this.setName(name);
        this.setNameEn(nameEn);
        this.setCode(code);
        this.setDegreeCurricularPlan(degreeCurricularPlan);
    }

    public Boolean representsCommonBranch() {
        if (this.getBranchType() != null && this.getBranchType().equals((Object)BranchType.COMNBR)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void edit(String name, String nameEn, String code) {
        this.setName(name);
        this.setNameEn(nameEn);
        this.setCode(code);
    }

    private Boolean canDeleteAllEligibleCurricularCourseScopes(Branch commonBranch) {
        for (CurricularCourseScope scope : this.getScopesSet()) {
            CurricularCourse curricularCourse = scope.getCurricularCourse();
            if (!this.hasCurricularCourseCommonBranchInAnyCurricularCourseScope(curricularCourse, commonBranch).booleanValue() || scope.isDeletable().booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.representsCommonBranch().booleanValue() && !this.getScopesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.branch.cant.delete", (String[])new String[0]));
        }
        if (!this.canDeleteAllEligibleCurricularCourseScopes(this.findCommonBranchForSameDegreeCurricularPlan()).booleanValue()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.branch.cant.delete", (String[])new String[0]));
        }
    }

    public void delete() throws DomainException {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        Branch commonBranch = this.findCommonBranchForSameDegreeCurricularPlan();
        this.getStudentCurricularPlansSet().clear();
        this.removeCurricularCourseScopes(commonBranch);
        this.setDegreeCurricularPlan(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    private void removeCurricularCourseScopes(Branch commonBranch) throws DomainException {
        Iterator branchCurricularCourseScopesIterator = this.getScopesSet().iterator();
        while (branchCurricularCourseScopesIterator.hasNext()) {
            CurricularCourseScope scope = (CurricularCourseScope)((Object)branchCurricularCourseScopesIterator.next());
            CurricularCourse curricularCourse = scope.getCurricularCourse();
            if (this.hasCurricularCourseCommonBranchInAnyCurricularCourseScope(curricularCourse, commonBranch).booleanValue()) {
                branchCurricularCourseScopesIterator.remove();
                scope.setBranch(null);
                scope.delete();
                continue;
            }
            branchCurricularCourseScopesIterator.remove();
            scope.setBranch(commonBranch);
        }
    }

    private Branch findCommonBranchForSameDegreeCurricularPlan() {
        for (Branch branch : this.getDegreeCurricularPlan().getAreasSet()) {
            if (!branch.representsCommonBranch().booleanValue() || !branch.getName().equals("")) continue;
            return branch;
        }
        return null;
    }

    private Boolean hasCurricularCourseCommonBranchInAnyCurricularCourseScope(CurricularCourse curricularCourse, final Branch commonBranch) {
        return (CurricularCourseScope)((Object)CollectionUtils.find((Collection)curricularCourse.getScopesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                CurricularCourseScope ccs = (CurricularCourseScope)((Object)o);
                return ccs.getBranch().equals((Object)commonBranch);
            }
        })) != null;
    }

    public static Branch readByBranchType(BranchType branchType) {
        for (Branch branch : Bennu.getInstance().getBranchsSet()) {
            if (branch.getBranchType() != branchType) continue;
            return branch;
        }
        return null;
    }

    public boolean isCommonBranch() {
        return this.getBranchType() == BranchType.COMNBR;
    }

    public boolean isSpecializationBranch() {
        return this.getBranchType() == BranchType.SPECBR;
    }

    public boolean isSecondaryBranch() {
        return this.getBranchType() == BranchType.SECNBR;
    }
}

