/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.FinalMark;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.teacher.gradeSubmission.MarkSheetTeacherGradeSubmissionBean;
import org.fenixedu.academic.dto.teacher.gradeSubmission.MarkSheetTeacherMarkBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.CreateMarkSheetByTeacher;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/markSheetManagement", module="teacher", functionality=ManageExecutionCourseDA.class)
@Forwards(value={@Forward(name="mainPage", path="/teacher/evaluation/finalEvaluationIndex.faces")})
public class MarkSheetTeacherManagementDispatchAction
extends ManageExecutionCourseDA {
    private ActionForward doForward(HttpServletRequest request, String path) {
        request.setAttribute("teacher$actual$page", (Object)path);
        return new ActionForward("/evaluation/evaluationFrame.jsp");
    }

    private void addMessage(HttpServletRequest request, ActionMessages actionMessages, String keyMessage, String ... args) {
        actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keyMessage, (Object[])args));
        this.saveMessages(request, actionMessages);
    }

    public ActionForward evaluationIndex(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.doForward(request, "/teacher/evaluation/evaluationIndex.jsp");
    }

    public ActionForward invalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("submissionBean", this.getObjectFromViewState("submissionBean-invisible"));
        RenderUtils.invalidateViewState();
        return this.doForward(request, "/teacher/evaluation/gradeSubmission/gradeSubmissionStepTwo.jsp");
    }

    public ActionForward prepareSubmitMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        if (!executionCourse.getAvailableGradeSubmission().booleanValue()) {
            this.addActionMessage(request, "error.teacher.gradeSubmission.gradeSubmission.not.available");
            return mapping.findForward("mainPage");
        }
        MarkSheetTeacherGradeSubmissionBean submissionBean = new MarkSheetTeacherGradeSubmissionBean();
        submissionBean.setExecutionCourse(executionCourse);
        request.setAttribute("submissionBean", (Object)submissionBean);
        return this.doForward(request, "/teacher/evaluation/gradeSubmission/gradeSubmissionStepOne.jsp");
    }

    public ActionForward gradeSubmissionStepOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetTeacherGradeSubmissionBean submissionBean = (MarkSheetTeacherGradeSubmissionBean)RenderUtils.getViewState().getMetaObject().getObject();
        request.setAttribute("submissionBean", (Object)submissionBean);
        ActionMessages actionMessages = new ActionMessages();
        boolean canSubmitMarksAnyCurricularCourse = this.checkIfCanSubmitMarksToAnyCurricularCourse(submissionBean.getAllCurricularCourses(), submissionBean.getExecutionCourse().getExecutionPeriod(), request, actionMessages);
        this.calculateMarksToSubmit(request, submissionBean);
        request.setAttribute("executionCourse", (Object)submissionBean.getExecutionCourse());
        if (submissionBean.getMarksToSubmit().isEmpty()) {
            this.addMessage(request, actionMessages, !canSubmitMarksAnyCurricularCourse ? "error.teacher.gradeSubmission.noStudentsToSubmitMarksInPeriods" : "error.teacher.gradeSubmission.noStudentsToSubmitMarks", new String[0]);
            return this.doForward(request, "/teacher/evaluation/gradeSubmission/gradeSubmissionStepOne.jsp");
        }
        return this.doForward(request, "/teacher/evaluation/gradeSubmission/gradeSubmissionStepTwo.jsp");
    }

    public ActionForward gradeSubmissionStepTwo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        User userView = MarkSheetTeacherManagementDispatchAction.getUserView(request);
        MarkSheetTeacherGradeSubmissionBean submissionBean = (MarkSheetTeacherGradeSubmissionBean)RenderUtils.getViewState((String)"submissionBean-invisible").getMetaObject().getObject();
        submissionBean.setResponsibleTeacher(userView.getPerson().getTeacher());
        ActionMessages actionMessages = new ActionMessages();
        request.setAttribute("executionCourse", (Object)submissionBean.getExecutionCourse());
        try {
            List<EnrolmentEvaluation> marksSubmited = CreateMarkSheetByTeacher.run(submissionBean);
            request.setAttribute("marksSubmited", marksSubmited);
            return this.doForward(request, "/teacher/evaluation/gradeSubmission/viewGradesSubmited.jsp");
        }
        catch (IllegalDataAccessException e) {
            this.addMessage(request, actionMessages, "error.notAuthorized", new String[0]);
        }
        catch (InvalidArgumentsServiceException e) {
            this.addMessage(request, actionMessages, e.getMessage(), new String[0]);
        }
        catch (DomainException e) {
            this.addMessage(request, actionMessages, e.getMessage(), e.getArgs());
        }
        request.setAttribute("submissionBean", (Object)submissionBean);
        return this.doForward(request, "/teacher/evaluation/gradeSubmission/gradeSubmissionStepTwo.jsp");
    }

    public ActionForward backToMainPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        return mapping.findForward("mainPage");
    }

    private void calculateMarksToSubmit(HttpServletRequest request, MarkSheetTeacherGradeSubmissionBean submissionBean) {
        HashSet<MarkSheetTeacherMarkBean> marksToSubmit = new HashSet<MarkSheetTeacherMarkBean>();
        ArrayList<Student> studentsWithImpossibleEnrolments = new ArrayList<Student>();
        for (Enrolment enrolment : this.getEnrolmentsNotInAnyMarkSheet(submissionBean)) {
            if (enrolment.isImpossible()) {
                Student student = enrolment.getStudentCurricularPlan().getRegistration().getStudent();
                if (studentsWithImpossibleEnrolments.contains((Object)student)) continue;
                studentsWithImpossibleEnrolments.add(student);
                continue;
            }
            Attends attends = enrolment.getAttendsByExecutionCourse(submissionBean.getExecutionCourse());
            if (attends == null) continue;
            marksToSubmit.add(new MarkSheetTeacherMarkBean(attends, submissionBean.getEvaluationDate(), this.getMark(attends), this.getEvaluationSeason(submissionBean, enrolment), this.getMark(attends).length() != 0));
        }
        submissionBean.setMarksToSubmit(marksToSubmit);
        request.setAttribute("studentsWithImpossibleEnrolments", studentsWithImpossibleEnrolments);
    }

    private EvaluationSeason getEvaluationSeason(MarkSheetTeacherGradeSubmissionBean submissionBean, Enrolment enrolment) {
        return enrolment.isImprovementForExecutionCourse(submissionBean.getExecutionCourse()) ? EvaluationSeason.readImprovementSeason() : enrolment.getEvaluationSeason();
    }

    private String getMark(Attends attends) {
        FinalMark finalMark = attends.getFinalMark();
        return finalMark != null ? finalMark.getMark() : "";
    }

    private Collection<Enrolment> getEnrolmentsNotInAnyMarkSheet(MarkSheetTeacherGradeSubmissionBean submissionBean) {
        HashSet<Enrolment> enrolmentsNotInAnyMarkSheet = new HashSet<Enrolment>();
        for (CurricularCourse curricularCourse : submissionBean.getAllCurricularCourses()) {
            for (EvaluationSeason season : EvaluationConfiguration.getInstance().getEvaluationSeasonSet()) {
                if (!season.isGradeSubmissionAvailable(curricularCourse, submissionBean.getExecutionCourse().getExecutionPeriod())) continue;
                enrolmentsNotInAnyMarkSheet.addAll(curricularCourse.getEnrolmentsNotInAnyMarkSheet(season, submissionBean.getExecutionCourse().getExecutionPeriod()));
            }
        }
        return enrolmentsNotInAnyMarkSheet;
    }

    private boolean checkIfCanSubmitMarksToAnyCurricularCourse(Collection<CurricularCourse> curricularCourses, ExecutionSemester executionSemester, HttpServletRequest request, ActionMessages actionMessages) {
        boolean result = true;
        String dateFormat = "dd/MM/yyyy";
        for (CurricularCourse curricularCourse : curricularCourses) {
            if (curricularCourse.isGradeSubmissionAvailableFor(executionSemester)) continue;
            ExecutionDegree executionDegree = curricularCourse.getExecutionDegreeFor(executionSemester.getExecutionYear());
            this.addMessage(request, actionMessages, "error.teacher.gradeSubmission.invalid.date.for.curricularCourse", curricularCourse.getDegreeCurricularPlan().getName() + " > " + curricularCourse.getName());
            EvaluationSeason.all().forEach(season -> this.addMessageGradeSubmissionPeriods(request, actionMessages, dateFormat, (EvaluationSeason)season, executionDegree));
            result = false;
        }
        return result;
    }

    private void addMessageGradeSubmissionPeriods(HttpServletRequest request, ActionMessages actionMessages, String dateFormat, EvaluationSeason season, ExecutionDegree executionDegree) {
        String period = season.getGradeSubmissionPeriods(executionDegree, null).map(o -> o.getStartYearMonthDay().toString(dateFormat) + "-" + o.getEndYearMonthDay().toString(dateFormat)).collect(Collectors.joining(", "));
        if (!Strings.isNullOrEmpty((String)period)) {
            this.addMessage(request, actionMessages, "error.teacher.gradeSubmission.dates", season.getName().getContent(), period);
        }
    }

    public ActionForward viewSubmitedMarkSheets(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        Collection<MarkSheet> associatedMarkSheets = executionCourse.getAssociatedMarkSheets();
        request.setAttribute("markSheets", associatedMarkSheets);
        request.setAttribute("executionCourseID", (Object)executionCourse.getExternalId());
        return this.doForward(request, "/teacher/evaluation/gradeSubmission/viewSubmitedMarkSheets.jsp");
    }

    public ActionForward viewMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        String markSheetID = request.getParameter("msID");
        MarkSheet markSheet = (MarkSheet)FenixFramework.getDomainObject((String)markSheetID);
        request.setAttribute("markSheet", (Object)markSheet);
        request.setAttribute("executionCourseID", (Object)executionCourse.getExternalId());
        return this.doForward(request, "/teacher/evaluation/gradeSubmission/viewMarkSheet.jsp");
    }
}

