/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.enrollment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.EnrolmentPeriodInSpecialSeasonEvaluations;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.student.enrollment.bolonha.SpecialSeasonBolonhaStudentEnrolmentBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha.AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.academic.ui.struts.action.student.enrollment.SpecialSeasonStudentEnrollmentBean;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentApplication.StudentEnrollApp.class, path="special-season", titleKey="link.specialSeason.enrolment")
@Mapping(path="/enrollment/evaluations/specialSeason", module="student")
@Forwards(value={@Forward(name="showDegreeModulesToEnrol", path="/student/enrollment/evaluations/specialSeasonShowDegreeModules.jsp"), @Forward(name="showPickSCPAndSemester", path="/student/enrollment/evaluations/specialSeasonPickSCPAndSemester.jsp"), @Forward(name="showStudentEnrollmentMenu", path="/student/enrollment/evaluations/specialSeason.jsp")})
public class SpecialSeasonStudentEnrollmentDA
extends AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA {
    @EntryPoint
    public ActionForward entryPoint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getLoggedStudent(request);
        List<StudentCurricularPlan> scps = this.generateSCPList(student);
        if (this.enrollmentPeriodNotOpen(new ArrayList<StudentCurricularPlan>(scps))) {
            EnrolmentPeriodInSpecialSeasonEvaluations enrolmentPeriod = this.getNextEnrollmentPeriod(scps);
            if (enrolmentPeriod == null) {
                this.addActionMessage("warning", request, "message.out.curricular.course.enrolment.period.default");
                request.setAttribute("disableContinue", (Object)true);
            } else {
                this.addActionMessage("warning", request, "message.out.special.season.enrolment.period.upcoming", enrolmentPeriod.getStartDateDateTime().toString("dd-MM-yyyy"), enrolmentPeriod.getEndDateDateTime().toString("dd-MM-yyyy"));
                request.setAttribute("disableContinue", (Object)true);
            }
        } else if (this.hasPendingDebts(student)) {
            this.addActionMessage("error", request, "error.special.season.cannot.enroll.due.to.pending.debts");
            request.setAttribute("disableContinue", (Object)true);
        } else if (scps.isEmpty()) {
            request.setAttribute("disableContinue", (Object)true);
        }
        return mapping.findForward("showStudentEnrollmentMenu");
    }

    public ActionForward pickSCP(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getLoggedStudent(request);
        SpecialSeasonStudentEnrollmentBean bean = new SpecialSeasonStudentEnrollmentBean(student);
        List<StudentCurricularPlan> scps = this.generateSCPList(student);
        if (scps.size() == 1) {
            bean.setScp(scps.iterator().next());
        } else {
            request.setAttribute("scps", scps);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("showPickSCPAndSemester");
    }

    public ActionForward pickSemester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getLoggedStudent(request);
        String scpOid = request.getParameter("scpOid");
        StudentCurricularPlan scp = (StudentCurricularPlan)FenixFramework.getDomainObject((String)scpOid);
        SpecialSeasonStudentEnrollmentBean bean = new SpecialSeasonStudentEnrollmentBean(student, scp);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("showPickSCPAndSemester");
    }

    public ActionForward showDegreeModules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SpecialSeasonStudentEnrollmentBean bean = (SpecialSeasonStudentEnrollmentBean)this.getRenderedObject("bean");
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)new SpecialSeasonBolonhaStudentEnrolmentBean(bean.getScp(), bean.getExecutionSemester(), EvaluationSeason.readSpecialSeason()));
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    private Student getLoggedStudent(HttpServletRequest request) {
        return this.getLoggedPerson(request).getStudent();
    }

    private final List<StudentCurricularPlan> generateSCPList(Student student) {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        for (Registration registration : student.getRegistrationsSet()) {
            if (!registration.isActive() && !registration.hasAnyEnrolmentsIn(ExecutionYear.readCurrentExecutionYear())) continue;
            result.add(registration.getLastStudentCurricularPlan());
        }
        return result;
    }

    private boolean enrollmentPeriodNotOpen(List<StudentCurricularPlan> scps) {
        if (scps.isEmpty()) {
            return true;
        }
        StudentCurricularPlan scp = scps.iterator().next();
        scps.remove(0);
        return !scp.getDegreeCurricularPlan().hasOpenSpecialSeasonEnrolmentPeriod(ExecutionYear.readCurrentExecutionYear().getFirstExecutionPeriod()) && !scp.getDegreeCurricularPlan().hasOpenSpecialSeasonEnrolmentPeriod(ExecutionYear.readCurrentExecutionYear().getLastExecutionPeriod()) && !scp.getDegreeCurricularPlan().hasOpenSpecialSeasonEnrolmentPeriod(ExecutionYear.readCurrentExecutionYear().getPreviousExecutionYear().getFirstExecutionPeriod()) && !scp.getDegreeCurricularPlan().hasOpenSpecialSeasonEnrolmentPeriod(ExecutionYear.readCurrentExecutionYear().getPreviousExecutionYear().getLastExecutionPeriod()) && this.enrollmentPeriodNotOpen(scps);
    }

    private EnrolmentPeriodInSpecialSeasonEvaluations getNextEnrollmentPeriod(List<StudentCurricularPlan> scps) {
        ArrayList<EnrolmentPeriodInSpecialSeasonEvaluations> nextOpenPeriodsForEachSCP = new ArrayList<EnrolmentPeriodInSpecialSeasonEvaluations>();
        for (StudentCurricularPlan scp : scps) {
            EnrolmentPeriodInSpecialSeasonEvaluations result = scp.getDegreeCurricularPlan().getNextSpecialSeasonEnrolmentPeriod();
            if (result == null) continue;
            nextOpenPeriodsForEachSCP.add(result);
        }
        return nextOpenPeriodsForEachSCP.isEmpty() ? null : Collections.min(nextOpenPeriodsForEachSCP, EnrolmentPeriodInSpecialSeasonEvaluations.COMPARATOR_BY_START);
    }

    private boolean hasPendingDebts(Student student) {
        return SpecialSeasonStudentEnrollmentDA.hasAnyAdministrativeOfficeFeeAndInsuranceInDebt(student, ExecutionYear.readCurrentExecutionYear()) || SpecialSeasonStudentEnrollmentDA.hasAnyGratuityDebt(student, ExecutionYear.readCurrentExecutionYear()) || SpecialSeasonStudentEnrollmentDA.hasAnyAdministrativeOfficeFeeAndInsuranceInDebt(student, ExecutionYear.readCurrentExecutionYear().getPreviousExecutionYear()) || SpecialSeasonStudentEnrollmentDA.hasAnyGratuityDebt(student, ExecutionYear.readCurrentExecutionYear().getPreviousExecutionYear());
    }

    @Override
    protected String getAction() {
        return "/enrollment/evaluations/specialSeason.do";
    }
}

