/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.person;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.EmergencyContact;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.person.VisualizePersonalInfo;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(module="person", path="/updateEmergencyContact", functionality=VisualizePersonalInfo.class)
@Forwards(value={@Forward(name="visualizePersonalInformation", path="/person/visualizePersonalInfo.jsp")})
public class UpdateEmergencyContactDA
extends FenixDispatchAction {
    public ActionForward updateEmergencyContact(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EmergencyContactBean emergencyContactBean = (EmergencyContactBean)this.getRenderedObject();
        Person person = this.getLoggedPerson(request);
        try {
            EmergencyContact.updateEmergencyContact(person.getProfile(), emergencyContactBean.getContact());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey());
            request.setAttribute("personBean", (Object)new PersonBean(person));
            request.setAttribute("emergencyContactBean", (Object)new EmergencyContactBean(person));
        }
        request.setAttribute("personBean", (Object)new PersonBean(person));
        request.setAttribute("emergencyContactBean", (Object)emergencyContactBean);
        return mapping.findForward("visualizePersonalInformation");
    }

    public static class EmergencyContactBean
    implements Serializable {
        String contact;

        public EmergencyContactBean() {
        }

        public EmergencyContactBean(String emergencyContact) {
            this.setContact(emergencyContact);
        }

        public EmergencyContactBean(EmergencyContact emergencyContact) {
            this.setContact(emergencyContact.getContact());
        }

        public EmergencyContactBean(Person loggedUser) {
            EmergencyContact emergencyContact;
            EmergencyContact emergencyContact2 = emergencyContact = loggedUser.getProfile() == null ? null : loggedUser.getProfile().getEmergencyContact();
            if (emergencyContact != null) {
                this.setContact(emergencyContact.getContact());
            }
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }
    }
}

