/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalSupervision.consult;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.dto.student.ExecutionPeriodStatisticsBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.externalSupervision.ExternalSupervisionApplication;
import org.fenixedu.academic.ui.struts.action.externalSupervision.consult.ExternalSupervisorViewsBean;
import org.fenixedu.academic.ui.struts.action.externalSupervision.consult.ShowThesisStatus;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ExternalSupervisionApplication.ExternalSupervisionConsultApp.class, path="student", titleKey="title.section.viewStudent")
@Mapping(path="/viewStudent", module="externalSupervision")
@Forwards(value={@Forward(name="selectStudent", path="/externalSupervision/consult/selectStudent.jsp"), @Forward(name="showStats", path="/externalSupervision/consult/showStats.jsp")})
public class ExternalSupervisorViewStudentDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward beginTaskFlow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        User userView = Authenticate.getUser();
        Person supervisor = userView.getPerson();
        RegistrationProtocol protocol = supervisor.getOnlyRegistrationProtocol();
        ExternalSupervisorViewsBean bean = protocol == null ? new ExternalSupervisorViewsBean() : new ExternalSupervisorViewsBean(protocol);
        request.setAttribute("sessionBean", (Object)bean);
        return mapping.findForward("selectStudent");
    }

    public ActionForward showStats(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        boolean isOmnipotent;
        ExternalSupervisorViewsBean bean = (ExternalSupervisorViewsBean)this.getRenderedObject("sessionBean");
        User userView = Authenticate.getUser();
        Person supervisor = userView.getPerson();
        Set jurisdictions = supervisor.getRegistrationProtocolsSet();
        if (bean == null) {
            String personId = request.getParameter("personId");
            Person student = (Person)FenixFramework.getDomainObject((String)personId);
            RegistrationProtocol protocol = supervisor.getOnlyRegistrationProtocol();
            if (protocol == null) {
                bean = new ExternalSupervisorViewsBean(student);
                isOmnipotent = true;
            } else {
                bean = new ExternalSupervisorViewsBean(student, protocol);
                isOmnipotent = false;
            }
        } else {
            isOmnipotent = bean.getProtocol() == null;
        }
        if (!bean.supervisorHasPermission(isOmnipotent, jurisdictions)) {
            Boolean errorNoPermission = true;
            request.setAttribute("errorNoPermission", (Object)errorNoPermission);
            return mapping.findForward("selectStudent");
        }
        Person personStudent = bean.getStudent();
        Set<Registration> registrations = personStudent.getStudent().getRegistrationsSet();
        List<ExecutionPeriodStatisticsBean> studentStatistics = this.getStudentStatistics(registrations);
        if (ShowThesisStatus.hasDissertations(personStudent.getStudent())) {
            Boolean hasDissertations = true;
            request.setAttribute("hasDissertations", (Object)hasDissertations);
        }
        request.setAttribute("studentStatistics", studentStatistics);
        request.setAttribute("sessionBean", (Object)bean);
        return mapping.findForward("showStats");
    }

    public ActionForward invalidStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExternalSupervisorViewsBean bean = (ExternalSupervisorViewsBean)this.getRenderedObject("sessionBean");
        request.setAttribute("sessionBean", (Object)bean);
        RenderUtils.invalidateViewState((String)"sessionBean");
        return mapping.findForward("selectStudent");
    }

    private List<ExecutionPeriodStatisticsBean> getStudentStatistics(Collection<Registration> registrations) {
        ArrayList<ExecutionPeriodStatisticsBean> studentStatistics = new ArrayList<ExecutionPeriodStatisticsBean>();
        HashMap<ExecutionSemester, ExecutionPeriodStatisticsBean> enrolmentsByExecutionPeriod = new HashMap<ExecutionSemester, ExecutionPeriodStatisticsBean>();
        for (Registration registration : registrations) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                for (ExecutionSemester executionSemester : studentCurricularPlan.getEnrolmentsExecutionPeriods()) {
                    ExecutionPeriodStatisticsBean executionPeriodStatisticsBean;
                    if (enrolmentsByExecutionPeriod.containsKey(executionSemester)) {
                        executionPeriodStatisticsBean = (ExecutionPeriodStatisticsBean)enrolmentsByExecutionPeriod.get(executionSemester);
                        executionPeriodStatisticsBean.addEnrolmentsWithinExecutionPeriod(studentCurricularPlan.getEnrolmentsByExecutionPeriod(executionSemester));
                        enrolmentsByExecutionPeriod.put(executionSemester, executionPeriodStatisticsBean);
                        continue;
                    }
                    executionPeriodStatisticsBean = new ExecutionPeriodStatisticsBean(executionSemester);
                    executionPeriodStatisticsBean.addEnrolmentsWithinExecutionPeriod(studentCurricularPlan.getEnrolmentsByExecutionPeriod(executionSemester));
                    enrolmentsByExecutionPeriod.put(executionSemester, executionPeriodStatisticsBean);
                }
            }
        }
        studentStatistics.addAll(enrolmentsByExecutionPeriod.values());
        return studentStatistics;
    }
}

