/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.payments;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.debts.ExternalScholarshipPhdGratuityContribuitionEvent;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityExternalScholarshipExemption;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.payments.ExternalScholarshipManagementDebtsDA$callable$liquidate;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Mapping(path="/fctDebts", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="selectPhdStudent", path="/academicAdminOffice/payments/selectPhdStudent.jsp"), @Forward(name="showScolarship", path="/academicAdminOffice/payments/showScolarship.jsp")})
public class ExternalScholarshipManagementDebtsDA
extends FenixDispatchAction {
    public static final Advice advice$liquidate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PhdIndividualProgramProcess getProcess(HttpServletRequest request) {
        String processIdAttribute = (String)request.getAttribute("processId");
        return (PhdIndividualProgramProcess)FenixFramework.getDomainObject((String)(processIdAttribute != null ? processIdAttribute : request.getParameter("processId")));
    }

    public ActionForward viewDebtsForProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        ArrayList<PhdGratuityExternalScholarshipExemption> list = new ArrayList<PhdGratuityExternalScholarshipExemption>();
        for (Event event : process2.getPerson().getEventsSet()) {
            if (!(event instanceof PhdGratuityEvent)) continue;
            for (Exemption exemption : event.getExemptionsSet()) {
                if (!(exemption instanceof PhdGratuityExternalScholarshipExemption)) continue;
                PhdGratuityExternalScholarshipExemption phdExemption = (PhdGratuityExternalScholarshipExemption)((Object)exemption);
                list.add(phdExemption);
            }
        }
        request.setAttribute("person", (Object)process2.getPerson());
        request.setAttribute("debts", list);
        return mapping.findForward("selectPhdStudent");
    }

    public ActionForward prepareLiquidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String exemptionId = request.getParameter("exemptiontId");
        PhdGratuityExternalScholarshipExemption exemption = (PhdGratuityExternalScholarshipExemption)FenixFramework.getDomainObject((String)exemptionId);
        request.setAttribute("processId", (Object)((PhdGratuityEvent)((Object)exemption.getEvent())).getPhdIndividualProgramProcess().getExternalId());
        request.setAttribute("exemption", (Object)exemption);
        request.setAttribute("person", (Object)exemption.getEvent().getPerson());
        AmountBean bean = new AmountBean();
        bean.setValue(exemption.getAmoutStillMissing());
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("showScolarship");
    }

    public ActionForward liquidate(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$liquidate.perform((Callable)new ExternalScholarshipManagementDebtsDA$callable$liquidate(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$liquidate(ExternalScholarshipManagementDebtsDA this_, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String exemptionId = request.getParameter("externalId");
        PhdGratuityExternalScholarshipExemption exemption = (PhdGratuityExternalScholarshipExemption)FenixFramework.getDomainObject((String)(exemptionId == null ? (String)request.getAttribute("externalId") : exemptionId));
        ExternalScholarshipPhdGratuityContribuitionEvent event = exemption.getExternalScholarshipPhdGratuityContribuitionEvent();
        AmountBean bean = (AmountBean)this_.getRenderedObject("bean");
        ArrayList<EntryDTO> list = new ArrayList<EntryDTO>();
        list.add(new EntryDTO(EntryType.EXTERNAL_SCOLARSHIP_PAYMENT, (Event)((Object)event), bean.getValue()));
        event.process(Authenticate.getUser(), list, new AccountingTransactionDetailDTO(bean.getPaymentDate(), PaymentMode.CASH));
        PhdGratuityEvent gratuityEvent = (PhdGratuityEvent)((Object)exemption.getEvent());
        PhdIndividualProgramProcess process2 = gratuityEvent.getPhdIndividualProgramProcess();
        request.setAttribute("processId", (Object)process2.getExternalId());
        return this_.viewDebtsForProcess(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String exemptionId = request.getParameter("externalId");
        PhdGratuityExternalScholarshipExemption exemption = (PhdGratuityExternalScholarshipExemption)FenixFramework.getDomainObject((String)(exemptionId == null ? (String)request.getAttribute("externalId") : exemptionId));
        PhdGratuityEvent event = (PhdGratuityEvent)((Object)exemption.getEvent());
        PhdIndividualProgramProcess process2 = event.getPhdIndividualProgramProcess();
        request.setAttribute("processId", (Object)process2.getExternalId());
        return this.viewDebtsForProcess(mapping, form, request, response);
    }

    public static class AmountBean
    implements Serializable {
        private Money value;
        private DateTime paymentDate;

        public Money getValue() {
            return this.value;
        }

        public void setValue(Money value) {
            this.value = value;
        }

        public DateTime getPaymentDate() {
            return this.paymentDate;
        }

        public void setPaymentDate(DateTime paymentDate) {
            this.paymentDate = paymentDate;
        }
    }
}

