/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.MarkSheetState;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementSearchBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetSearchResultBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.administrativeOffice.gradeSubmission.SearchMarkSheets;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.manager.RemoveGradesFromConfirmedMarkSheet;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetDocument;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetSearchDispatchAction$callable$markAsPrinted;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetSearchDispatchAction$callable$markAsPrinted$1;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminMarksheetApp.class, path="search", titleKey="link.markSheet.management")
@Mapping(path="/markSheetManagement", module="academicAdministration", formBean="markSheetManagementForm", input="/gradeSubmission/markSheetManagement.jsp")
@Forwards(value={@Forward(name="searchMarkSheet", path="/academicAdministration/gradeSubmission/markSheetManagement.jsp"), @Forward(name="viewMarkSheet", path="/academicAdministration/gradeSubmission/viewMarkSheet.jsp"), @Forward(name="removeMarkSheet", path="/academicAdministration/gradeSubmission/removeMarkSheet.jsp"), @Forward(name="searchMarkSheetFilled", path="/academicAdministration/markSheetManagement.do?method=prepareSearchMarkSheetFilled"), @Forward(name="confirmMarkSheet", path="/academicAdministration/gradeSubmission/confirmMarkSheet.jsp"), @Forward(name="listMarkSheet", path="/manager/markSheet/viewMarkSheet.jsp"), @Forward(name="choosePrinterMarkSheetsWeb", path="/academicAdministration/gradeSubmission/choosePrinterMarkSheetsWeb_bd.jsp")})
public class MarkSheetSearchDispatchAction
extends MarkSheetDispatchAction {
    public static final Advice advice$markAsPrinted = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$markAsPrinted$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @EntryPoint
    public ActionForward prepareSearchMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementSearchBean markSheetManagementSearchBean = new MarkSheetManagementSearchBean();
        markSheetManagementSearchBean.setExecutionPeriod(ExecutionSemester.readActualExecutionSemester());
        request.setAttribute("edit", (Object)markSheetManagementSearchBean);
        return mapping.findForward("searchMarkSheet");
    }

    public ActionForward prepareSearchMarkSheetFilled(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MarkSheetManagementSearchBean markSheetBean = new MarkSheetManagementSearchBean();
        this.fillMarkSheetSearchBean(actionForm, request, markSheetBean);
        if (markSheetBean.getCurricularCourse() == null) {
            return this.prepareSearchMarkSheet(mapping, actionForm, request, response);
        }
        return this.searchMarkSheets(mapping, actionForm, request, response, markSheetBean);
    }

    public ActionForward searchMarkSheets(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MarkSheetManagementSearchBean searchBean = (MarkSheetManagementSearchBean)RenderUtils.getViewState().getMetaObject().getObject();
        return this.searchMarkSheets(mapping, actionForm, request, response, searchBean);
    }

    private ActionForward searchMarkSheets(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, MarkSheetManagementSearchBean searchBean) throws FenixServiceException {
        ActionMessages actionMessages = this.createActionMessages();
        try {
            Map<EvaluationSeason, MarkSheetSearchResultBean> result = SearchMarkSheets.run(searchBean);
            request.setAttribute("edit", (Object)searchBean);
            request.setAttribute("searchResult", result);
            request.setAttribute("url", (Object)this.buildSearchUrl(searchBean));
        }
        catch (InvalidArgumentsServiceException e) {
            this.addMessage(request, actionMessages, e.getMessage(), new String[0]);
        }
        return mapping.getInputForward();
    }

    protected void fillMarkSheetSearchBean(ActionForm actionForm, HttpServletRequest request, MarkSheetManagementSearchBean markSheetBean) {
        DynaActionForm form = (DynaActionForm)actionForm;
        this.fillMarkSheetBean(actionForm, request, markSheetBean);
        if (form.getString("tn") != null && form.getString("tn").length() != 0) {
            markSheetBean.setTeacherId(form.getString("tn"));
        }
        try {
            markSheetBean.setEvaluationDate(DateFormatUtil.parse("dd/MM/yyyy", form.getString("ed")));
        }
        catch (ParseException e) {
            markSheetBean.setEvaluationDate(null);
        }
        if (form.getString("mss") != null && form.getString("mss").length() != 0) {
            markSheetBean.setMarkSheetState(MarkSheetState.valueOf(form.getString("mss")));
        }
        if (form.getString("mst") != null && form.getString("mst").length() != 0) {
            markSheetBean.setEvaluationSeason((EvaluationSeason)FenixFramework.getDomainObject((String)form.getString("mst")));
        }
    }

    private String buildSearchUrl(MarkSheetManagementSearchBean searchBean) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&epID=").append(searchBean.getExecutionPeriod().getExternalId());
        stringBuilder.append("&dID=").append(searchBean.getDegree().getExternalId());
        stringBuilder.append("&dcpID=").append(searchBean.getDegreeCurricularPlan().getExternalId());
        stringBuilder.append("&ccID=").append(searchBean.getCurricularCourse().getExternalId());
        if (searchBean.getTeacherId() != null) {
            stringBuilder.append("&tn=").append(searchBean.getTeacherId());
        }
        if (searchBean.getEvaluationDate() != null) {
            stringBuilder.append("&ed=").append(DateFormatUtil.format("dd/MM/yyyy", searchBean.getEvaluationDate()));
        }
        if (searchBean.getMarkSheetState() != null) {
            stringBuilder.append("&mss=").append(searchBean.getMarkSheetState().getName());
        }
        if (searchBean.getEvaluationSeason() != null) {
            stringBuilder.append("&mst=").append(searchBean.getEvaluationSeason().getExternalId());
        }
        return stringBuilder.toString();
    }

    public ActionForward prepareViewRectificationMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        EnrolmentEvaluation enrolmentEvaluation = (EnrolmentEvaluation)((Object)this.getDomainObject(form, "evaluationID"));
        MarkSheet markSheet = enrolmentEvaluation.getRectificationMarkSheet();
        request.setAttribute("markSheet", (Object)markSheet);
        request.setAttribute("url", (Object)this.buildUrl(form));
        return mapping.findForward("viewMarkSheet");
    }

    public ActionForward searchConfirmedMarkSheets(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementSearchBean searchBean = (MarkSheetManagementSearchBean)this.getRenderedObject();
        ArrayList<MarkSheet> result = new ArrayList<MarkSheet>();
        for (MarkSheet markSheet : searchBean.getCurricularCourse().getMarkSheetsSet()) {
            if (markSheet.getExecutionPeriod() != searchBean.getExecutionPeriod() || !markSheet.isConfirmed()) continue;
            result.add(markSheet);
        }
        request.setAttribute("edit", (Object)searchBean);
        request.setAttribute("searchResult", result);
        request.setAttribute("url", (Object)this.buildSearchUrl(searchBean));
        return mapping.findForward("searchMarkSheet");
    }

    public ActionForward listMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        MarkSheet markSheet = (MarkSheet)((Object)this.getDomainObject(form, "msID"));
        request.setAttribute("markSheet", (Object)markSheet);
        request.setAttribute("url", (Object)this.buildUrl(form));
        return mapping.findForward("listMarkSheet");
    }

    public ActionForward searchConfirmedMarkSheetsFilled(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementSearchBean searchBean = new MarkSheetManagementSearchBean();
        this.fillMarkSheetBean(actionForm, request, searchBean);
        ArrayList<MarkSheet> result = new ArrayList<MarkSheet>();
        for (MarkSheet markSheet : searchBean.getCurricularCourse().getMarkSheetsSet()) {
            if (markSheet.getExecutionPeriod() != searchBean.getExecutionPeriod() || !markSheet.isConfirmed()) continue;
            result.add(markSheet);
        }
        request.setAttribute("edit", (Object)searchBean);
        request.setAttribute("searchResult", result);
        request.setAttribute("url", (Object)this.buildSearchUrl(searchBean));
        return mapping.findForward("searchMarkSheet");
    }

    public ActionForward removeGrades(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DynaActionForm form = (DynaActionForm)actionForm;
        MarkSheet markSheet = (MarkSheet)((Object)this.getDomainObject(form, "msID"));
        List<EnrolmentEvaluation> evaluations = this.getEvaluationsToRemove(form);
        try {
            RemoveGradesFromConfirmedMarkSheet.run(markSheet, evaluations);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.listMarkSheet(mapping, actionForm, request, response);
        }
        return this.prepareSearchMarkSheetFilled(mapping, actionForm, request, response);
    }

    private List<EnrolmentEvaluation> getEvaluationsToRemove(DynaActionForm actionForm) {
        String[] evaluationsToRemove;
        ArrayList<EnrolmentEvaluation> res = new ArrayList<EnrolmentEvaluation>();
        for (String eeID : evaluationsToRemove = (String[])actionForm.get("evaluationsToRemove")) {
            EnrolmentEvaluation enrolmentEvaluation = (EnrolmentEvaluation)FenixFramework.getDomainObject((String)eeID);
            if (enrolmentEvaluation == null) continue;
            res.add(enrolmentEvaluation);
        }
        return res;
    }

    public ActionForward choosePrinterMarkSheetsWeb(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.choosePrinterMarkSheetsWeb(mapping, actionForm, request, response, ExecutionSemester.readActualExecutionSemester(), null);
    }

    public ActionForward choosePrinterMarkSheetsWebPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        ExecutionSemester executionSemester = this.getExecutionSemester(form);
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(form);
        return this.choosePrinterMarkSheetsWeb(mapping, actionForm, request, response, executionSemester, degreeCurricularPlan);
    }

    private ExecutionSemester getExecutionSemester(DynaActionForm form) {
        return (ExecutionSemester)this.getDomainObject(form, "ecID");
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(DynaActionForm form) {
        return (DegreeCurricularPlan)((Object)this.getDomainObject(form, "dcpID"));
    }

    private ActionForward choosePrinterMarkSheetsWeb(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, ExecutionSemester executionSemester, DegreeCurricularPlan degreeCurricularPlan) {
        DynaActionForm form = (DynaActionForm)actionForm;
        Collection<MarkSheet> webMarkSheetsNotPrinted = executionSemester.getWebMarkSheetsNotPrinted(AccessControl.getPerson(), degreeCurricularPlan);
        request.setAttribute("executionPeriod", (Object)executionSemester);
        request.setAttribute("curricularCourseMap", this.buildMapWithCurricularCoursesAndNumberOfMarkSheets(webMarkSheetsNotPrinted));
        request.setAttribute("totalMarkSheetsCount", (Object)webMarkSheetsNotPrinted.size());
        this.buildPeriods(request);
        this.buildDegreeCurricularPlans(request, executionSemester);
        form.set("ecID", (Object)executionSemester.getExternalId().toString());
        if (degreeCurricularPlan != null) {
            form.set("dcpID", (Object)degreeCurricularPlan.getExternalId().toString());
        }
        return mapping.findForward("choosePrinterMarkSheetsWeb");
    }

    private void buildDegreeCurricularPlans(HttpServletRequest request, ExecutionSemester semester) {
        ArrayList<DegreeCurricularPlan> dcps = new ArrayList<DegreeCurricularPlan>(semester.getExecutionYear().getDegreeCurricularPlans());
        Collections.sort(dcps, DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME);
        ArrayList<LabelValueBean> result = new ArrayList<LabelValueBean>();
        Set degreesForMarksheets = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.MANAGE_MARKSHEETS, Authenticate.getUser()).collect(Collectors.toSet());
        for (DegreeCurricularPlan dcp : dcps) {
            if (!degreesForMarksheets.contains(dcp.getDegree())) continue;
            result.add(new LabelValueBean(dcp.getPresentationName(semester.getExecutionYear()), dcp.getExternalId().toString()));
        }
        request.setAttribute("degreeCurricularPlans", result);
    }

    private void buildPeriods(HttpServletRequest request) {
        List<ExecutionSemester> notClosedExecutionPeriods = ExecutionSemester.readNotClosedExecutionPeriods();
        Collections.sort(notClosedExecutionPeriods, new ReverseComparator(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR));
        ArrayList<LabelValueBean> periods = new ArrayList<LabelValueBean>();
        for (ExecutionSemester period : notClosedExecutionPeriods) {
            periods.add(new LabelValueBean(period.getExecutionYear().getYear() + " - " + period.getName(), period.getExternalId().toString()));
        }
        request.setAttribute("periods", periods);
    }

    private Map<CurricularCourse, Integer> buildMapWithCurricularCoursesAndNumberOfMarkSheets(Collection<MarkSheet> webMarkSheetsNotPrinted) {
        TreeMap<CurricularCourse, Integer> result = new TreeMap<CurricularCourse, Integer>(new Comparator<CurricularCourse>(){

            @Override
            public int compare(CurricularCourse o1, CurricularCourse o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (MarkSheet markSheet : webMarkSheetsNotPrinted) {
            Integer markSheetNumber = (Integer)result.get((Object)markSheet.getCurricularCourse());
            result.put(markSheet.getCurricularCourse(), markSheetNumber == null ? Integer.valueOf(1) : Integer.valueOf(markSheetNumber + 1));
        }
        return result;
    }

    public ActionForward printMarkSheets(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String markSheet;
        DynaActionForm form = (DynaActionForm)actionForm;
        if (form.get("msID") != null) {
            form.set("markSheet", form.get("msID"));
        }
        if (form.get("markSheet") == null || form.getString("markSheet").length() == 0) {
            form.set("markSheet", (Object)request.getParameter("markSheet"));
        }
        if ((markSheet = form.getString("markSheet")).equals("all")) {
            return this.printWebMarkSheets(mapping, actionForm, request, response);
        }
        return this.printMarkSheet(mapping, actionForm, request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActionForward printMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DynaActionForm form = (DynaActionForm)actionForm;
        String markSheetString = form.getString("markSheet");
        MarkSheet markSheet = (MarkSheet)((Object)this.getDomainObject(form, "markSheet"));
        ActionMessages actionMessages = new ActionMessages();
        try (ServletOutputStream writer = response.getOutputStream();){
            MarkSheetDocument document = new MarkSheetDocument(markSheet);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            writer.write(data);
            this.markAsPrinted(markSheet);
            ActionForward actionForward = null;
            return actionForward;
        }
        catch (Exception e) {
            request.setAttribute("markSheet", (Object)markSheetString);
            this.addMessage(request, actionMessages, e.getMessage(), new String[0]);
            return this.choosePrinterMarkSheetsWeb(mapping, actionForm, request, response);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActionForward printWebMarkSheets(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DynaActionForm form = (DynaActionForm)actionForm;
        ActionMessages actionMessages = new ActionMessages();
        try (ServletOutputStream writer = response.getOutputStream();){
            Collection<MarkSheet> markSheets = this.getExecutionSemester(form).getWebMarkSheetsNotPrinted(AccessControl.getPerson(), this.getDegreeCurricularPlan(form));
            List<MarkSheetDocument> reports = markSheets.stream().map(MarkSheetDocument::new).collect(Collectors.toList());
            byte[] data = ReportsUtils.generateReport(reports.toArray(new MarkSheetDocument[0])).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", "marksheets-" + new DateTime().toString()));
            writer.write(data);
            this.markAsPrinted(markSheets);
            ActionForward actionForward = null;
            return actionForward;
        }
        catch (Exception e) {
            this.addMessage(request, actionMessages, e.getMessage(), new String[0]);
            return this.choosePrinterMarkSheetsWeb(mapping, actionForm, request, response);
        }
    }

    private void markAsPrinted(Collection<MarkSheet> collection) {
        Object object = advice$markAsPrinted.perform((Callable)new MarkSheetSearchDispatchAction$callable$markAsPrinted(this, collection));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$markAsPrinted(MarkSheetSearchDispatchAction this_, Collection markSheets) {
        markSheets.forEach(markSheet -> {
            if (!markSheet.getPrinted().booleanValue()) {
                markSheet.setPrinted(Boolean.TRUE);
            }
        });
    }

    private void markAsPrinted(MarkSheet markSheet) {
        Object object = advice$markAsPrinted$1.perform((Callable)new MarkSheetSearchDispatchAction$callable$markAsPrinted$1(this, markSheet));
    }

    static /* synthetic */ void advised$markAsPrinted(MarkSheetSearchDispatchAction this_, MarkSheet markSheet) {
        if (!markSheet.getPrinted().booleanValue()) {
            markSheet.setPrinted(Boolean.TRUE);
        }
    }
}

