/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.BolonhaManager;

import java.io.Serializable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;

public class CompetenceCourseInformationRequestBean
implements Serializable {
    private CompetenceCourse competenceCourse;
    private ExecutionSemester executionSemester;
    private String justification;
    private String name;
    private String nameEn;
    private RegimeType regime;
    private String objectives;
    private String objectivesEn;
    private String program;
    private String programEn;
    private String evaluationMethod;
    private String evaluationMethodEn;
    private CompetenceCourseLevel competenceCourseLevel;
    private BibliographicReferences references;
    private boolean showOldCompetenceCourses;

    public CompetenceCourseInformationRequestBean(CompetenceCourseInformationChangeRequest request) {
        this.setCompetenceCourse(request.getCompetenceCourse());
        this.setRegime(request.getRegime());
        this.setObjectives(request.getObjectives());
        this.setObjectivesEn(request.getObjectivesEn());
        this.setProgram(request.getProgram());
        this.setProgramEn(request.getProgramEn());
        this.setEvaluationMethod(request.getEvaluationMethod());
        this.setEvaluationMethodEn(request.getEvaluationMethodEn());
        this.setCompetenceCourseLevel(request.getCompetenceCourseLevel());
        this.setExecutionPeriod(request.getExecutionPeriod());
        this.setReferences(request.getBibliographicReferences());
        this.setName(request.getName());
        this.setNameEn(request.getNameEn());
    }

    public CompetenceCourseInformationRequestBean(CompetenceCourseInformation information) {
        this.setCompetenceCourse(information.getCompetenceCourse());
        this.setRegime(information.getRegime());
        this.setObjectives(information.getObjectives());
        this.setObjectivesEn(information.getObjectivesEn());
        this.setProgram(information.getProgram());
        this.setProgramEn(information.getProgramEn());
        this.setEvaluationMethod(information.getEvaluationMethod());
        this.setEvaluationMethodEn(information.getEvaluationMethodEn());
        this.setCompetenceCourseLevel(information.getCompetenceCourseLevel());
        this.setExecutionPeriod(information.getExecutionPeriod());
        this.setReferences(information.getBibliographicReferences());
        this.setName(information.getName());
        this.setNameEn(information.getNameEn());
    }

    public CompetenceCourseInformationRequestBean(CompetenceCourse course, ExecutionSemester period) {
        this.setExecutionPeriod(period);
        this.setCompetenceCourse(course);
    }

    public CompetenceCourseInformationRequestBean() {
        this(null, null);
    }

    public boolean isCompetenceCourseDefinedForExecutionPeriod() {
        if (this.getCompetenceCourse() != null && this.getExecutionPeriod() != null) {
            return this.getCompetenceCourse().isCompetenceCourseInformationDefinedAtExecutionPeriod(this.getExecutionPeriod());
        }
        return false;
    }

    public boolean isRequestDraftAvailable() {
        if (this.getCompetenceCourse() != null && this.getExecutionPeriod() != null) {
            return this.getCompetenceCourse().isRequestDraftAvailable(this.getExecutionPeriod());
        }
        return false;
    }

    public boolean isLoggedPersonAllowedToCreateChangeRequests() {
        if (this.getCompetenceCourse() != null && this.getExecutionPeriod() != null) {
            return this.getCompetenceCourse().isLoggedPersonAllowedToCreateChangeRequests(this.getExecutionPeriod());
        }
        return false;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester period) {
        this.executionSemester = period;
    }

    public CompetenceCourse getCompetenceCourse() {
        return this.competenceCourse;
    }

    public void setCompetenceCourse(CompetenceCourse course) {
        this.competenceCourse = course;
    }

    public CompetenceCourseLevel getCompetenceCourseLevel() {
        return this.competenceCourseLevel;
    }

    public void setCompetenceCourseLevel(CompetenceCourseLevel competenceCourseLevel) {
        this.competenceCourseLevel = competenceCourseLevel;
    }

    public String getEvaluationMethod() {
        return this.evaluationMethod;
    }

    public void setEvaluationMethod(String evaluationMethod) {
        this.evaluationMethod = evaluationMethod;
    }

    public String getEvaluationMethodEn() {
        return this.evaluationMethodEn;
    }

    public void setEvaluationMethodEn(String evaluationMethodEn) {
        this.evaluationMethodEn = evaluationMethodEn;
    }

    public String getJustification() {
        return this.justification;
    }

    public void setJustification(String justification) {
        this.justification = justification;
    }

    public String getObjectives() {
        return this.objectives;
    }

    public void setObjectives(String objectives) {
        this.objectives = objectives;
    }

    public String getObjectivesEn() {
        return this.objectivesEn;
    }

    public void setObjectivesEn(String objectivesEn) {
        this.objectivesEn = objectivesEn;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getProgramEn() {
        return this.programEn;
    }

    public void setProgramEn(String programEn) {
        this.programEn = programEn;
    }

    public RegimeType getRegime() {
        return this.regime;
    }

    public void setRegime(RegimeType regime) {
        this.regime = regime;
    }

    public void update(CompetenceCourseInformation information) {
        this.setObjectives(information.getObjectives());
        this.setObjectivesEn(information.getObjectivesEn());
        this.setProgram(information.getProgram());
        this.setProgramEn(information.getProgramEn());
        this.setEvaluationMethod(information.getEvaluationMethod());
        this.setEvaluationMethodEn(information.getEvaluationMethodEn());
        this.setCompetenceCourseLevel(information.getCompetenceCourseLevel());
        this.setReferences(information.getBibliographicReferences());
        this.setName(information.getName());
        this.setNameEn(information.getNameEn());
    }

    public void reset() {
        this.setObjectives(null);
        this.setObjectivesEn(null);
        this.setProgram(null);
        this.setProgramEn(null);
        this.setEvaluationMethod(null);
        this.setEvaluationMethodEn(null);
        this.setCompetenceCourseLevel(null);
        this.setReferences(null);
        this.setName(null);
        this.setNameEn(null);
    }

    public BibliographicReferences getReferences() {
        if (this.references == null) {
            this.references = new BibliographicReferences();
        }
        return this.references;
    }

    public void setReferences(BibliographicReferences references) {
        this.references = references;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameEn() {
        return this.nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public void setShowOldCompetenceCourses(boolean showOldCompetenceCourses) {
        this.showOldCompetenceCourses = showOldCompetenceCourses;
    }

    public boolean isShowOldCompetenceCourses() {
        return this.showOldCompetenceCourses;
    }

    public boolean getIsShowOldCompetenceCourses() {
        return this.isShowOldCompetenceCourses();
    }
}

