/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.coordinator.evaluation;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.ui.faces.bean.coordinator.evaluation.CoordinatorEvaluationManagementBackingBean;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;

public class CoordinatorWrittenTestsInformationBackingBean
extends CoordinatorEvaluationManagementBackingBean {
    private final Map<String, List<WrittenTest>> writtenTests = new HashMap<String, List<WrittenTest>>();
    private final Map<String, Integer> writtenTestsFreeSpace = new HashMap<String, Integer>();
    private final Map<String, String> writtenTestsRooms = new HashMap<String, String>();
    private List<ExecutionCourse> executionCoursesWithWrittenTests;
    private List<ExecutionCourse> executionCoursesWithoutWrittenTests;
    private List<CalendarLink> writtenTestCalendarLinks;

    public List<ExecutionCourse> getExecutionCoursesWithWrittenTests() {
        if (this.executionCoursesWithWrittenTests == null) {
            this.executionCoursesWithWrittenTests = new ArrayList<ExecutionCourse>();
            Collections.sort(this.getExecutionCourses(), new BeanComparator("sigla"));
            this.writtenTests.clear();
            this.writtenTestsFreeSpace.clear();
            this.writtenTestsRooms.clear();
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                List<WrittenTest> associatedWrittenTests = executionCourse.getAssociatedWrittenTests();
                if (associatedWrittenTests.isEmpty()) continue;
                Collections.sort(associatedWrittenTests, new BeanComparator("dayDate"));
                this.writtenTests.put(executionCourse.getExternalId(), associatedWrittenTests);
                this.processWrittenTestAdditionalValues(associatedWrittenTests);
                this.executionCoursesWithWrittenTests.add(executionCourse);
            }
        }
        return this.executionCoursesWithWrittenTests;
    }

    private void processWrittenTestAdditionalValues(List<WrittenTest> associatedWrittenTests) {
        for (WrittenTest writtenTest : associatedWrittenTests) {
            int totalCapacity = 0;
            StringBuilder buffer = new StringBuilder(20);
            for (WrittenEvaluationSpaceOccupation roomOccupation : writtenTest.getWrittenEvaluationSpaceOccupationsSet()) {
                buffer.append(roomOccupation.getRoom().getName()).append(";");
                totalCapacity += roomOccupation.getRoom().getMetadata("examCapacity").orElse(0).intValue();
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            this.writtenTestsRooms.put(writtenTest.getExternalId(), buffer.toString());
            this.writtenTestsFreeSpace.put(writtenTest.getExternalId(), totalCapacity - writtenTest.getWrittenEvaluationEnrolmentsSet().size());
        }
    }

    public List<ExecutionCourse> getExecutionCoursesWithoutWrittenTests() {
        if (this.executionCoursesWithoutWrittenTests == null) {
            this.executionCoursesWithoutWrittenTests = new ArrayList<ExecutionCourse>();
            Collections.sort(this.getExecutionCourses(), new BeanComparator("sigla"));
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                if (!executionCourse.getAssociatedWrittenTests().isEmpty()) continue;
                this.executionCoursesWithoutWrittenTests.add(executionCourse);
            }
        }
        return this.executionCoursesWithoutWrittenTests;
    }

    public List<CalendarLink> getWrittenTestsCalendarLink() {
        if (this.writtenTestCalendarLinks == null) {
            this.writtenTestCalendarLinks = new ArrayList<CalendarLink>();
            for (ExecutionCourse executionCourse : this.getExecutionCoursesWithWrittenTests()) {
                for (WrittenTest writtenTestToDisplay : executionCourse.getAssociatedWrittenTests()) {
                    CalendarLink calendarLink = new CalendarLink();
                    calendarLink.setObjectOccurrence(writtenTestToDisplay.getDay());
                    StringBuilder linkLabel = new StringBuilder(executionCourse.getSigla());
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                    linkLabel.append(" (");
                    linkLabel.append(sdf.format(writtenTestToDisplay.getBeginning().getTime()));
                    linkLabel.append(")");
                    calendarLink.setObjectLinkLabel(linkLabel.toString());
                    HashMap<String, String> linkParameters = new HashMap<String, String>();
                    linkParameters.put("degreeCurricularPlanID", this.getDegreeCurricularPlanID().toString());
                    linkParameters.put("executionPeriodID", this.getExecutionPeriodID().toString());
                    linkParameters.put("executionCourseID", executionCourse.getExternalId().toString());
                    linkParameters.put("curricularYearID", this.getCurricularYearID().toString());
                    linkParameters.put("evaluationID", writtenTestToDisplay.getExternalId().toString());
                    calendarLink.setLinkParameters(linkParameters);
                    this.writtenTestCalendarLinks.add(calendarLink);
                }
            }
        }
        return this.writtenTestCalendarLinks;
    }

    @Override
    protected void clearAttributes() {
        super.clearAttributes();
        this.executionCoursesWithWrittenTests = null;
        this.executionCoursesWithoutWrittenTests = null;
        this.writtenTestCalendarLinks = null;
    }

    public Map<String, List<WrittenTest>> getWrittenTests() {
        return this.writtenTests;
    }

    public Map<String, Integer> getWrittenTestsFreeSpace() {
        return this.writtenTestsFreeSpace;
    }

    public Map<String, String> getWrittenTestsRooms() {
        return this.writtenTestsRooms;
    }
}

