/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.serviceRequests.documentRequests;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PastDiplomaRequest;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.factoryExecutors.DocumentRequestCreator;
import org.fenixedu.academic.service.services.serviceRequests.documentRequests.CreatePastDiplomaRequest$callable$create;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreatePastDiplomaRequest {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static PastDiplomaRequest create(DocumentRequestCreator documentRequestCreator) {
        return (PastDiplomaRequest)((Object)advice$create.perform((Callable)new CreatePastDiplomaRequest$callable$create(documentRequestCreator)));
    }

    static /* synthetic */ PastDiplomaRequest advised$create(DocumentRequestCreator bean) {
        if (bean.getRegistration().getStartDate().isAfter((ReadablePartial)bean.getPastRequestDate())) {
            throw new DomainException("DiplomaRequest.cannot.request.before.registration.start", new String[0]);
        }
        bean.setRequestDate(bean.getPastRequestDate().toDateTimeAtStartOfDay());
        PastDiplomaRequest request = CreatePastDiplomaRequest.createPastDiplomaRequest(bean);
        request.getActiveSituation().setSituationDate(bean.getPastRequestDate().toDateTimeAtStartOfDay());
        CreatePastDiplomaRequest.createSituations(request, bean);
        return request;
    }

    private static PastDiplomaRequest createPastDiplomaRequest(DocumentRequestCreator bean) {
        PastDiplomaRequest request = new PastDiplomaRequest();
        request.init(bean);
        return request;
    }

    private static void createSituations(PastDiplomaRequest request, DocumentRequestCreateBean bean) {
        if (!bean.getRegistration().isRegistrationConclusionProcessed()) {
            throw new DomainException("DiplomaRequest.diploma.cannot.be.concluded", new String[0]);
        }
        LocalDate latestDate = bean.getPastRequestDate();
        if (bean.getPastPaymentDate() == null) {
            bean.setPastPaymentDate(latestDate);
        } else {
            LocalDate localDate = latestDate = latestDate.compareTo((ReadablePartial)bean.getPastPaymentDate()) < 0 ? bean.getPastPaymentDate() : latestDate;
        }
        if (bean.getPastEmissionDate() == null) {
            bean.setPastEmissionDate(latestDate);
        } else {
            LocalDate localDate = latestDate = latestDate.compareTo((ReadablePartial)bean.getPastEmissionDate()) < 0 ? bean.getPastEmissionDate() : latestDate;
        }
        if (bean.getPastDispatchDate() == null) {
            bean.setPastDispatchDate(latestDate);
        }
        CreatePastDiplomaRequest.createPaymentSituation(request, bean);
        CreatePastDiplomaRequest.process(request, bean.getPastRequestDate());
        request.setNumberOfPages(1);
        CreatePastDiplomaRequest.send(request, bean.getPastRequestDate());
        CreatePastDiplomaRequest.receive(request, bean.getPastRequestDate());
        CreatePastDiplomaRequest.conclude(request, bean.getPastEmissionDate());
        CreatePastDiplomaRequest.deliver(request, bean.getPastDispatchDate());
    }

    private static void createPaymentSituation(PastDiplomaRequest request, DocumentRequestCreateBean bean) {
    }

    private static boolean isPayed(DocumentRequestCreateBean bean) {
        return bean.getPastPaymentAmount() != null && bean.getPastPaymentAmount().isPositive();
    }

    private static AccountingTransactionDetailDTO createTransactionDetailDTO(DocumentRequestCreateBean bean) {
        return new AccountingTransactionDetailDTO(bean.getPastPaymentDate().toDateTimeAtStartOfDay(), PaymentMode.CASH);
    }

    private static void process(PastDiplomaRequest request, LocalDate requestDate) {
        CreatePastDiplomaRequest.editSituation(request, AcademicServiceRequestSituationType.PROCESSING, requestDate.toDateTimeAtStartOfDay().plusMinutes(1));
    }

    private static void send(PastDiplomaRequest request, LocalDate requestDate) {
        CreatePastDiplomaRequest.editSituation(request, AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY, requestDate.toDateTimeAtStartOfDay().plusMinutes(2));
    }

    private static void receive(PastDiplomaRequest request, LocalDate requestDate) {
        CreatePastDiplomaRequest.editSituation(request, AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY, requestDate.toDateTimeAtStartOfDay().plusMinutes(3));
    }

    private static void conclude(PastDiplomaRequest request, LocalDate emissionDate) {
        CreatePastDiplomaRequest.editSituation(request, AcademicServiceRequestSituationType.CONCLUDED, emissionDate.toDateTimeAtStartOfDay().plusMinutes(4));
    }

    private static void deliver(PastDiplomaRequest request, LocalDate dispatchDate) {
        CreatePastDiplomaRequest.editSituation(request, AcademicServiceRequestSituationType.DELIVERED, dispatchDate.toDateTimeAtStartOfDay().plusMinutes(5));
    }

    private static void editSituation(PastDiplomaRequest request, AcademicServiceRequestSituationType situationType, DateTime situationDate) {
        AcademicServiceRequestBean bean = new AcademicServiceRequestBean(situationType, AccessControl.getPerson());
        bean.setFinalSituationDate(situationDate);
        bean.setJustification("-");
        request.edit(bean);
    }
}

