/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.department;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.department.CompetenceCourseStatisticsDTO;
import org.fenixedu.academic.service.services.department.ComputeCompetenceCourseStatistics$callable$runComputeCompetenceCourseStatistics;
import org.fenixedu.academic.service.services.department.ComputeCourseStatistics;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ComputeCompetenceCourseStatistics
extends ComputeCourseStatistics {
    private static final ComputeCompetenceCourseStatistics serviceInstance;
    public static final Advice advice$runComputeCompetenceCourseStatistics;

    public List<CompetenceCourseStatisticsDTO> run(Department department, ExecutionSemester executionSemester) throws FenixServiceException {
        ArrayList<CompetenceCourseStatisticsDTO> results = new ArrayList<CompetenceCourseStatisticsDTO>();
        HashSet<CompetenceCourse> competenceCourses = new HashSet<CompetenceCourse>();
        department.addAllBolonhaCompetenceCourses(competenceCourses, executionSemester);
        for (CompetenceCourse competenceCourse : competenceCourses) {
            List<Enrolment> enrollments = competenceCourse.getActiveEnrollments(executionSemester);
            if (enrollments.size() <= 0) continue;
            CompetenceCourseStatisticsDTO competenceCourseStatistics = new CompetenceCourseStatisticsDTO();
            competenceCourseStatistics.setExternalId(competenceCourse.getExternalId());
            competenceCourseStatistics.setName(competenceCourse.getNameI18N(executionSemester).getContent());
            this.createCourseStatistics(competenceCourseStatistics, enrollments);
            results.add(competenceCourseStatistics);
        }
        Collections.sort(results, CompetenceCourseStatisticsDTO.COURSE_STATISTICS_COMPARATOR_BY_NAME);
        return results;
    }

    public static List<CompetenceCourseStatisticsDTO> runComputeCompetenceCourseStatistics(Department department, ExecutionSemester executionSemester) throws FenixServiceException {
        return (List)advice$runComputeCompetenceCourseStatistics.perform((Callable)new ComputeCompetenceCourseStatistics$callable$runComputeCompetenceCourseStatistics(department, executionSemester));
    }

    static /* synthetic */ List<CompetenceCourseStatisticsDTO> advised$runComputeCompetenceCourseStatistics(Department department, ExecutionSemester executionSemester) throws FenixServiceException {
        return serviceInstance.run(department, executionSemester);
    }

    static {
        advice$runComputeCompetenceCourseStatistics = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ComputeCompetenceCourseStatistics();
    }
}

