/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;

public class ImprovementStudentCurriculumGroupBean
implements Serializable {
    private EvaluationSeason evaluationSeason;

    protected ImprovementStudentCurriculumGroupBean(EvaluationSeason evaluationSeason) {
        this.setEvaluationSeason(evaluationSeason);
    }

    public StudentCurriculumGroupBean create(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester) {
        return new StudentCurriculumGroupBean(curriculumGroup, executionSemester, null){

            @Override
            protected List<IDegreeModuleToEvaluate> buildCourseGroupsToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
                return Collections.emptyList();
            }

            @Override
            protected List<StudentCurriculumEnrolmentBean> buildCurricularCoursesEnroled(CurriculumGroup group, ExecutionSemester executionSemester) {
                ArrayList<StudentCurriculumEnrolmentBean> result = new ArrayList<StudentCurriculumEnrolmentBean>();
                for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
                    Enrolment enrolment;
                    if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).isEnroledInSeason(ImprovementStudentCurriculumGroupBean.this.getEvaluationSeason(), executionSemester)) continue;
                    result.add(new StudentCurriculumEnrolmentBean(enrolment));
                }
                return result;
            }

            @Override
            protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
                ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
                for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
                    if (!curriculumModule.isEnrolment()) continue;
                    Enrolment enrolment = (Enrolment)((Object)curriculumModule);
                    if (!Enrolment.getPredicateImprovement().fill(ImprovementStudentCurriculumGroupBean.this.getEvaluationSeason(), executionSemester, EnrolmentEvaluationContext.MARK_SHEET_EVALUATION).testExceptionless(enrolment)) continue;
                    result.add(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod()));
                }
                return result;
            }

            @Override
            protected List<StudentCurriculumGroupBean> buildCurriculumGroupsEnroled(CurriculumGroup parentGroup, ExecutionSemester executionSemester, int[] curricularYears) {
                ArrayList<StudentCurriculumGroupBean> result = new ArrayList<StudentCurriculumGroupBean>();
                Set<CurriculumGroup> curriculumGroupsToEnrolmentProcess = parentGroup.getCurriculumGroupsToEnrolmentProcess();
                if (parentGroup.getStudentCurricularPlan().isEmptyDegree()) {
                    curriculumGroupsToEnrolmentProcess = this.filterGroups(parentGroup);
                }
                for (CurriculumGroup curriculumGroup : curriculumGroupsToEnrolmentProcess) {
                    result.add(ImprovementStudentCurriculumGroupBean.this.create(curriculumGroup, executionSemester));
                }
                return result;
            }

            private Set<CurriculumGroup> filterGroups(CurriculumGroup parentGroup) {
                TreeSet<CurriculumModule> groups = new TreeSet<CurriculumModule>(CurriculumModule.COMPARATOR_BY_NAME_AND_ID);
                for (CurriculumModule curriculumModule : parentGroup.getCurriculumModulesSet()) {
                    NoCourseGroupCurriculumGroup noCourseGroup;
                    if (curriculumModule.isLeaf() || curriculumModule.isNoCourseGroupCurriculumGroup() && (noCourseGroup = (NoCourseGroupCurriculumGroup)((Object)curriculumModule)).getNoCourseGroupCurriculumGroupType() != NoCourseGroupCurriculumGroupType.STANDALONE) continue;
                    groups.add((CurriculumModule)((Object)((CurriculumGroup)((Object)curriculumModule))));
                }
                return groups;
            }

            @Override
            public List<IDegreeModuleToEvaluate> getSortedDegreeModulesToEvaluate() {
                ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>(this.getCurricularCoursesToEnrol());
                Collections.sort(result, IDegreeModuleToEvaluate.COMPARATOR_BY_EXECUTION_PERIOD);
                return result;
            }

            @Override
            public boolean isToBeDisabled() {
                return true;
            }
        };
    }

    public static StudentCurriculumGroupBean create(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester, EvaluationSeason evaluationSeason) {
        return new ImprovementStudentCurriculumGroupBean(evaluationSeason).create(curriculumGroup, executionSemester);
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.evaluationSeason;
    }

    public void setEvaluationSeason(EvaluationSeason evaluationSeason) {
        this.evaluationSeason = evaluationSeason;
    }
}

