/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.alumni.formation;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.EducationArea;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.FormationType;
import org.fenixedu.academic.domain.QualificationType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionUnit;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.dto.alumni.formation.AlumniEducationArea;
import org.fenixedu.academic.dto.alumni.formation.IFormation;
import org.fenixedu.bennu.core.domain.Bennu;

public class AlumniFormation
implements Serializable,
IFormation {
    private static final int FIRST_YEAR = 1933;
    private String typeSchema;
    private String institutionSchema;
    private FormationType formationType;
    private QualificationType formationDegree;
    private List<AlumniEducationArea> allAreas;
    private EducationArea educationArea;
    private AcademicalInstitutionType institutionType;
    private AcademicalInstitutionUnit parentUnit;
    private AcademicalInstitutionUnit childUnit;
    private String foreignUnit;
    private CountryUnit countryUnit;
    private String formationBeginYear;
    private String formationEndYear;
    private BigDecimal formationCredits;
    private Integer formationHours;
    private Formation formation;

    public AlumniFormation() {
        this.setTypeSchema("alumni.formation.degree");
        this.setInstitutionSchema("alumni.formation.no.institution.type");
        this.initEducationAreas();
    }

    private void initEducationAreas() {
        this.allAreas = new ArrayList<AlumniEducationArea>();
        for (EducationArea area : Bennu.getInstance().getEducationAreasSet()) {
            this.allAreas.add(new AlumniEducationArea(area));
        }
    }

    public static AlumniFormation buildFrom(Formation dbFormation) {
        AlumniFormation formation = new AlumniFormation();
        if (dbFormation.getFormationType() == null) {
            formation.setTypeSchema("alumni.formation.degree");
        } else {
            formation.setTypeSchema("alumni.formation.degree.both");
        }
        formation.setFormationType(dbFormation.getFormationType());
        formation.setFormationDegree(dbFormation.getType());
        formation.setInstitutionType(dbFormation.getInstitutionType());
        if (dbFormation.getInstitutionType() != null) {
            formation.setInstitutionSchema("alumni.formation.national.institution.parent");
        }
        AlumniFormation.setInstitution(formation, dbFormation);
        if (dbFormation.getBaseInstitution() != null) {
            formation.setParentInstitution((AcademicalInstitutionUnit)((Object)dbFormation.getBaseInstitution()));
            if (((AcademicalInstitutionUnit)((Object)dbFormation.getBaseInstitution())).hasAnyOfficialChilds().booleanValue()) {
                formation.setInstitutionSchema("alumni.formation.national.institution.both");
            } else {
                formation.setInstitutionSchema("alumni.formation.national.institution.parent");
            }
        }
        formation.setEducationArea(dbFormation.getEducationArea());
        formation.setFormationBeginYear(dbFormation.getBeginYear());
        formation.setFormationEndYear(dbFormation.getYear());
        formation.setFormationCredits(dbFormation.getEctsCredits());
        formation.setFormationHours(dbFormation.getFormationHours());
        formation.setAssociatedFormation(dbFormation);
        return formation;
    }

    private static void setInstitution(AlumniFormation bean, Formation dbFormation) {
        Unit institution = dbFormation.getInstitution();
        if (institution instanceof AcademicalInstitutionUnit) {
            AcademicalInstitutionType academicalInstitutionType = dbFormation.getInstitutionType();
            switch (academicalInstitutionType) {
                case NATIONAL_PUBLIC_INSTITUTION: 
                case NATIONAL_PRIVATE_INSTITUTION: {
                    if (AcademicalInstitutionUnit.readOfficialParentUnitsByType(academicalInstitutionType).contains((Object)institution)) {
                        bean.setParentInstitution((AcademicalInstitutionUnit)((Object)institution));
                        bean.setInstitutionSchema("alumni.formation.national.institution.parent");
                        break;
                    }
                    bean.setChildInstitution((AcademicalInstitutionUnit)((Object)institution));
                    bean.setInstitutionSchema("alumni.formation.national.institution.both");
                    break;
                }
                case FOREIGN_INSTITUTION: {
                    AlumniFormation.setNonNationalInstitution(bean, institution, "alumni.formation.foreign.institution", dbFormation.getCountryUnit());
                    break;
                }
                case OTHER_INSTITUTION: {
                    AlumniFormation.setNonNationalInstitution(bean, institution, "alumni.formation.other.institution", dbFormation.getCountryUnit());
                }
            }
        } else if (institution != null) {
            bean.setForeignUnit(institution.getName());
            if (institution.hasParentUnit((Unit)((Object)CountryUnit.getDefault())).booleanValue()) {
                bean.setInstitutionSchema("alumni.formation.other.institution");
            } else {
                bean.setInstitutionSchema("alumni.formation.foreign.institution");
            }
        } else if (bean.getInstitutionType() == AcademicalInstitutionType.FOREIGN_INSTITUTION) {
            bean.setInstitutionSchema("alumni.formation.foreign.institution");
        } else if (bean.getInstitutionType() == AcademicalInstitutionType.OTHER_INSTITUTION) {
            bean.setInstitutionSchema("alumni.formation.other.institution");
        }
    }

    private static void setNonNationalInstitution(AlumniFormation bean, Unit institution, String schema, CountryUnit countryUnit) {
        bean.setInstitutionSchema(schema);
        bean.setForeignUnit(institution.getName());
        bean.setChildInstitution((AcademicalInstitutionUnit)((Object)institution));
        bean.setCountryUnit(countryUnit);
    }

    @Override
    public int getFirstYear() {
        return 1933;
    }

    public int getLastYear() {
        return Integer.valueOf(ExecutionYear.readLastExecutionYear().getYear());
    }

    public String getTypeSchema() {
        return this.typeSchema;
    }

    public void setTypeSchema(String schema) {
        this.typeSchema = schema;
    }

    public String getInstitutionSchema() {
        return this.institutionSchema;
    }

    public void setInstitutionSchema(String schema) {
        this.institutionSchema = schema;
    }

    public void updateTypeSchema() {
        if (this.getFormationType() == null) {
            this.setTypeSchema("alumni.formation.degree");
        } else {
            this.setTypeSchema("alumni.formation.degree.both");
        }
    }

    public void updateInstitutionSchema() {
        if (this.getInstitutionType() == null) {
            this.setInstitutionSchema("alumni.formation.no.institution.type");
        } else {
            switch (this.getInstitutionType()) {
                case NATIONAL_PUBLIC_INSTITUTION: 
                case NATIONAL_PRIVATE_INSTITUTION: {
                    if (this.getParentInstitution() == null) {
                        this.setInstitutionSchema("alumni.formation.national.institution.parent");
                        break;
                    }
                    if (this.getParentInstitution().hasAnyOfficialChilds().booleanValue()) {
                        this.setInstitutionSchema("alumni.formation.national.institution.both");
                        break;
                    }
                    this.setInstitutionSchema("alumni.formation.national.institution.parent");
                    break;
                }
                case FOREIGN_INSTITUTION: {
                    this.setInstitutionSchema("alumni.formation.foreign.institution");
                    break;
                }
                case OTHER_INSTITUTION: {
                    this.setInstitutionSchema("alumni.formation.other.institution");
                }
            }
        }
    }

    public FormationType getFormationType() {
        return this.formationType;
    }

    public void setFormationType(FormationType formationType) {
        this.formationType = formationType;
        if (formationType == null) {
            this.setFormationDegree(null);
        }
    }

    public QualificationType getFormationDegree() {
        return this.formationDegree;
    }

    public void setFormationDegree(QualificationType formationDegree) {
        this.formationDegree = formationDegree;
    }

    public String getFormationBeginYear() {
        return this.formationBeginYear;
    }

    public void setFormationBeginYear(String formationBeginYear) {
        this.formationBeginYear = formationBeginYear;
    }

    public String getFormationEndYear() {
        return this.formationEndYear;
    }

    public void setFormationEndYear(String formationEndYear) {
        this.formationEndYear = formationEndYear;
    }

    public BigDecimal getFormationCredits() {
        return this.formationCredits;
    }

    public void setFormationCredits(BigDecimal formationCredits) {
        this.formationCredits = formationCredits;
    }

    public Integer getFormationHours() {
        return this.formationHours;
    }

    public void setFormationHours(Integer formationHours) {
        this.formationHours = formationHours;
    }

    public EducationArea getEducationArea() {
        return this.educationArea;
    }

    public void setEducationArea(EducationArea educationArea) {
        this.educationArea = educationArea;
    }

    public AcademicalInstitutionUnit getInstitution() {
        if (this.getInstitutionType() != null) {
            if (this.isNationalInstitution()) {
                if (this.getChildInstitution() != null) {
                    return this.getChildInstitution();
                }
                if (this.getParentInstitution() != null && this.getParentInstitution() instanceof UniversityUnit && this.getParentInstitution().getChildParties(SchoolUnit.class).isEmpty()) {
                    return this.getParentInstitution();
                }
                return null;
            }
            return this.getChildInstitution();
        }
        return null;
    }

    public AcademicalInstitutionUnit getParentInstitution() {
        return this.parentUnit;
    }

    public void setParentInstitution(AcademicalInstitutionUnit parentUnit) {
        this.parentUnit = parentUnit;
        if (parentUnit == null) {
            this.setChildInstitution(null);
        }
    }

    public AcademicalInstitutionUnit getChildInstitution() {
        return this.childUnit;
    }

    public void setChildInstitution(AcademicalInstitutionUnit childUnit) {
        this.childUnit = childUnit;
    }

    public AcademicalInstitutionType getInstitutionType() {
        return this.institutionType;
    }

    public void setInstitutionType(AcademicalInstitutionType institutionType) {
        this.institutionType = institutionType;
    }

    public Formation getAssociatedFormation() {
        return this.formation;
    }

    public void setAssociatedFormation(Formation formation) {
        this.formation = formation;
    }

    public boolean hasAssociatedFormation() {
        return this.getAssociatedFormation() != null;
    }

    public List<AlumniEducationArea> getAllAreas() {
        Collections.sort(this.allAreas, AlumniEducationArea.COMPARATOR_BY_CODE);
        return this.allAreas;
    }

    public Boolean hasFullInformation() {
        if (this.getFormationDegree() == null) {
            return Boolean.FALSE;
        }
        if (this.getEducationArea() == null) {
            return Boolean.FALSE;
        }
        if (this.getInstitution() == null && StringUtils.isEmpty((String)this.getForeignUnit())) {
            return Boolean.FALSE;
        }
        if (StringUtils.isEmpty((String)this.getFormationBeginYear())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getForeignUnit() {
        return this.foreignUnit;
    }

    public void setForeignUnit(String foreignUnit) {
        this.setParentInstitution(null);
        this.setChildInstitution(null);
        this.foreignUnit = foreignUnit;
    }

    public void setCountryUnit(CountryUnit countryUnit) {
        this.countryUnit = countryUnit;
    }

    public CountryUnit getCountryUnit() {
        return this.countryUnit;
    }

    public boolean isNationalInstitution() {
        return !this.getInstitutionType().equals((Object)AcademicalInstitutionType.FOREIGN_INSTITUTION);
    }
}

