/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.InfoCountry;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoStudentCurricularPlan;
import org.fenixedu.academic.dto.InfoTeacher;

public class InfoPerson
extends InfoObject {
    private final Person person;

    public InfoPerson(Person person) {
        this.person = person;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof InfoPerson && this.getNumeroDocumentoIdentificacao().equals(((InfoPerson)o).getNumeroDocumentoIdentificacao()) && this.getTipoDocumentoIdentificacao().equals((Object)((InfoPerson)o).getTipoDocumentoIdentificacao());
    }

    public String toString() {
        return this.getPerson().toString();
    }

    public String getCodigoFiscal() {
        return this.getPerson().getFiscalCode();
    }

    public String getCodigoPostal() {
        return this.getPerson().getAreaCode();
    }

    public String getConcelhoMorada() {
        return this.getPerson().getDistrictSubdivisionOfResidence();
    }

    public String getConcelhoNaturalidade() {
        return this.getPerson().getDistrictSubdivisionOfBirth();
    }

    public Date getDataEmissaoDocumentoIdentificacao() {
        return this.getPerson().getEmissionDateOfDocumentId();
    }

    public Date getDataValidadeDocumentoIdentificacao() {
        return this.getPerson().getExpirationDateOfDocumentId();
    }

    public String getDistritoMorada() {
        return this.getPerson().getDistrictOfResidence();
    }

    public String getDistritoNaturalidade() {
        return this.getPerson().getDistrictOfBirth();
    }

    public String getEmail() {
        return this.getPerson().getEmail();
    }

    public String getEnderecoWeb() {
        return this.getPerson().getDefaultWebAddressUrl();
    }

    public MaritalStatus getMaritalStatus() {
        return this.getPerson().getMaritalStatus();
    }

    public String getFreguesiaMorada() {
        return this.getPerson().getParishOfResidence();
    }

    public String getFreguesiaNaturalidade() {
        return this.getPerson().getParishOfBirth();
    }

    public InfoCountry getInfoPais() {
        return InfoCountry.newInfoFromDomain(this.getPerson().getCountry());
    }

    public String getLocalEmissaoDocumentoIdentificacao() {
        return this.getPerson().getEmissionLocationOfDocumentId();
    }

    public String getLocalidade() {
        return this.getPerson().getArea();
    }

    public String getLocalidadeCodigoPostal() {
        return this.getPerson().getAreaOfAreaCode();
    }

    public String getMorada() {
        return this.getPerson().getAddress();
    }

    public String getNacionalidade() {
        return this.getPerson().getCountry() != null ? this.getPerson().getCountry().getNationality() : null;
    }

    public Date getNascimento() {
        return this.getPerson().getDateOfBirth();
    }

    public String getNome() {
        return this.getPerson().getName();
    }

    public String getNomeMae() {
        return this.getPerson().getNameOfMother();
    }

    public String getNomePai() {
        return this.getPerson().getNameOfFather();
    }

    public String getNumContribuinte() {
        return this.getPerson().getSocialSecurityNumber();
    }

    public String getNumeroDocumentoIdentificacao() {
        return this.getPerson().getDocumentIdNumber();
    }

    public String getProfissao() {
        return this.getPerson().getProfession();
    }

    public Gender getSexo() {
        return this.getPerson().getGender();
    }

    public String getTelefone() {
        return this.getPerson().getDefaultPhoneNumber();
    }

    public String getTelemovel() {
        return this.getPerson().getDefaultMobilePhoneNumber();
    }

    public IDDocumentType getTipoDocumentoIdentificacao() {
        return this.getPerson().getIdDocumentType();
    }

    public String getUsername() {
        return this.getPerson().getUsername();
    }

    public Boolean getAvailableEmail() {
        return this.getPerson().getAvailableEmail();
    }

    public String getWorkPhone() {
        return this.getPerson().getWorkPhone();
    }

    public Boolean getAvailableWebSite() {
        return this.getPerson().getAvailableWebSite();
    }

    public static InfoPerson newInfoFromDomain(Person person) {
        return person != null ? new InfoPerson(person) : null;
    }

    public List<InfoStudentCurricularPlan> getInfoStudentCurricularPlanList() {
        ArrayList<InfoStudentCurricularPlan> result = new ArrayList<InfoStudentCurricularPlan>();
        for (Registration registration : this.getPerson().getStudentsSet()) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                result.add(InfoStudentCurricularPlan.newInfoFromDomain(studentCurricularPlan));
            }
        }
        return result;
    }

    public InfoTeacher getInfoTeacher() {
        return InfoTeacher.newInfoFromDomain(this.getPerson().getTeacher());
    }

    @Override
    public String getExternalId() {
        return this.getPerson().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public Person getPerson() {
        return this.person;
    }
}

