/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.dto.InfoBranch;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoCurricularSemester;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.commons.i18n.I18N;

public class InfoCurricularCourseScope
extends InfoObject {
    public static final Comparator<InfoCurricularCourseScope> COMPARATOR_BY_YEAR_SEMESTER_BRANCH_AND_NAME = new Comparator<InfoCurricularCourseScope>(){

        @Override
        public int compare(InfoCurricularCourseScope o1, InfoCurricularCourseScope o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator((Comparator)new Comparator<InfoCurricularCourseScope>(){

                @Override
                public int compare(InfoCurricularCourseScope o1, InfoCurricularCourseScope o2) {
                    return o1.getInfoCurricularSemester().getInfoCurricularYear().getYear().compareTo(o2.getInfoCurricularSemester().getInfoCurricularYear().getYear());
                }
            });
            comparatorChain.addComparator((Comparator)new Comparator<InfoCurricularCourseScope>(){

                @Override
                public int compare(InfoCurricularCourseScope o1, InfoCurricularCourseScope o2) {
                    return o1.getInfoCurricularSemester().getSemester().compareTo(o2.getInfoCurricularSemester().getSemester());
                }
            });
            comparatorChain.addComparator((Comparator)new Comparator<InfoCurricularCourseScope>(){

                @Override
                public int compare(InfoCurricularCourseScope o1, InfoCurricularCourseScope o2) {
                    String acronym2;
                    String acronym1 = o1.getInfoBranch() == null ? null : o1.getInfoBranch().getAcronym();
                    String string = acronym2 = o2.getInfoBranch() == null ? null : o2.getInfoBranch().getAcronym();
                    if (StringUtils.isEmpty((String)acronym1) && StringUtils.isEmpty((String)acronym2)) {
                        return 0;
                    }
                    if (!StringUtils.isEmpty((String)acronym1) && StringUtils.isEmpty((String)acronym2)) {
                        return 1;
                    }
                    if (StringUtils.isEmpty((String)acronym1) && !StringUtils.isEmpty((String)acronym2)) {
                        return -1;
                    }
                    return acronym1.compareTo(acronym2);
                }
            });
            comparatorChain.addComparator((Comparator)new Comparator<InfoCurricularCourseScope>(){

                @Override
                public int compare(InfoCurricularCourseScope o1, InfoCurricularCourseScope o2) {
                    return InfoCurricularCourse.COMPARATOR_BY_NAME_AND_ID.compare(o1.getInfoCurricularCourse(), o2.getInfoCurricularCourse());
                }
            });
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    private final CurricularCourseScope curricularCourseScope;
    private final boolean showEnVersion = I18N.getLocale().equals(MultiLanguageString.en);

    public InfoCurricularCourseScope(CurricularCourseScope curricularCourseScope) {
        this.curricularCourseScope = curricularCourseScope;
    }

    public CurricularCourseScope getCurricularCourseScope() {
        return this.curricularCourseScope;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoCurricularCourseScope && this.getCurricularCourseScope() == ((InfoCurricularCourseScope)obj).getCurricularCourseScope();
    }

    public String toString() {
        return this.getCurricularCourseScope().toString();
    }

    public Boolean isActive() {
        return this.getCurricularCourseScope().isActive();
    }

    public Calendar getBeginDate() {
        return this.getCurricularCourseScope().getBeginDate();
    }

    public Calendar getEndDate() {
        return this.getCurricularCourseScope().getEndDate();
    }

    public InfoBranch getInfoBranch() {
        return InfoBranch.newInfoFromDomain(this.getCurricularCourseScope().getBranch());
    }

    public InfoCurricularCourse getInfoCurricularCourse() {
        return InfoCurricularCourse.newInfoFromDomain(this.getCurricularCourseScope().getCurricularCourse());
    }

    public InfoCurricularSemester getInfoCurricularSemester() {
        return InfoCurricularSemester.newInfoFromDomain(this.getCurricularCourseScope().getCurricularSemester());
    }

    public static InfoCurricularCourseScope newInfoFromDomain(CurricularCourseScope curricularCourseScope) {
        return curricularCourseScope == null ? null : new InfoCurricularCourseScope(curricularCourseScope);
    }

    public String getAnotation() {
        return this.getCurricularCourseScope().getAnotation();
    }

    @Override
    public String getExternalId() {
        return this.getCurricularCourseScope().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }
}

