/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitInExternalCycle;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup_Base;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;

public class ExternalCurriculumGroup
extends ExternalCurriculumGroup_Base {
    public ExternalCurriculumGroup() {
    }

    public ExternalCurriculumGroup(RootCurriculumGroup rootCurriculumGroup, CycleCourseGroup cycleCourseGroup) {
        this();
        this.init((CurriculumGroup)((Object)rootCurriculumGroup), (CourseGroup)((Object)cycleCourseGroup));
    }

    public ExternalCurriculumGroup(RootCurriculumGroup rootCurriculumGroup, CycleCourseGroup cycleCourseGroup, ExecutionSemester executionSemester) {
        this();
        this.init((CurriculumGroup)((Object)rootCurriculumGroup), (CourseGroup)((Object)cycleCourseGroup), executionSemester);
    }

    protected void checkInitConstraints(CurriculumGroup parent, CourseGroup courseGroup) {
        super.checkInitConstraints(parent, courseGroup);
        if (parent.getDegreeCurricularPlanOfStudent() == courseGroup.getParentDegreeCurricularPlan()) {
            throw new DomainException("error.studentCurriculum.CurriculumGroup.courseGroup.must.have.different.degreeCurricularPlan", new String[0]);
        }
        this.checkIfCycleCourseGroupIsInDestinationAffinitiesOfSource(parent.getStudentCurricularPlan(), courseGroup);
    }

    private void checkIfCycleCourseGroupIsInDestinationAffinitiesOfSource(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup) {
        CycleCourseGroup cycleCourseGroup = (CycleCourseGroup)((Object)courseGroup);
        CycleCourseGroup sourceAffinityCycleCourseGroup = studentCurricularPlan.getDegreeCurricularPlan().getCycleCourseGroup(cycleCourseGroup.getCycleType().getSourceCycleAffinity());
        if (!sourceAffinityCycleCourseGroup.getDestinationAffinitiesSet().contains((Object)cycleCourseGroup)) {
            throw new DomainException("error.studentCurriculum.ExternalCurriculumGroup.cycle.course.group.does.not.belong.to.afinity.of.source", new String[0]);
        }
    }

    public Integer getChildOrder() {
        return 0x7FFFFFFA;
    }

    public Integer getChildOrder(ExecutionSemester executionSemester) {
        return this.getChildOrder();
    }

    public MultiLanguageString getName() {
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        if (!StringUtils.isEmpty((String)this.getDegreeModule().getName())) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, this.getDegreeModule().getName() + " (" + this.getDegreeCurricularPlanOfDegreeModule().getName() + ")");
        }
        if (!StringUtils.isEmpty((String)this.getDegreeModule().getNameEn())) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, this.getDegreeModule().getNameEn() + " (" + this.getDegreeCurricularPlanOfDegreeModule().getName() + ")");
        }
        return multiLanguageString;
    }

    public Set<ICurricularRule> getCurricularRules(ExecutionSemester executionSemester) {
        Set result = super.getCurricularRules(executionSemester);
        result.add(new CreditsLimitInExternalCycle(this.getRootCurriculumGroup().getCycleCurriculumGroup(this.getCycleType().getSourceCycleAffinity()), this));
        return result;
    }

    public boolean isExternal() {
        return true;
    }

    public final Curriculum getCurriculum(DateTime when, ExecutionYear executionYear) {
        return Curriculum.createEmpty((CurriculumModule)((Object)this), executionYear);
    }

    public final Curriculum getCurriculumInAdvance() {
        return this.getCurriculum(new DateTime());
    }

    public final Curriculum getCurriculumInAdvance(DateTime when) {
        return super.getCurriculum(when, (ExecutionYear)null);
    }

    public void conclude() {
        throw new DomainException("error.ExternalCurriculumGroup.cannot.conclude.external.curriculumGroups", new String[0]);
    }

    public boolean isConclusionProcessed() {
        return false;
    }
}

