/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.certificates;

import java.util.List;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.documents.DocumentRequestGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdDocumentRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.certificates.PhdFinalizationCertificateRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionBatch;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhdFinalizationCertificateRequest
extends PhdFinalizationCertificateRequest_Base {
    private static final Logger logger = LoggerFactory.getLogger(PhdFinalizationCertificateRequest.class);

    protected PhdFinalizationCertificateRequest() {
    }

    protected PhdFinalizationCertificateRequest(PhdDocumentRequestCreateBean bean) {
        this();
        this.init(bean);
        PhdRegistryDiplomaRequest registryDiplomaRequest = this.getPhdIndividualProgramProcess().getRegistryDiplomaRequest();
        if (registryDiplomaRequest == null) {
            throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.registry.diploma.request.none", new String[0]);
        }
        RectorateSubmissionBatch rectorateSubmissionBatch = registryDiplomaRequest.getRectorateSubmissionBatch();
        if (rectorateSubmissionBatch == null) {
            throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.registry.diploma.submission.batch.not.sent", new String[0]);
        }
    }

    protected void init(PhdDocumentRequestCreateBean bean) {
        super.init(bean);
        if (!bean.getPhdIndividualProgramProcess().isBolonha().booleanValue()) {
            return;
        }
        if (this.getPhdIndividualProgramProcess().getRegistryDiplomaRequest() == null) {
            throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.registry.diploma.not.requested", new String[0]);
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        try {
            this.verifyIsToProcessAndHasPersonalInfo(academicServiceRequestBean);
            this.verifyIsToDeliveredAndIsPayed(academicServiceRequestBean);
        }
        catch (DomainException e) {
            throw new PhdDomainOperationException(e.getKey(), (Throwable)((Object)e), e.getArgs());
        }
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            PhdRegistryDiplomaRequest registryDiplomaRequest = this.getPhdIndividualProgramProcess().getRegistryDiplomaRequest();
            if (registryDiplomaRequest == null) {
                throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.registry.diploma.request.none", new String[0]);
            }
            RectorateSubmissionBatch rectorateSubmissionBatch = registryDiplomaRequest.getRectorateSubmissionBatch();
            if (rectorateSubmissionBatch == null) {
                throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.registry.diploma.submission.batch.not.sent", new String[0]);
            }
            if (!rectorateSubmissionBatch.isSent() && !rectorateSubmissionBatch.isReceived()) {
                throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.registry.diploma.submission.batch.not.sent", new String[0]);
            }
            if (!this.getPhdIndividualProgramProcess().isConcluded()) {
                throw new PhdDomainOperationException("error.PhdFinalizationCertificateRequest.phd.process.not.submited.to.conclusion.process", new String[0]);
            }
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
        }
    }

    public byte[] generateDocument() {
        try {
            List<AdministrativeOfficeDocument> documents = AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create((IDocumentRequest)((Object)this));
            AdministrativeOfficeDocument[] array = new AdministrativeOfficeDocument[]{};
            byte[] data = ReportsUtils.generateReport(documents.toArray(array)).getData();
            DocumentRequestGeneratedDocument.store((IDocumentRequest)((Object)this), ((AdministrativeOfficeDocument)documents.iterator().next()).getReportFileName() + ".pdf", data);
            return data;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DomainException("error.phdDiplomaRequest.errorGeneratingDocument", new String[0]);
        }
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.PHD_FINALIZATION_CERTIFICATE;
    }

    public String getDocumentTemplateKey() {
        return PhdFinalizationCertificateRequest.class.getName();
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isToPrint() {
        return true;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public EventType getEventType() {
        return EventType.PHD_FINALIZATION_CERTIFICATE_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    public static PhdFinalizationCertificateRequest create(PhdDocumentRequestCreateBean bean) {
        return new PhdFinalizationCertificateRequest(bean);
    }
}

