/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.util.Collections;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramCalendarUtil;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdFinalProofRequestAlert_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PhdFinalProofRequestAlert
extends PhdFinalProofRequestAlert_Base {
    private static int MAX_DAYS = 1825;

    private PhdFinalProofRequestAlert() {
    }

    public PhdFinalProofRequestAlert(PhdIndividualProgramProcess process2) {
        this();
        super.init(process2, this.buildSubject(process2), this.buildBody(process2));
    }

    private MultiLanguageString buildSubject(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.getSubjectPrefixed(process2, "message.phd.alert.final.proof.request.subject"));
    }

    private MultiLanguageString buildBody(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.getBodyText(process2, "message.phd.alert.final.proof.request.body"));
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.alert.final.proof.request.description", (String[])new String[0]);
    }

    protected boolean isToDiscard() {
        return this.getProcess().getThesisProcess() != null || !this.getProcess().getActiveState().isPhdActive();
    }

    protected boolean isToFire() {
        if (this.getFireDate() == null) {
            return !new LocalDate().isBefore((ReadablePartial)PhdProgramCalendarUtil.addWorkDaysTo(this.getProcess().getWhenStartedStudies(), MAX_DAYS));
        }
        return !new LocalDate().isBefore((ReadablePartial)PhdProgramCalendarUtil.addWorkDaysTo(this.getFireDate().toLocalDate(), 25));
    }

    protected void generateMessage() {
        super.init(this.buildSubject(this.getProcess()), this.buildBody(this.getProcess()));
        new PhdAlertMessage(this.getProcess(), this.getProcess().getPerson(), this.getFormattedSubject(), this.getFormattedBody());
        new Message((Sender)((Object)this.getSender()), new Recipient(Collections.singletonList(this.getProcess().getPerson())), this.buildMailSubject(), this.buildMailBody());
    }

    public boolean isToSendMail() {
        return true;
    }

    public boolean isSystemAlert() {
        return true;
    }
}

