/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdCustomAlertBean;
import org.fenixedu.academic.domain.phd.alert.PhdCustomAlert_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.User_Base;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PhdCustomAlert
extends PhdCustomAlert_Base {
    protected PhdCustomAlert() {
    }

    public PhdCustomAlert(PhdIndividualProgramProcess process2, Group targetGroup, MultiLanguageString subject, MultiLanguageString body, Boolean sendMail, LocalDate fireDate, Boolean userDefined, Boolean shared) {
        this();
        this.init(process2, targetGroup, subject, body, sendMail, fireDate, userDefined, shared);
    }

    public PhdCustomAlert(PhdCustomAlertBean bean) {
        this(bean.getProcess(), bean.calculateTargetGroup(), new MultiLanguageString(Locale.getDefault(), bean.getSubject()), new MultiLanguageString(Locale.getDefault(), bean.getBody()), bean.isToSendEmail(), bean.getFireDate(), bean.getUserDefined(), bean.getShared());
    }

    protected void init(PhdIndividualProgramProcess process2, Group targetGroup, MultiLanguageString subject, MultiLanguageString body, Boolean sendEmail2, LocalDate whenToFire, Boolean userDefined, Boolean shared) {
        super.init(process2, subject, body);
        String[] args = new String[]{};
        if (whenToFire == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdCustomAlert.whenToFire.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (targetGroup == null) {
            throw new DomainException("error.phd.alert.PhdAlert.targetGroup.cannot.be.null", args1);
        }
        String[] args2 = new String[]{};
        if (sendEmail2 == null) {
            throw new DomainException("error.phd.alert.PhdAlert.sendEmail.cannot.be.null", args2);
        }
        String[] args3 = new String[]{};
        if (userDefined == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdCustomAlert.userDefined.cannot.be.null", args3);
        }
        String[] args4 = new String[]{};
        if (shared == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.alert.PhdCustomAlert.shared.cannot.be.null", args4);
        }
        super.setWhenToFire(whenToFire);
        super.setSendEmail(sendEmail2);
        super.setTargetGroup(targetGroup.toPersistentGroup());
        super.setUserDefined(userDefined);
        super.setShared(shared);
    }

    protected Group getTargetAccessGroup() {
        return this.getTargetGroup().toGroup();
    }

    protected ImmutableSet<Person> getTargetPeople() {
        return FluentIterable.from((Iterable)this.getTargetAccessGroup().getMembers()).transform(User_Base::getPerson).toSet();
    }

    public boolean isToFire() {
        return !new LocalDate().isBefore((ReadablePartial)this.getWhenToFire());
    }

    protected boolean isToDiscard() {
        return this.getFireDate() != null;
    }

    public boolean isCustomAlert() {
        return true;
    }

    public String getDescription() {
        return MessageFormat.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.alert.custom.description", (String[])new String[0]), this.getTargetAccessGroup().getPresentationName(), this.getWhenToFire().toString("dd/MM/yyyy"), this.getFormattedSubject(), this.getFormattedBody());
    }

    protected void generateMessage() {
        if (this.getShared().booleanValue()) {
            new PhdAlertMessage(this.getProcess(), (Collection<Person>)this.getTargetPeople(), this.getFormattedSubject(), this.getFormattedBody());
        } else {
            for (Person person : this.getTargetPeople()) {
                new PhdAlertMessage(this.getProcess(), person, this.getFormattedSubject(), this.getFormattedBody());
            }
        }
        if (this.isToSendMail()) {
            Recipient recipient = new Recipient(this.getTargetAccessGroup());
            new Message((Sender)((Object)this.getSender()), recipient, this.buildMailSubject(), this.buildMailBody());
        }
    }

    public String getTargetGroupInText() {
        Group targetGroup = this.getTargetAccessGroup();
        Set elements = targetGroup.getMembers();
        StringBuilder builder = new StringBuilder();
        for (User user : elements) {
            builder.append(user.getPerson().getName()).append(" (").append(user.getPerson().getEmailForSendingEmails()).append(")\n");
        }
        return builder.toString();
    }

    public void setSendEmail(Boolean sendEmail2) {
        throw new DomainException("error.phd.alert.PhdAlert.cannot.modify.sendEmail", new String[0]);
    }

    public void setUserDefined(Boolean userDefined) {
        throw new DomainException("error.phd.alert.PhdCustomAlert.cannot.modify.userDefined", new String[0]);
    }

    public void setShared(Boolean shared) {
        throw new DomainException("error.phd.alert.PhdCustomAlert.cannot.modify.shared", new String[0]);
    }

    public boolean isToSendMail() {
        return this.getSendEmail();
    }

    public boolean isSystemAlert() {
        return this.getUserDefined() == false;
    }
}

