/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.secondCycle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.events.candidacy.CandidacyExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyExemption;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacySeriesGrade;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.bennu.core.domain.User;

public class SecondCycleIndividualCandidacyProcess
extends SecondCycleIndividualCandidacyProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    private SecondCycleIndividualCandidacyProcess() {
    }

    private SecondCycleIndividualCandidacyProcess(SecondCycleIndividualCandidacyProcessBean bean) {
        this();
        this.init(bean);
        this.setSpecificIndividualCandidacyDocumentFiles(bean);
    }

    private void setSpecificIndividualCandidacyDocumentFiles(SecondCycleIndividualCandidacyProcessBean bean) {
        this.bindIndividualCandidacyDocumentFile(bean.getCurriculumVitaeDocument());
        for (CandidacyProcessDocumentUploadBean documentBean : bean.getHabilitationCertificateList()) {
            this.bindIndividualCandidacyDocumentFile(documentBean);
        }
        for (CandidacyProcessDocumentUploadBean documentBean : bean.getReportOrWorkDocumentList()) {
            this.bindIndividualCandidacyDocumentFile(documentBean);
        }
    }

    protected void checkParameters(CandidacyProcess process2) {
        if (process2 == null || process2.getCandidacyPeriod() == null) {
            throw new DomainException("error.SecondCycleIndividualCandidacyProcess.invalid.candidacy.process", new String[0]);
        }
    }

    protected void createIndividualCandidacy(IndividualCandidacyProcessBean bean) {
        new SecondCycleIndividualCandidacy(this, (SecondCycleIndividualCandidacyProcessBean)bean);
    }

    public boolean canExecuteActivity(User userView) {
        return SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(this, userView) || RoleType.SCIENTIFIC_COUNCIL.isMember(userView.getPerson().getUser()) || RoleType.COORDINATOR.isMember(userView.getPerson().getUser());
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public SecondCycleIndividualCandidacy getCandidacy() {
        return (SecondCycleIndividualCandidacy)((Object)super.getCandidacy());
    }

    private SecondCycleIndividualCandidacyProcess editCandidacyInformation(SecondCycleIndividualCandidacyProcessBean bean) {
        this.getCandidacy().editCandidacyInformation(bean.getCandidacyDate(), bean.getSelectedDegreeList(), bean.getPrecedentDegreeInformation(), bean.getProfessionalStatus(), bean.getOtherEducation());
        this.editPrecedentDegreeInformation(bean);
        return this;
    }

    public Degree getCandidacySelectedDegree() {
        throw new DomainException("shouldnt be called", new String[0]);
    }

    public Collection<Degree> getSelectedDegrees() {
        return this.getCandidacy().getSelectedDegreesSet();
    }

    public boolean hasCandidacyForSelectedDegree(Degree degree) {
        return this.getSelectedDegrees().contains(degree);
    }

    public String getCandidacyProfessionalStatus() {
        return this.getCandidacy().getProfessionalStatus();
    }

    public String getCandidacyOtherEducation() {
        return this.getCandidacy().getOtherEducation();
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation() {
        return this.getCandidacy().getRefactoredPrecedentDegreeInformation();
    }

    public Integer getCandidacyProfessionalExperience() {
        return this.getCandidacy().getProfessionalExperience();
    }

    public BigDecimal getCandidacyAffinity() {
        return this.getCandidacy().getAffinity();
    }

    public Integer getCandidacyDegreeNature() {
        return this.getCandidacy().getDegreeNature();
    }

    public BigDecimal getCandidacyGrade() {
        return this.getCandidacy().getCandidacyGrade();
    }

    public String getCandidacyInterviewGrade() {
        return this.getCandidacy().getInterviewGrade();
    }

    public BigDecimal getCandidacySeriesGrade() {
        return this.getCandidacy().getSeriesCandidacyGrade();
    }

    public String getCandidacyNotes() {
        return this.getCandidacy().getNotes();
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    private static boolean isAllowedToManageProcess(SecondCycleIndividualCandidacyProcess process2, User userView) {
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, userView.getPerson().getUser()).collect(Collectors.toSet());
        if (process2 == null || process2.getCandidacy() == null) {
            return false;
        }
        return !Collections.disjoint(programs, process2.getCandidacy().getSelectedDegreesSet());
    }

    private void editFormerIstStudentNumber(SecondCycleIndividualCandidacyProcessBean bean) {
        this.getCandidacy().editFormerIstStudentNumber(bean);
    }

    public Boolean isCandidacyProcessComplete() {
        return null;
    }

    public List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles() {
        ArrayList<IndividualCandidacyDocumentFileType> missingDocumentFiles = new ArrayList<IndividualCandidacyDocumentFileType>();
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PHOTO) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PHOTO);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.CV_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION);
        }
        if (this.getActiveFileForType(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT) == null) {
            missingDocumentFiles.add(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT);
        }
        return missingDocumentFiles;
    }

    protected void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile documentFile) {
        IndividualCandidacyDocumentFileType type = documentFile.getCandidacyFileType();
        IndividualCandidacyDocumentFile file = this.getActiveFileForType(type);
        if (file == null) {
            return;
        }
        if (IndividualCandidacyDocumentFileType.REPORT_OR_WORK_DOCUMENT.equals((Object)type)) {
            return;
        }
        file.setCandidacyFileActive(false);
    }

    static {
        activities.add(new CandidacyPayment());
        activities.add(new EditCandidacyPersonalInformation());
        activities.add(new EditCandidacyInformation());
        activities.add(new IntroduceCandidacyResult());
        activities.add(new ChangeIndividualCandidacyState());
        activities.add(new CancelCandidacy());
        activities.add(new CreateRegistration());
        activities.add(new EditPublicCandidacyPersonalInformation());
        activities.add(new EditPublicCandidacyDocumentFile());
        activities.add(new EditPublicCandidacyHabilitations());
        activities.add(new EditDocuments());
        activities.add(new BindPersonToCandidacy());
        activities.add(new ChangeProcessCheckedState());
        activities.add(new SendEmailForApplicationSubmission());
        activities.add(new RevokeDocumentFile());
        activities.add(new ChangePaymentCheckedState());
        activities.add(new RejectCandidacy());
        activities.add(new RevertApplicationToStandBy());
        activities.add(new CopyIndividualCandidacyToNextCandidacyProcess());
        activities.add(new MoveCandidacy());
    }

    private static class CopyIndividualCandidacyToNextCandidacyProcess
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private CopyIndividualCandidacyToNextCandidacyProcess() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyNotAccepted()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyProcessBean bean = (SecondCycleIndividualCandidacyProcessBean)object;
            SecondCycleCandidacyProcess destinationCandidacyProcess = bean.getCopyDestinationProcess();
            SecondCycleIndividualCandidacyProcessBean newBean = new SecondCycleIndividualCandidacyProcessBean(process2);
            newBean.setCandidacyProcess((CandidacyProcess)((Object)destinationCandidacyProcess));
            newBean.setPublicCandidacyHashCode(DegreeOfficePublicCandidacyHashCode.getUnusedOrCreateNewHashCode(SecondCycleIndividualCandidacyProcess.class, (CandidacyProcess)((Object)destinationCandidacyProcess), process2.getCandidacyHashCode().getEmail()));
            newBean.setPersonBean(new PersonBean(process2.getPersonalDetails()));
            newBean.setCandidacyDate(destinationCandidacyProcess.getCandidacyPeriod().getStart().toLocalDate());
            newBean.initializeDocumentUploadBeans();
            SecondCycleIndividualCandidacyProcess newProcess = (SecondCycleIndividualCandidacyProcess)((Object)Process.createNewProcess(userView, SecondCycleIndividualCandidacyProcess.class, (Object)newBean));
            newProcess.setOriginalIndividualCandidacyProcess((IndividualCandidacyProcess)((Object)process2));
            SecondCycleIndividualCandidacyEvent event = (SecondCycleIndividualCandidacyEvent)((Object)newProcess.getCandidacy().getEvent());
            new SecondCycleIndividualCandidacyExemption(userView.getPerson(), event, CandidacyExemptionJustificationType.TRANSFERED_APPLICATION);
            Set documents = process2.getCandidacy().getDocumentsSet();
            for (IndividualCandidacyDocumentFile individualCandidacyDocumentFile : documents) {
                individualCandidacyDocumentFile.addIndividualCandidacy((IndividualCandidacy)((Object)newProcess.getCandidacy()));
            }
            return newProcess;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }
    }

    private static class RevertApplicationToStandBy
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private RevertApplicationToStandBy() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyCancelled() && !process2.isCandidacyRejected()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.getCandidacy().setState(IndividualCandidacyState.STAND_BY);
            return process2;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }
    }

    private static class MoveCandidacy
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private MoveCandidacy() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || !process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcess candidacyProcess = (CandidacyProcess)((Object)object);
            process2.setCandidacyProcess(candidacyProcess);
            return process2;
        }
    }

    private static class RejectCandidacy
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private RejectCandidacy() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || !process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.rejectCandidacy(userView.getPerson());
            return process2;
        }
    }

    protected static class RevokeDocumentFile
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        protected RevokeDocumentFile() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            ((CandidacyProcessDocumentUploadBean)object).getDocumentFile().setCandidacyFileActive(Boolean.FALSE);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class SendEmailForApplicationSubmission
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private SendEmailForApplicationSubmission() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            DegreeOfficePublicCandidacyHashCode hashCode = (DegreeOfficePublicCandidacyHashCode)((Object)object);
            hashCode.sendEmailForApplicationSuccessfullySubmited();
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ChangePaymentCheckedState
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private ChangePaymentCheckedState() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.setPaymentChecked(((IndividualCandidacyProcessBean)object).getPaymentChecked());
            return process2;
        }
    }

    private static class ChangeProcessCheckedState
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private ChangeProcessCheckedState() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.setProcessChecked(((IndividualCandidacyProcessBean)object).getProcessChecked());
            return process2;
        }
    }

    private static class BindPersonToCandidacy
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private BindPersonToCandidacy() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyInternal().booleanValue()) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyProcessBean bean = (SecondCycleIndividualCandidacyProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            process2.bindPerson(bean.getChoosePersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditDocuments
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private EditDocuments() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }
    }

    private static class EditPublicCandidacyHabilitations
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private EditPublicCandidacyHabilitations() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyProcessBean bean = (SecondCycleIndividualCandidacyProcessBean)object;
            process2.editCandidacyHabilitations(bean);
            process2.editFormerIstStudentNumber(bean);
            process2.getCandidacy().editSelectedDegrees(bean.getSelectedDegreeList());
            process2.getCandidacy().editObservations(bean);
            process2.editPrecedentDegreeInformation(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyDocumentFile
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private EditPublicCandidacyDocumentFile() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            CandidacyProcessDocumentUploadBean bean = (CandidacyProcessDocumentUploadBean)object;
            process2.bindIndividualCandidacyDocumentFile(bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class EditPublicCandidacyPersonalInformation
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private EditPublicCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!process2.isCandidacyInStandBy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.editPersonalCandidacyInformation(((SecondCycleIndividualCandidacyProcessBean)object).getPersonBean());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return Boolean.FALSE;
        }
    }

    private static class ChangeIndividualCandidacyState
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private ChangeIndividualCandidacyState() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator() && !process2.isSentToScientificCouncil()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyResultBean bean = (SecondCycleIndividualCandidacyResultBean)object;
            process2.getCandidacy().setState(bean.getState());
            return process2;
        }
    }

    private static class CreateRegistration
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private CreateRegistration() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyAccepted()) {
                throw new PreConditionNotValidException();
            }
            if (process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyProcessBean bean = (SecondCycleIndividualCandidacyProcessBean)object;
            this.createRegistration(process2, bean);
            return process2;
        }

        private void createRegistration(SecondCycleIndividualCandidacyProcess candidacyProcess, SecondCycleIndividualCandidacyProcessBean bean) {
            candidacyProcess.getCandidacy().createRegistration(this.getDegreeCurricularPlan(bean), CycleType.SECOND_CYCLE, IngressionType.findByPredicate(IngressionType::isInternal2ndCycleAccess).orElse(null));
        }

        private DegreeCurricularPlan getDegreeCurricularPlan(SecondCycleIndividualCandidacyProcessBean bean) {
            return bean.getSelectedDegree().getLastActiveDegreeCurricularPlan();
        }
    }

    private static class CancelCandidacy
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private CancelCandidacy() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyInStandBy() || process2.hasAnyPaymentForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.cancelCandidacy(userView.getPerson());
            return process2;
        }
    }

    private static class IntroduceCandidacyResult
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private IntroduceCandidacyResult() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView) && !RoleType.COORDINATOR.isMember(userView.getPerson().getUser())) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isCandidacyDebtPayed()) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isSentToCoordinator()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyResultBean bean = (SecondCycleIndividualCandidacyResultBean)object;
            SecondCycleIndividualCandidacySeriesGrade seriesGrade = process2.getCandidacy().getSecondCycleIndividualCandidacySeriesGradeForDegree(bean.getDegree());
            seriesGrade.setAffinity(bean.getAffinity());
            seriesGrade.setProfessionalExperience(bean.getProfessionalExperience());
            seriesGrade.setDegreeNature(bean.getDegreeNature());
            seriesGrade.setCandidacyGrade(bean.getGrade());
            seriesGrade.setInterviewGrade(bean.getInterviewGrade());
            seriesGrade.setSeriesCandidacyGrade(bean.getSeriesGrade());
            seriesGrade.setNotes(bean.getNotes());
            seriesGrade.setState(bean.getSeriesGradeState());
            return process2;
        }
    }

    private static class EditCandidacyInformation
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private EditCandidacyInformation() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled() || process2.isCandidacyAccepted() || process2.hasRegistrationForCandidacy()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            process2.editCandidacyHabilitations((SecondCycleIndividualCandidacyProcessBean)object);
            process2.getCandidacy().editObservations((SecondCycleIndividualCandidacyProcessBean)object);
            process2.editCandidacyInformation((SecondCycleIndividualCandidacyProcessBean)object);
            return process2;
        }
    }

    private static class EditCandidacyPersonalInformation
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private EditCandidacyPersonalInformation() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            SecondCycleIndividualCandidacyProcessBean bean = (SecondCycleIndividualCandidacyProcessBean)object;
            process2.editPersonalCandidacyInformation(bean.getPersonBean());
            return process2;
        }
    }

    private static class CandidacyPayment
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        private CandidacyPayment() {
        }

        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
            if (!SecondCycleIndividualCandidacyProcess.isAllowedToManageProcess(process2, userView)) {
                throw new PreConditionNotValidException();
            }
            if (process2.isCandidacyCancelled()) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess process2, User userView, Object object) {
            return process2;
        }
    }

    @StartActivity
    public static class IndividualCandidacyInformation
    extends Activity<SecondCycleIndividualCandidacyProcess> {
        @Override
        public void checkPreConditions(SecondCycleIndividualCandidacyProcess process2, User userView) {
        }

        @Override
        protected SecondCycleIndividualCandidacyProcess executeActivity(SecondCycleIndividualCandidacyProcess dummy, User userView, Object object) {
            return new SecondCycleIndividualCandidacyProcess((SecondCycleIndividualCandidacyProcessBean)object);
        }
    }
}

