/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.StorkAttributeType;

public class StorkAttributesList
implements Serializable {
    public static StorkAttributesList EMPTY = new EmptyTypeOfStorkAttributesList();
    private final Set<StorkAttributeType> types = new HashSet<StorkAttributeType>();

    private StorkAttributesList() {
    }

    private StorkAttributesList(String types) {
        this.types.addAll(this.convertToSet(types));
    }

    public StorkAttributesList(Collection<StorkAttributeType> types) {
        this.types.addAll(types);
    }

    public Set<StorkAttributeType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public String toString() {
        return this.convertToString(this.types);
    }

    private String convertToString(Set<StorkAttributeType> types) {
        StringBuilder result = new StringBuilder();
        for (StorkAttributeType each : types) {
            result.append(each.name()).append(",");
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private Set<StorkAttributeType> convertToSet(String types) {
        HashSet<StorkAttributeType> result = new HashSet<StorkAttributeType>();
        for (String each : types.split(",")) {
            String valueToParse = each.trim();
            if (StringUtils.isEmpty((String)valueToParse)) continue;
            result.add(StorkAttributeType.valueOf(valueToParse));
        }
        return result;
    }

    public static StorkAttributesList importFromString(String value) {
        return StringUtils.isEmpty((String)value) ? EMPTY : new StorkAttributesList(value);
    }

    private static class EmptyTypeOfStorkAttributesList
    extends StorkAttributesList {
        private static final long serialVersionUID = 1L;

        private EmptyTypeOfStorkAttributesList() {
        }

        @Override
        public Set<StorkAttributeType> getTypes() {
            return Collections.emptySet();
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

