/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.degree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistribution;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistributionEntry_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class ShiftDistributionEntry
extends ShiftDistributionEntry_Base {
    public static final Comparator<ShiftDistributionEntry> NUMBER_COMPARATOR = new Comparator<ShiftDistributionEntry>(){

        @Override
        public int compare(ShiftDistributionEntry o1, ShiftDistributionEntry o2) {
            return o1.getAbstractStudentNumber().compareTo(o2.getAbstractStudentNumber());
        }
    };

    private ShiftDistributionEntry() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setDistributed(Boolean.FALSE);
    }

    public ShiftDistributionEntry(ShiftDistribution shiftDistribution, ExecutionDegree executionDegree, Shift shift, Integer abstractStudentNumber) {
        this();
        this.init(shiftDistribution, executionDegree, shift, abstractStudentNumber);
    }

    private void checkParameters(ShiftDistribution shiftDistribution, ExecutionDegree executionDegree, Shift shift, Integer abstractStudentNumber) {
        if (shiftDistribution == null) {
            throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.shiftDistribution.cannot.be.null", new String[0]);
        }
        if (executionDegree == null) {
            throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.executionDegree.cannot.be.null", new String[0]);
        }
        if (shift == null) {
            throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.shift.cannot.be.null", new String[0]);
        }
        if (abstractStudentNumber == null) {
            throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.abstractStudentNumber.cannot.be.null", new String[0]);
        }
    }

    protected void init(ShiftDistribution shiftDistribution, ExecutionDegree executionDegree, Shift shift, Integer abstractStudentNumber) {
        this.checkParameters(shiftDistribution, executionDegree, shift, abstractStudentNumber);
        super.setShiftDistribution(shiftDistribution);
        super.setExecutionDegree(executionDegree);
        super.setShift(shift);
        super.setAbstractStudentNumber(abstractStudentNumber);
    }

    public void delete() {
        super.setShiftDistribution(null);
        super.setExecutionDegree(null);
        super.setShift(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public void changeShift(Shift newShift) {
        super.setShift(newShift);
    }

    public void changeExecutionDegree(ExecutionDegree executionDegree) {
        super.setExecutionDegree(executionDegree);
    }

    private boolean isFor(ExecutionYear executionYear) {
        return this.getShiftDistribution().getExecutionYear() == executionYear;
    }

    public void setShiftDistribution(ShiftDistribution shiftDistribution) {
        throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.cannot.modify.shiftDistribution", new String[0]);
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.cannot.modify.executionDegree", new String[0]);
    }

    public void setShift(Shift shift) {
        throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.cannot.modify.shiftName", new String[0]);
    }

    public void setAbstractStudentNumber(Integer abstractStudentNumber) {
        throw new DomainException("error.candidacy.degree.ShiftDistributionEntry.cannot.modify.studentNumber", new String[0]);
    }

    public boolean alreadyDistributed() {
        return this.getDistributed();
    }

    public static List<ShiftDistributionEntry> readByAbstractNumber(Integer abstractNumber, ExecutionYear executionYear) {
        ArrayList<ShiftDistributionEntry> result = new ArrayList<ShiftDistributionEntry>();
        for (ShiftDistributionEntry entry : Bennu.getInstance().getShiftDistributionEntriesSet()) {
            if (!entry.getAbstractStudentNumber().equals(abstractNumber) || !entry.isFor(executionYear)) continue;
            result.add(entry);
        }
        return result;
    }
}

