/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.MeasurementTestRoom;
import org.fenixedu.academic.domain.candidacy.MeasurementTestShift;
import org.fenixedu.academic.domain.candidacy.MeasurementTest_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;

public class MeasurementTest
extends MeasurementTest_Base {
    protected MeasurementTest() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public MeasurementTest(EntryPhase entryPhase, ExecutionYear executionYear, Space campus) {
        this();
        String[] args = new String[]{};
        if (entryPhase == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTest.entryPhase.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (executionYear == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTest.executionYear.cannot.be.null", args1);
        }
        String[] args2 = new String[]{};
        if (campus == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.candidacy.MeasurementTest.campus.cannot.be.null", args2);
        }
        this.setEntryPhase(entryPhase);
        this.setExecutionYear(executionYear);
        this.setCampus(campus);
    }

    public void assignToRoom(Registration registration) {
        for (MeasurementTestShift shift : this.getSortedShifts()) {
            if (!shift.getForDegreeCurricularPlanSet().contains((Object)registration.getActiveDegreeCurricularPlan()) || !shift.hasAvailableRoom()) continue;
            shift.getAvailableRoom().addRegistrations(registration);
            return;
        }
        throw new DomainException("error.candidacy.MeasurementTest.unable.to.find.empty.room.for.registration", new String[0]);
    }

    private SortedSet<MeasurementTestShift> getSortedShifts() {
        TreeSet<MeasurementTestShift> result = new TreeSet<MeasurementTestShift>(MeasurementTestShift.COMPARATOR_BY_NAME);
        result.addAll(this.getShiftsSet());
        return result;
    }

    public Set<Registration> getAssignedRegistrations() {
        HashSet<Registration> result = new HashSet<Registration>();
        for (MeasurementTestShift shift : this.getSortedShifts()) {
            for (MeasurementTestRoom room : shift.getSortedRooms()) {
                result.addAll(room.getRegistrationsSet());
            }
        }
        return result;
    }

    public static MeasurementTest readBy(EntryPhase entryPhase, ExecutionYear executionYear, Space campus) {
        for (MeasurementTest test : Bennu.getInstance().getMeasurementTestsSet()) {
            if (!test.isFor(entryPhase, executionYear, campus)) continue;
            return test;
        }
        return null;
    }

    private boolean isFor(EntryPhase entryPhase, ExecutionYear executionYear, Space campus) {
        return this.getEntryPhase().equals((Object)entryPhase) && this.getExecutionYear() == executionYear && this.getCampus() == campus;
    }

    public MeasurementTestShift getShiftByName(String name) {
        for (MeasurementTestShift each : this.getShiftsSet()) {
            if (!each.getName().equals(name)) continue;
            return each;
        }
        return null;
    }
}

