/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestPR;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestWithoutBasePR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class CertificateRequestWithoutBasePR
extends CertificateRequestWithoutBasePR_Base {
    protected CertificateRequestWithoutBasePR() {
    }

    public CertificateRequestWithoutBasePR(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        CertificateRequestEvent certificateRequestEvent = (CertificateRequestEvent)((Object)event);
        Money amountForUnits = this.getAmountForUnits(event);
        return this.isUrgent(certificateRequestEvent) ? amountForUnits.multiply(2) : amountForUnits;
    }

    public Money getAmountForUnits(Event event) {
        Money money = super.getAmountForUnits(event);
        Money maximumAmount = this.getMaximumAmount();
        return maximumAmount == null || maximumAmount.isZero() || money.lessThan(maximumAmount) ? money : maximumAmount;
    }

    public CertificateRequestPR edit(Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.deactivate();
        return new CertificateRequestWithoutBasePR(this.getEntryType(), this.getEventType(), new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }
}

