/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentCodes;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class AccountingEventPaymentCode
extends AccountingEventPaymentCode_Base {
    private static final Logger logger = LoggerFactory.getLogger(AccountingEventPaymentCode.class);

    protected AccountingEventPaymentCode() {
    }

    protected AccountingEventPaymentCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Money minAmount, Money maxAmount, Person person) {
        this();
        this.init(paymentCodeType, startDate, endDate, event, minAmount, maxAmount, person);
    }

    public static AccountingEventPaymentCode create(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Money minAmount, Money maxAmount, Person person) {
        return PaymentCode.canGenerateNewCode(AccountingEventPaymentCode.class, paymentCodeType, person) ? new AccountingEventPaymentCode(paymentCodeType, startDate, endDate, event, minAmount, maxAmount, person) : AccountingEventPaymentCode.findAndReuseExistingCode(paymentCodeType, startDate, endDate, event, minAmount, maxAmount, person);
    }

    protected static AccountingEventPaymentCode findAndReuseExistingCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Money minAmount, Money maxAmount, Person person) {
        for (PaymentCode code : person.getPaymentCodesBy(paymentCodeType)) {
            if (!code.isAvailableForReuse() || !AccountingEventPaymentCode.getPaymentCodeGenerator((PaymentCodeType)paymentCodeType).isCodeMadeByThisFactory(code)) continue;
            AccountingEventPaymentCode accountingEventPaymentCode = (AccountingEventPaymentCode)((Object)code);
            accountingEventPaymentCode.reuse(startDate, endDate, minAmount, maxAmount, event);
            return accountingEventPaymentCode;
        }
        return null;
    }

    protected void init(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Money minAmount, Money maxAmount, Person person) {
        super.init(paymentCodeType, startDate, endDate, minAmount, maxAmount, person);
        this.checkParameters(event, person);
        super.setAccountingEvent(event);
    }

    protected void checkParameters(Event event, Person person) {
        if (person == null || person.getStudent() == null) {
            throw new DomainException("error.accounting.paymentCodes.AccountingEventPaymentCode.student.cannot.be.null", new String[0]);
        }
    }

    public void setAccountingEvent(Event accountingEvent) {
        if (this.getAccountingEvent() != null || !this.isNew()) {
            throw new DomainException("error.accounting.paymentCodes.AccountingEventPaymentCode.cannot.modify.accountingEvent", new String[0]);
        }
        this._setAccountingEvent(accountingEvent);
    }

    protected void _setAccountingEvent(Event accountingEvent) {
        super.setAccountingEvent(accountingEvent);
    }

    public void reuse(YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Event event) {
        this.reuseCode();
        this.update(startDate, endDate, minAmount, maxAmount);
        super.setAccountingEvent(event);
    }

    protected void internalProcess(Person person, Money amount, DateTime whenRegistered, String sibsTransactionId, String comments) {
        Event event = this.getAccountingEvent();
        if (event.isCancelled()) {
            logger.warn("############################ PROCESSING CODE FOR CANCELLED EVENT ###############################");
            logger.warn("Event " + event.getExternalId() + " for person " + event.getPerson().getExternalId() + " is cancelled");
            logger.warn("Code Number: " + this.getCode());
            logger.warn("################################################################################################");
        }
        event.process(person.getUser(), this, amount, new SibsTransactionDetailDTO(whenRegistered, sibsTransactionId, this.getCode(), comments));
    }

    public void delete() {
        super.setAccountingEvent(null);
        super.delete();
    }

    public void setPerson(Person student) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.person", new String[0]);
    }

    protected void _setPerson(Person person) {
        super.setPerson(person);
    }

    public boolean isAccountingEventPaymentCode() {
        return true;
    }

    static {
        AccountingEventPaymentCode.getRelationPaymentCodeAccountingEvent().addListener((RelationListener)new RelationAdapter<AccountingEventPaymentCode, Event>(){

            public void beforeAdd(AccountingEventPaymentCode accountingEventPaymentCode, Event event) {
                if (event instanceof InsuranceEvent && event.getAllPaymentCodes() != null) {
                    throw new DomainException("error.accounting.paymentCodes.AccountingEventPaymentCode.InsuranceEvent.already.has.payment.code.associated", new String[0]);
                }
            }
        });
    }
}

