/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.List;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.CurricularManagementLog;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.LessonPlanning_Base;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class LessonPlanning
extends LessonPlanning_Base {
    public static final Comparator<LessonPlanning> COMPARATOR_BY_ORDER = new Comparator<LessonPlanning>(){

        @Override
        public int compare(LessonPlanning o1, LessonPlanning o2) {
            return o1.getOrderOfPlanning().compareTo(o2.getOrderOfPlanning());
        }
    };

    public LessonPlanning(MultiLanguageString title, MultiLanguageString planning, ShiftType lessonType, ExecutionCourse executionCourse) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setLastOrder(executionCourse, lessonType);
        this.setTitle(title);
        this.setPlanning(planning);
        this.setLessonType(lessonType);
        this.setExecutionCourse(executionCourse);
        CurricularManagementLog.createLog(executionCourse, "resources.MessagingResources", "log.executionCourse.curricular.planning.added", title.getContent(), lessonType.getFullNameTipoAula(), executionCourse.getNome(), executionCourse.getDegreePresentationString());
    }

    public void delete() {
        this.reOrderLessonPlannings();
        this.deleteWithoutReOrder();
    }

    public void deleteWithoutReOrder() {
        CurricularManagementLog.createLog(this.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.curricular.planning.removed", this.getTitle().getContent(), this.getLessonType().getFullNameTipoAula(), this.getExecutionCourse().getNome(), this.getExecutionCourse().getDegreePresentationString());
        super.setExecutionCourse(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getLessonType() != null && this.getPlanning() != null && !this.getPlanning().isEmpty() && this.getTitle() != null && !this.getTitle().isEmpty() && this.getOrderOfPlanning() != null;
    }

    public void setLessonType(ShiftType lessonType) {
        if (lessonType == null) {
            throw new DomainException("error.LessonPlanning.no.lessonType", new String[0]);
        }
        super.setLessonType(lessonType);
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        if (executionCourse == null) {
            throw new DomainException("error.LessonPlanning.no.executionCourse", new String[0]);
        }
        super.setExecutionCourse(executionCourse);
    }

    public void setPlanning(MultiLanguageString planning) {
        if (planning == null || planning.getAllContents().isEmpty()) {
            throw new DomainException("error.LessonPlanning.no.planning", new String[0]);
        }
        super.setPlanning(planning);
    }

    public void setTitle(MultiLanguageString title) {
        if (title == null || title.getAllContents().isEmpty()) {
            throw new DomainException("error.LessonPlanning.no.title", new String[0]);
        }
        super.setTitle(title);
    }

    public void setOrderOfPlanning(Integer orderOfPlanning) {
        if (orderOfPlanning == null) {
            throw new DomainException("error.LessonPlanning.empty.order", new String[0]);
        }
        super.setOrderOfPlanning(orderOfPlanning);
    }

    public void moveTo(Integer order) {
        List<LessonPlanning> lessonPlannings = this.getExecutionCourse().getLessonPlanningsOrderedByOrder(this.getLessonType());
        if (!lessonPlannings.isEmpty() && order != this.getOrderOfPlanning() && order <= lessonPlannings.size() && order >= 1) {
            LessonPlanning posPlanning = lessonPlannings.get(order - 1);
            Integer posOrder = posPlanning.getOrderOfPlanning();
            posPlanning.setOrderOfPlanning(this.getOrderOfPlanning());
            this.setOrderOfPlanning(posOrder);
        }
    }

    private void reOrderLessonPlannings() {
        List<LessonPlanning> lessonPlannings = this.getExecutionCourse().getLessonPlanningsOrderedByOrder(this.getLessonType());
        if (!lessonPlannings.isEmpty() && !lessonPlannings.get(lessonPlannings.size() - 1).equals((Object)this)) {
            for (int i = this.getOrderOfPlanning().intValue(); i < lessonPlannings.size(); ++i) {
                LessonPlanning planning = lessonPlannings.get(i);
                planning.setOrderOfPlanning(planning.getOrderOfPlanning() - 1);
            }
        }
    }

    private void setLastOrder(ExecutionCourse executionCourse, ShiftType lessonType) {
        List<LessonPlanning> lessonPlannings = executionCourse.getLessonPlanningsOrderedByOrder(lessonType);
        Integer order = !lessonPlannings.isEmpty() ? lessonPlannings.get(lessonPlannings.size() - 1).getOrderOfPlanning() + 1 : 1;
        this.setOrderOfPlanning(order);
    }

    public String getLessonPlanningLabel() {
        StringBuilder builder = new StringBuilder();
        builder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.lesson", (String[])new String[0])).append(" ");
        builder.append(this.getOrderOfPlanning()).append(" (");
        builder.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getLessonType().getName(), (String[])new String[0])).append(") - ");
        builder.append(this.getTitle().getContent());
        return builder.toString();
    }

    public void logEditEditLessonPlanning() {
        CurricularManagementLog.createLog(this.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.curricular.planning.edited", this.getTitle().getContent(), this.getLessonType().getFullNameTipoAula(), this.getExecutionCourse().getNome(), this.getExecutionCourse().getDegreePresentationString());
    }
}

