/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourseType;
import org.fenixedu.academic.domain.CompetenceCourse_Base;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.CompetenceCoursePredicates;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.UniqueAcronymCreator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class CompetenceCourse
extends CompetenceCourse_Base {
    public static final Comparator<CompetenceCourse> COMPETENCE_COURSE_COMPARATOR_BY_NAME = new Comparator<CompetenceCourse>(){

        @Override
        public int compare(CompetenceCourse o1, CompetenceCourse o2) {
            int result = Collator.getInstance().compare(o1.getName(), o2.getName());
            return result != 0 ? result : DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2);
        }
    };

    protected CompetenceCourse() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CompetenceCourse(String code, String name, Collection<Department> departments) {
        this();
        super.setCurricularStage(CurricularStage.OLD);
        this.fillFields(code, name);
        if (departments != null) {
            this.addDepartments(departments);
        }
    }

    public CompetenceCourse(String name, String nameEn, Boolean basic, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType type, CurricularStage curricularStage, CompetenceCourseGroupUnit unit, ExecutionSemester startSemester) {
        this();
        super.setCurricularStage(curricularStage);
        this.setType(type);
        CompetenceCourseInformation competenceCourseInformation = new CompetenceCourseInformation(name.trim(), nameEn.trim(), basic, regimeType, competenceCourseLevel, startSemester, unit);
        super.addCompetenceCourseInformations(competenceCourseInformation);
        try {
            UniqueAcronymCreator<CompetenceCourse> uniqueAcronymCreator = new UniqueAcronymCreator<CompetenceCourse>(CompetenceCourse::getName, CompetenceCourse::getAcronym, (Set)CompetenceCourse.readBolonhaCompetenceCourses());
            competenceCourseInformation.setAcronym(uniqueAcronymCreator.create(this).getLeft());
        }
        catch (Exception e) {
            throw new DomainException("competence.course.unable.to.create.acronym", new String[0]);
        }
    }

    public CompetenceCourse(String name, String nameEn, Boolean basic, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType type, CurricularStage curricularStage, CompetenceCourseGroupUnit unit) {
        this(name, nameEn, basic, regimeType, competenceCourseLevel, type, curricularStage, unit, ExecutionSemester.readActualExecutionSemester());
    }

    public boolean isBolonha() {
        return !this.getCurricularStage().equals((Object)CurricularStage.OLD);
    }

    public void addCompetenceCourseLoad(Double theoreticalHours, Double problemsHours, Double laboratorialHours, Double seminaryHours, Double fieldWorkHours, Double trainingPeriodHours, Double tutorialOrientationHours, Double autonomousWorkHours, Double ectsCredits, Integer order, AcademicPeriod academicPeriod) {
        this.checkIfCanEdit(false);
        this.getMostRecentCompetenceCourseInformation().addCompetenceCourseLoads(new CompetenceCourseLoad(theoreticalHours, problemsHours, laboratorialHours, seminaryHours, fieldWorkHours, trainingPeriodHours, tutorialOrientationHours, autonomousWorkHours, ectsCredits, order, academicPeriod));
    }

    public BibliographicReferences.BibliographicReference getBibliographicReference(Integer oid) {
        return this.getMostRecentCompetenceCourseInformation().getBibliographicReferences().getBibliographicReference(oid);
    }

    public BibliographicReferences getBibliographicReferences() {
        return this.getBibliographicReferences(null);
    }

    public BibliographicReferences getBibliographicReferences(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getBibliographicReferences() : null;
    }

    public List<BibliographicReferences.BibliographicReference> getMainBibliographicReferences() {
        return this.getMainBibliographicReferences(null);
    }

    public List<BibliographicReferences.BibliographicReference> getMainBibliographicReferences(ExecutionSemester period) {
        return this.getBibliographicReferences(period).getMainBibliographicReferences();
    }

    public List<BibliographicReferences.BibliographicReference> getSecondaryBibliographicReferences() {
        return this.getSecondaryBibliographicReferences(null);
    }

    public List<BibliographicReferences.BibliographicReference> getSecondaryBibliographicReferences(ExecutionSemester period) {
        return this.getBibliographicReferences(period).getSecondaryBibliographicReferences();
    }

    public List<BibliographicReferences.BibliographicReference> getAllBibliographicReferences(ExecutionSemester executionSemester) {
        ArrayList<BibliographicReferences.BibliographicReference> result = new ArrayList<BibliographicReferences.BibliographicReference>();
        result.addAll(this.getMainBibliographicReferences(executionSemester));
        result.addAll(this.getSecondaryBibliographicReferences(executionSemester));
        return result;
    }

    public void createBibliographicReference(String year, String title, String authors, String reference, String url, BibliographicReferences.BibliographicReferenceType type) {
        this.checkIfCanEdit(false);
        CompetenceCourseInformation info = this.getMostRecentCompetenceCourseInformation();
        info.setBibliographicReferences(info.getBibliographicReferences().with(year, title, authors, reference, url, type));
    }

    public void editBibliographicReference(Integer index, String year, String title, String authors, String reference, String url, BibliographicReferences.BibliographicReferenceType type) {
        CompetenceCourseInformation info = this.getMostRecentCompetenceCourseInformation();
        info.setBibliographicReferences(info.getBibliographicReferences().replacing(index, year, title, authors, reference, url, type));
    }

    public void deleteBibliographicReference(Integer index) {
        CompetenceCourseInformation info = this.getMostRecentCompetenceCourseInformation();
        info.setBibliographicReferences(info.getBibliographicReferences().without(index));
    }

    public void switchBibliographicReferencePosition(Integer oldPosition, Integer newPosition) {
        CompetenceCourseInformation info = this.getMostRecentCompetenceCourseInformation();
        info.setBibliographicReferences(info.getBibliographicReferences().movingBibliographicReference(oldPosition, newPosition));
    }

    private void fillFields(String code, String name) {
        if (code == null || code.length() == 0) {
            throw new DomainException("invalid.competenceCourse.values", new String[0]);
        }
        if (name == null || name.length() == 0) {
            throw new DomainException("invalid.competenceCourse.values", new String[0]);
        }
        super.setCode(code);
        super.setName(name);
    }

    public void edit(String code, String name, Collection<Department> departments) {
        this.fillFields(code, name);
        for (Department department : this.getDepartmentsSet()) {
            if (departments.contains((Object)department)) continue;
            super.removeDepartments(department);
        }
        for (Department department : departments) {
            if (this.getDepartmentsSet().contains((Object)department)) continue;
            super.addDepartments(department);
        }
    }

    public void edit(String name, String nameEn, Boolean basic, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType type, CurricularStage curricularStage) {
        this.changeCurricularStage(curricularStage);
        this.setType(type);
        this.getMostRecentCompetenceCourseInformation().edit(name.trim(), nameEn.trim(), basic, competenceCourseLevel);
        String acronym = null;
        try {
            UniqueAcronymCreator<CompetenceCourse> uniqueAcronymCreator = new UniqueAcronymCreator<CompetenceCourse>(CompetenceCourse::getName, CompetenceCourse::getAcronym, (Set)CompetenceCourse.readBolonhaCompetenceCourses());
            acronym = uniqueAcronymCreator.create(this).getLeft();
        }
        catch (Exception e) {
            throw new DomainException("competence.course.unable.to.create.acronym", new String[0]);
        }
        this.getMostRecentCompetenceCourseInformation().setAcronym(acronym);
    }

    public void editAcronym(String acronym) {
        Set bolonhaCompetenceCourses = (Set)CompetenceCourse.readBolonhaCompetenceCourses();
        for (CompetenceCourse competenceCourse : bolonhaCompetenceCourses) {
            if (competenceCourse.equals((Object)this) || !competenceCourse.getAcronym().equalsIgnoreCase(acronym.trim())) continue;
            throw new DomainException("competenceCourse.existing.acronym", competenceCourse.getName(), competenceCourse.getDepartmentUnit().getDepartment().getRealName());
        }
        this.getMostRecentCompetenceCourseInformation().setAcronym(acronym);
    }

    public void changeCurricularStage(CurricularStage curricularStage) {
        if (curricularStage.equals((Object)CurricularStage.APPROVED)) {
            super.setCreationDateYearMonthDay(new YearMonthDay());
        }
        this.setCurricularStage(curricularStage);
    }

    private void checkIfCanEdit(boolean scientificCouncilEdit) {
        if (!scientificCouncilEdit && this.getCurricularStage().equals((Object)CurricularStage.APPROVED)) {
            throw new DomainException("competenceCourse.approved", new String[0]);
        }
    }

    public void edit(String objectives, String program, String evaluationMethod, String objectivesEn, String programEn, String evaluationMethodEn) {
        this.getMostRecentCompetenceCourseInformation().edit(objectives, program, evaluationMethod, objectivesEn, programEn, evaluationMethodEn);
    }

    public void delete() {
        if (!this.getAssociatedCurricularCoursesSet().isEmpty()) {
            throw new DomainException("mustDeleteCurricularCoursesFirst", new String[0]);
        }
        if (this.getCurricularStage().equals((Object)CurricularStage.APPROVED)) {
            throw new DomainException("competenceCourse.approved", new String[0]);
        }
        this.getDepartmentsSet().clear();
        while (!this.getCompetenceCourseInformationsSet().isEmpty()) {
            ((CompetenceCourseInformation)((Object)this.getCompetenceCourseInformationsSet().iterator().next())).delete();
        }
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public void addCurricularCourses(Collection<CurricularCourse> curricularCourses) {
        for (CurricularCourse curricularCourse : curricularCourses) {
            this.addAssociatedCurricularCourses(curricularCourse);
        }
    }

    public void addDepartments(Collection<Department> departments) {
        for (Department department : departments) {
            super.addDepartments(department);
        }
    }

    public TreeSet<CompetenceCourseInformation> getSortedCompetenceCourseInformations() {
        return this.getOrderedCompetenceCourseInformations();
    }

    private TreeSet<CompetenceCourseInformation> getOrderedCompetenceCourseInformations() {
        TreeSet<CompetenceCourseInformation> informations = new TreeSet<CompetenceCourseInformation>(CompetenceCourseInformation.COMPARATORY_BY_EXECUTION_PERIOD);
        informations.addAll(this.getCompetenceCourseInformationsSet());
        return informations;
    }

    private CompetenceCourseInformation getMostRecentCompetenceCourseInformation() {
        return this.getMostRecentCompetenceCourseInformationUntil(ExecutionSemester.readActualExecutionSemester());
    }

    private CompetenceCourseInformation getMostRecentCompetenceCourseInformationUntil(ExecutionSemester semester) {
        CompetenceCourseInformation mostRecentInformation = this.getOldestCompetenceCourseInformation();
        for (CompetenceCourseInformation information : this.getCompetenceCourseInformationsSet()) {
            if (!information.getExecutionPeriod().isAfter(mostRecentInformation.getExecutionPeriod()) || information.getExecutionPeriod().isAfter(semester)) continue;
            mostRecentInformation = information;
        }
        return mostRecentInformation;
    }

    private CompetenceCourseInformation getOldestCompetenceCourseInformation() {
        Set competenceCourseInformations = this.getCompetenceCourseInformationsSet();
        if (competenceCourseInformations.isEmpty()) {
            return null;
        }
        return Collections.min(competenceCourseInformations, CompetenceCourseInformation.COMPARATORY_BY_EXECUTION_PERIOD);
    }

    public boolean isCompetenceCourseInformationDefinedAtExecutionPeriod(ExecutionSemester executionSemester) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(executionSemester);
        return information != null && information.getExecutionPeriod().equals(executionSemester);
    }

    public boolean isLoggedPersonAllowedToView() {
        Person person = AccessControl.getPerson();
        if (this.isApproved()) {
            return true;
        }
        if (RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser())) {
            return true;
        }
        if (!RoleType.BOLONHA_MANAGER.isMember(person.getUser())) {
            return false;
        }
        return this.getDepartmentUnit().getDepartment().isUserMemberOfCompetenceCourseMembersGroup(person);
    }

    public boolean isLoggedPersonAllowedToViewChangeRequests() {
        Person person = AccessControl.getPerson();
        if (RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser())) {
            return true;
        }
        if (!RoleType.BOLONHA_MANAGER.isMember(person.getUser())) {
            return false;
        }
        for (CompetenceCourseInformation information : this.getCompetenceCourseInformationsSet()) {
            if (!information.getDepartmentUnit().getDepartment().isUserMemberOfCompetenceCourseMembersGroup(person)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoggedPersonAllowedToCreateChangeRequests(ExecutionSemester semester) {
        Person person = AccessControl.getPerson();
        if (RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser())) {
            return true;
        }
        if (!RoleType.BOLONHA_MANAGER.isMember(person.getUser())) {
            return false;
        }
        return this.getDepartmentUnit(semester).getDepartment().isUserMemberOfCompetenceCourseMembersGroup(person);
    }

    public boolean isRequestDraftAvailable(ExecutionSemester semester) {
        return this.getChangeRequestDraft(semester) != null;
    }

    public CompetenceCourseInformation findCompetenceCourseInformationForExecutionPeriod(ExecutionSemester executionSemester) {
        if (!this.isBolonha()) {
            return null;
        }
        if (executionSemester == null) {
            return this.getMostRecentCompetenceCourseInformation();
        }
        if (executionSemester.isBefore(this.getOldestCompetenceCourseInformation().getExecutionPeriod())) {
            return null;
        }
        CompetenceCourseInformation minCompetenceCourseInformation = null;
        for (CompetenceCourseInformation competenceCourseInformation : this.getOrderedCompetenceCourseInformations()) {
            if (competenceCourseInformation.getExecutionPeriod().isAfter(executionSemester)) {
                return minCompetenceCourseInformation;
            }
            minCompetenceCourseInformation = competenceCourseInformation;
        }
        return minCompetenceCourseInformation;
    }

    public CompetenceCourseInformation findCompetenceCourseInformationForExecutionYear(ExecutionYear executionYear) {
        if (!this.isBolonha()) {
            return null;
        }
        if (executionYear == null) {
            return this.getMostRecentCompetenceCourseInformation();
        }
        if (executionYear.isBefore(this.getOldestCompetenceCourseInformation().getExecutionYear())) {
            return null;
        }
        CompetenceCourseInformation minCompetenceCourseInformation = null;
        for (CompetenceCourseInformation competenceCourseInformation : this.getOrderedCompetenceCourseInformations()) {
            if (competenceCourseInformation.getExecutionYear().isBeforeOrEquals(executionYear)) {
                minCompetenceCourseInformation = competenceCourseInformation;
                continue;
            }
            return minCompetenceCourseInformation;
        }
        return minCompetenceCourseInformation;
    }

    public String getName(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        if ((super.getName() == null || super.getName().length() == 0) && information != null) {
            return information.getName();
        }
        return super.getName();
    }

    public String getName() {
        return this.getName(null);
    }

    public String getNameEn(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getNameEn() : null;
    }

    public String getNameEn() {
        return this.getNameEn(null);
    }

    public String getAcronym(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getAcronym() : null;
    }

    public String getAcronym() {
        return this.getAcronym(null);
    }

    public void setAcronym(String acronym) {
        this.getMostRecentCompetenceCourseInformation().setAcronym(acronym);
    }

    public boolean isBasic(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getBasic() : null;
    }

    public boolean isBasic() {
        return this.isBasic(null);
    }

    public RegimeType getRegime(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getRegime() : null;
    }

    public RegimeType getRegime(ExecutionYear executionYear) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionYear(executionYear);
        return information != null ? information.getRegime() : null;
    }

    public RegimeType getRegime() {
        return this.getRegime((ExecutionSemester)null);
    }

    public void setRegime(RegimeType regimeType) {
        this.getMostRecentCompetenceCourseInformation().setRegime(regimeType);
    }

    public CompetenceCourseLevel getCompetenceCourseLevel(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getCompetenceCourseLevel() : null;
    }

    public CompetenceCourseLevel getCompetenceCourseLevel() {
        return this.getCompetenceCourseLevel((ExecutionSemester)null);
    }

    public Collection<CompetenceCourseLoad> getCompetenceCourseLoads(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getCompetenceCourseLoadsSet() : null;
    }

    public Collection<CompetenceCourseLoad> getCompetenceCourseLoads() {
        return this.getCompetenceCourseLoads(null);
    }

    public int getCompetenceCourseLoadsCount(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getCompetenceCourseLoadsSet().size() : 0;
    }

    public int getCompetenceCourseLoadsCount() {
        return this.getCompetenceCourseLoadsCount(null);
    }

    public boolean hasCompetenceCourseInformationFor(ExecutionSemester semester) {
        for (CompetenceCourseInformation competenceInfo : this.getCompetenceCourseInformationsSet()) {
            if (!competenceInfo.getExecutionPeriod().equals(semester)) continue;
            return true;
        }
        return false;
    }

    public String getObjectives(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getObjectives() : null;
    }

    public String getObjectives() {
        return this.getObjectives(null);
    }

    public String getProgram(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getProgram() : null;
    }

    public String getProgram() {
        return this.getProgram(null);
    }

    public LocalizedString getLocalizedEvaluationMethod(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information == null ? null : new LocalizedString(Locale.getDefault(), information.getEvaluationMethod()).with(Locale.ENGLISH, information.getEvaluationMethodEn());
    }

    public String getEvaluationMethod(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getEvaluationMethod() : null;
    }

    public String getEvaluationMethod() {
        return this.getEvaluationMethod(null);
    }

    public String getObjectivesEn(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getObjectivesEn() : null;
    }

    public String getObjectivesEn() {
        return this.getObjectivesEn(null);
    }

    public String getProgramEn(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getProgramEn() : null;
    }

    public String getProgramEn() {
        return this.getProgramEn(null);
    }

    public String getEvaluationMethodEn(ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getEvaluationMethodEn() : null;
    }

    public String getEvaluationMethodEn() {
        return this.getEvaluationMethodEn(null);
    }

    public double getTheoreticalHours() {
        return this.getTheoreticalHours(null, null);
    }

    public Double getTheoreticalHours(Integer order) {
        return this.getTheoreticalHours(order, null);
    }

    public double getTheoreticalHours(ExecutionSemester period) {
        return this.getTheoreticalHours(null, period);
    }

    public double getTheoreticalHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getTheoreticalHours(order) : 0.0;
    }

    public double getProblemsHours() {
        return this.getProblemsHours(null, null);
    }

    public Double getProblemsHours(Integer order) {
        return this.getProblemsHours(order, null);
    }

    public double getProblemsHours(ExecutionSemester period) {
        return this.getProblemsHours(null, period);
    }

    public double getProblemsHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getProblemsHours(order) : 0.0;
    }

    public double getLaboratorialHours() {
        return this.getLaboratorialHours(null, null);
    }

    public Double getLaboratorialHours(Integer order) {
        return this.getLaboratorialHours(order, null);
    }

    public double getLaboratorialHours(ExecutionSemester period) {
        return this.getLaboratorialHours(null, period);
    }

    public double getLaboratorialHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getLaboratorialHours(order) : 0.0;
    }

    public double getSeminaryHours() {
        return this.getSeminaryHours(null, null);
    }

    public double getSeminaryHours(ExecutionSemester period) {
        return this.getSeminaryHours(null, period);
    }

    public Double getSeminaryHours(Integer order) {
        return this.getSeminaryHours(order, null);
    }

    public double getSeminaryHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getSeminaryHours(order) : 0.0;
    }

    public double getFieldWorkHours() {
        return this.getFieldWorkHours(null, null);
    }

    public double getFieldWorkHours(ExecutionSemester period) {
        return this.getFieldWorkHours(null, period);
    }

    public Double getFieldWorkHours(Integer order) {
        return this.getFieldWorkHours(order, null);
    }

    public double getFieldWorkHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getFieldWorkHours(order) : 0.0;
    }

    public double getTrainingPeriodHours() {
        return this.getTrainingPeriodHours(null, null);
    }

    public double getTrainingPeriodHours(ExecutionSemester period) {
        return this.getTrainingPeriodHours(null, period);
    }

    public Double getTrainingPeriodHours(Integer order) {
        return this.getTrainingPeriodHours(order, null);
    }

    public double getTrainingPeriodHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getTrainingPeriodHours(order) : 0.0;
    }

    public double getTutorialOrientationHours() {
        return this.getTutorialOrientationHours(null, null);
    }

    public Double getTutorialOrientationHours(Integer order) {
        return this.getTutorialOrientationHours(order, null);
    }

    public double getTutorialOrientationHours(ExecutionSemester period) {
        return this.getTutorialOrientationHours(null, period);
    }

    public double getTutorialOrientationHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getTutorialOrientationHours(order) : 0.0;
    }

    public double getOtherHours() {
        return this.getOtherHours(null, null);
    }

    public Double getOtherHours(Integer order) {
        return this.getOtherHours(order, null);
    }

    public double getOtherHours(ExecutionSemester period) {
        return this.getOtherHours(null, period);
    }

    public double getOtherHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getOtherHours(order) : 0.0;
    }

    public double getAutonomousWorkHours() {
        return this.getAutonomousWorkHours((Integer)null, (ExecutionSemester)null);
    }

    public double getAutonomousWorkHours(ExecutionSemester period) {
        return this.getAutonomousWorkHours((Integer)null, period);
    }

    public Double getAutonomousWorkHours(Integer order) {
        return this.getAutonomousWorkHours(order, (ExecutionSemester)null);
    }

    public final Double getAutonomousWorkHours(Integer order, ExecutionYear year) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionYear(year);
        return information != null ? information.getAutonomousWorkHours(order) : 0.0;
    }

    public Double getAutonomousWorkHours(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getAutonomousWorkHours(order) : 0.0;
    }

    public double getContactLoad() {
        return this.getContactLoad((Integer)null, (ExecutionSemester)null);
    }

    public Double getContactLoad(ExecutionSemester period) {
        return this.getContactLoad(null, period);
    }

    public Double getContactLoad(Integer order) {
        return this.getContactLoad(order, (ExecutionSemester)null);
    }

    public final Double getContactLoad(Integer order, ExecutionYear executionYear) {
        return this.getContactLoad(order, executionYear == null ? null : executionYear.getFirstExecutionPeriod());
    }

    public Double getContactLoad(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getContactLoad(order) : 0.0;
    }

    public double getTotalLoad() {
        return this.getTotalLoad((Integer)null, (ExecutionSemester)null);
    }

    public Double getTotalLoad(Integer order) {
        return this.getTotalLoad(order, (ExecutionSemester)null);
    }

    public double getTotalLoad(ExecutionSemester period) {
        return this.getTotalLoad((Integer)null, period);
    }

    public final Double getTotalLoad(Integer order, ExecutionYear executionYear) {
        return this.getTotalLoad(order, executionYear == null ? null : executionYear.getFirstExecutionPeriod());
    }

    public Double getTotalLoad(Integer order, ExecutionSemester period) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(period);
        return information != null ? information.getTotalLoad(order) : 0.0;
    }

    public double getEctsCredits() {
        return this.getEctsCredits((Integer)null, (ExecutionSemester)null);
    }

    public double getEctsCredits(Integer order) {
        return this.getEctsCredits(order, (ExecutionSemester)null);
    }

    public double getEctsCredits(ExecutionSemester executionSemester) {
        return this.getEctsCredits((Integer)null, executionSemester);
    }

    public final Double getEctsCredits(Integer order, ExecutionYear executionYear) {
        return this.getEctsCredits(order, executionYear == null ? null : executionYear.getFirstExecutionPeriod());
    }

    public Double getEctsCredits(Integer order, ExecutionSemester executionSemester) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionPeriod(executionSemester);
        return information != null ? information.getEctsCredits(order) : 0.0;
    }

    public Map<Degree, List<CurricularCourse>> getAssociatedCurricularCoursesGroupedByDegree() {
        HashMap<Degree, List<CurricularCourse>> curricularCoursesMap = new HashMap<Degree, List<CurricularCourse>>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            Degree degree = curricularCourse.getDegreeCurricularPlan().getDegree();
            ArrayList<CurricularCourse> curricularCourses = (ArrayList<CurricularCourse>)curricularCoursesMap.get(degree);
            if (curricularCourses == null) {
                curricularCourses = new ArrayList<CurricularCourse>();
                curricularCoursesMap.put(degree, curricularCourses);
            }
            curricularCourses.add(curricularCourse);
        }
        return curricularCoursesMap;
    }

    public Set<DegreeCurricularPlan> presentIn() {
        HashSet<DegreeCurricularPlan> result = new HashSet<DegreeCurricularPlan>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            result.add(curricularCourse.getDegreeCurricularPlan());
        }
        return result;
    }

    public boolean isAssociatedToAnyDegree(Set<Degree> degrees) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            Degree degree = degreeCurricularPlan.getDegree();
            if (!degrees.contains(degree)) continue;
            return true;
        }
        return false;
    }

    public List<CurricularCourse> getCurricularCoursesWithActiveScopesInExecutionPeriod(final ExecutionSemester executionSemester) {
        return (List)CollectionUtils.select((Collection)this.getAssociatedCurricularCoursesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)arg0);
                for (DegreeModuleScope moduleScope : curricularCourse.getDegreeModuleScopes()) {
                    if (!moduleScope.isActiveForExecutionPeriod(executionSemester)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public Collection<Context> getCurricularCourseContexts() {
        HashSet<Context> result = new HashSet<Context>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            for (Context context : curricularCourse.getParentContextsSet()) {
                result.add(context);
            }
        }
        return result;
    }

    public CurricularCourse getCurricularCourse(DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (curricularCourse.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return curricularCourse;
        }
        return null;
    }

    public List<Enrolment> getActiveEnrollments(ExecutionYear executionYear) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            results.addAll(curricularCourse.getActiveEnrollments(executionYear));
        }
        return results;
    }

    public List<Enrolment> getActiveEnrollments(ExecutionSemester executionSemester) {
        ArrayList<Enrolment> results = new ArrayList<Enrolment>();
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            curricularCourse.addActiveEnrollments(results, executionSemester);
        }
        return results;
    }

    public ExecutionInterval getBeginExecutionInterval() {
        CompetenceCourseInformation firstInformation = this.getOldestCompetenceCourseInformation();
        return firstInformation != null ? firstInformation.getExecutionInterval() : null;
    }

    public CompetenceCourseInformation getActiveCompetenceCourseInformation() {
        return this.getMostRecentCompetenceCourseInformationUntil(ExecutionSemester.readActualExecutionSemester());
    }

    public Boolean hasActiveScopesInExecutionYear(ExecutionYear executionYear) {
        Set executionSemesters = executionYear.getExecutionPeriodsSet();
        Set curricularCourses = this.getAssociatedCurricularCoursesSet();
        for (ExecutionSemester executionSemester : executionSemesters) {
            for (CurricularCourse curricularCourse : curricularCourses) {
                if (curricularCourse.getActiveDegreeModuleScopesInAcademicInterval(executionSemester.getAcademicInterval()).size() <= 0) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public boolean hasActiveScopesInExecutionPeriod(ExecutionSemester executionSemester) {
        Set curricularCourses = this.getAssociatedCurricularCoursesSet();
        for (CurricularCourse curricularCourse : curricularCourses) {
            if (curricularCourse.getActiveDegreeModuleScopesInAcademicInterval(executionSemester.getAcademicInterval()).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasDepartmentUnit() {
        return this.getDepartmentUnit() != null;
    }

    public DepartmentUnit getDepartmentUnit() {
        return this.getDepartmentUnit(ExecutionSemester.readActualExecutionSemester());
    }

    public DepartmentUnit getDepartmentUnit(ExecutionYear executionYear) {
        ExecutionSemester semester = ExecutionSemester.readBySemesterAndExecutionYear(2, executionYear.getYear());
        return this.getDepartmentUnit(semester);
    }

    public DepartmentUnit getDepartmentUnit(ExecutionSemester semester) {
        return this.getMostRecentCompetenceCourseInformationUntil(semester).getDepartmentUnit();
    }

    public CompetenceCourseGroupUnit getCompetenceCourseGroupUnit() {
        return this.getCompetenceCourseGroupUnit(ExecutionSemester.readActualExecutionSemester());
    }

    public CompetenceCourseGroupUnit getCompetenceCourseGroupUnit(ExecutionYear executionYear) {
        ExecutionSemester semester = ExecutionSemester.readBySemesterAndExecutionYear(2, executionYear.getYear());
        return this.getCompetenceCourseGroupUnit(semester);
    }

    public CompetenceCourseGroupUnit getCompetenceCourseGroupUnit(ExecutionSemester semester) {
        return this.getMostRecentCompetenceCourseInformationUntil(semester).getCompetenceCourseGroupUnit();
    }

    public CompetenceCourseGroupUnit getMostRecentGroupInDepartment(DepartmentUnit departmentUnit) {
        for (ExecutionSemester semester = ExecutionSemester.readActualExecutionSemester(); semester != null; semester = semester.getPreviousExecutionPeriod()) {
            if (this.getDepartmentUnit(semester) != departmentUnit) continue;
            return this.getCompetenceCourseGroupUnit(semester);
        }
        return null;
    }

    public List<CompetenceCourseLoad> getSortedCompetenceCourseLoads(ExecutionSemester period) {
        ArrayList<CompetenceCourseLoad> result = new ArrayList<CompetenceCourseLoad>(this.getCompetenceCourseLoadsCount(period));
        result.addAll(this.getCompetenceCourseLoads(period));
        Collections.sort(result);
        return result;
    }

    public List<CompetenceCourseLoad> getSortedCompetenceCourseLoads() {
        ArrayList<CompetenceCourseLoad> result = new ArrayList<CompetenceCourseLoad>(this.getCompetenceCourseLoadsCount());
        result.addAll(this.getCompetenceCourseLoads());
        Collections.sort(result);
        return result;
    }

    public void addCompetenceCourseInformations(CompetenceCourseInformation competenceCourseInformations) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        super.addCompetenceCourseInformations(competenceCourseInformations);
    }

    public void addDepartments(Department departments) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        super.addDepartments(departments);
    }

    public void removeCompetenceCourseInformations(CompetenceCourseInformation competenceCourseInformations) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        super.removeCompetenceCourseInformations(competenceCourseInformations);
    }

    public void removeDepartments(Department departments) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        super.removeDepartments(departments);
    }

    public void setCode(String code) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        CompetenceCourse existing = CompetenceCourse.find(code);
        if (existing != null && existing != this) {
            throw new DomainException("error.CompetenceCourse.found.duplicate", new String[0]);
        }
        super.setCode(code);
    }

    public void setCurricularStage(CurricularStage curricularStage) {
        if (!this.getAssociatedCurricularCoursesSet().isEmpty() && curricularStage.equals((Object)CurricularStage.DRAFT)) {
            throw new DomainException("competenceCourse.has.already.associated.curricular.courses", new String[0]);
        }
        super.setCurricularStage(curricularStage);
    }

    public void setName(String name) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        super.setName(name);
    }

    public void addAssociatedCurricularCourses(CurricularCourse associatedCurricularCourses) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        super.addAssociatedCurricularCourses(associatedCurricularCourses);
    }

    public ScientificAreaUnit getScientificAreaUnit() {
        return this.getScientificAreaUnit(ExecutionSemester.readActualExecutionSemester());
    }

    public ScientificAreaUnit getScientificAreaUnit(ExecutionYear executionYear) {
        ExecutionSemester semester = ExecutionSemester.readBySemesterAndExecutionYear(2, executionYear.getYear());
        return this.getScientificAreaUnit(semester);
    }

    public ScientificAreaUnit getScientificAreaUnit(ExecutionSemester semester) {
        CompetenceCourseInformation mostRecentCompetenceCourseInformationUntil = this.getMostRecentCompetenceCourseInformationUntil(semester);
        return mostRecentCompetenceCourseInformationUntil != null ? mostRecentCompetenceCourseInformationUntil.getScientificAreaUnit() : null;
    }

    public boolean isAnual() {
        return this.getRegime() == RegimeType.ANUAL;
    }

    public boolean isAnual(ExecutionYear executionYear) {
        return this.getRegime(executionYear) == RegimeType.ANUAL;
    }

    public boolean isSemestrial(ExecutionYear executionYear) {
        return this.getRegime(executionYear) == RegimeType.SEMESTRIAL;
    }

    public boolean isApproved() {
        return this.getCurricularStage() == CurricularStage.APPROVED;
    }

    public void transfer(CompetenceCourseGroupUnit competenceCourseGroupUnit, ExecutionSemester period, String justification, Person requester) {
        CompetenceCourseInformation information = null;
        for (CompetenceCourseInformation existingInformation : this.getCompetenceCourseInformationsSet()) {
            if (existingInformation.getExecutionPeriod() != period) continue;
            information = existingInformation;
        }
        if (information == null) {
            CompetenceCourseInformation latestInformation = this.getMostRecentCompetenceCourseInformationUntil(period);
            information = new CompetenceCourseInformation(latestInformation);
            information.setExecutionPeriod(period);
        }
        CompetenceCourseInformationChangeRequest changeRequest = new CompetenceCourseInformationChangeRequest(information, justification, requester);
        changeRequest.setCompetenceCourseGroupUnit(competenceCourseGroupUnit);
        changeRequest.approve(requester);
    }

    public MultiLanguageString getNameI18N() {
        return this.getNameI18N(null);
    }

    public MultiLanguageString getNameI18N(ExecutionSemester semester) {
        String nameEn;
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        String name = this.getName(semester);
        if (name != null && name.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, name);
        }
        if ((nameEn = this.getNameEn(semester)) != null && nameEn.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, nameEn);
        }
        return multiLanguageString;
    }

    public MultiLanguageString getObjectivesI18N() {
        return this.getObjectivesI18N(null);
    }

    public MultiLanguageString getObjectivesI18N(ExecutionSemester semester) {
        String objectivesEn;
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        String objectives = this.getObjectives(semester);
        if (objectives != null && objectives.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, objectives);
        }
        if ((objectivesEn = this.getObjectivesEn(semester)) != null && objectivesEn.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, objectivesEn);
        }
        return multiLanguageString;
    }

    public MultiLanguageString getProgramI18N() {
        return this.getProgramI18N(null);
    }

    public MultiLanguageString getProgramI18N(ExecutionSemester semester) {
        String programEn;
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        String program = this.getProgram(semester);
        if (program != null && program.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, program);
        }
        if ((programEn = this.getProgramEn(semester)) != null && programEn.length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, programEn);
        }
        return multiLanguageString;
    }

    public List<ExecutionCourse> getExecutionCoursesByExecutionPeriod(ExecutionSemester executionSemester) {
        ArrayList<ExecutionCourse> executionCourseList = new ArrayList<ExecutionCourse>();
        executionCourseList.addAll(this.getExecutionCoursesByExecutionPeriod(executionSemester, new HashSet<ExecutionCourse>()));
        return executionCourseList;
    }

    public Set<ExecutionCourse> getExecutionCoursesByExecutionPeriod(ExecutionSemester executionSemester, Set<ExecutionCourse> resultSet) {
        List<CurricularCourse> curricularCourseList = this.getCurricularCoursesWithActiveScopesInExecutionPeriod(executionSemester);
        for (CurricularCourse curricularCourse : curricularCourseList) {
            resultSet.addAll(curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester));
        }
        return resultSet;
    }

    public boolean hasEnrolmentForPeriod(ExecutionSemester executionSemester) {
        for (CurricularCourse curricularCourse : this.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.hasEnrolmentForPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isDissertation() {
        return this.getType() == CompetenceCourseType.DISSERTATION;
    }

    public Integer getDraftCompetenceCourseInformationChangeRequestsCount() {
        int count = 0;
        for (CompetenceCourseInformationChangeRequest request : this.getCompetenceCourseInformationChangeRequestsSet()) {
            if (request.getApproved() != null) continue;
            ++count;
        }
        return count;
    }

    public Set<CompetenceCourseInformationChangeRequest> getCompetenceCourseInformationChangeRequests(ExecutionSemester semester) {
        HashSet<CompetenceCourseInformationChangeRequest> changeRequests = new HashSet<CompetenceCourseInformationChangeRequest>();
        for (CompetenceCourseInformationChangeRequest request : this.getCompetenceCourseInformationChangeRequestsSet()) {
            if (request.getExecutionPeriod() != semester) continue;
            changeRequests.add(request);
        }
        return changeRequests;
    }

    public CompetenceCourseInformationChangeRequest getChangeRequestDraft(ExecutionSemester semester) {
        for (CompetenceCourseInformationChangeRequest request : this.getCompetenceCourseInformationChangeRequests(semester)) {
            if (request.getApproved() != null) continue;
            return request;
        }
        return null;
    }

    public void addCompetenceCourseInformationChangeRequests(CompetenceCourseInformationChangeRequest request) {
        if (this.isRequestDraftAvailable(request.getExecutionPeriod())) {
            throw new DomainException("error.can.only.exist.one.request.draft.per.execution.period", new String[0]);
        }
        super.addCompetenceCourseInformationChangeRequests(request);
    }

    public boolean hasOneCourseLoad(ExecutionYear executionYear) {
        CompetenceCourseInformation information = this.findCompetenceCourseInformationForExecutionYear(executionYear);
        return information != null && information.getCompetenceCourseLoadsSet().size() == 1;
    }

    public boolean matchesName(String name) {
        name = StringNormalizer.normalize((String)name).replaceAll("[^0-9a-zA-Z]", " ").trim();
        for (CompetenceCourseInformation information : this.getCompetenceCourseInformationsSet()) {
            if (!StringNormalizer.normalize((String)information.getName()).matches(".*" + name.replaceAll(" ", ".*") + ".*")) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCode(String code) {
        if (this.getCode() == null) {
            return false;
        }
        code = StringNormalizer.normalize((String)code).replaceAll("[^0-9a-zA-Z]", " ").trim();
        return StringNormalizer.normalize((String)this.getCode()).matches(".*" + code.replaceAll(" ", ".*") + ".*");
    }

    public ExecutionSemester getStartExecutionSemester() {
        return this.getOldestCompetenceCourseInformation().getExecutionPeriod();
    }

    public static List<CompetenceCourse> readOldCompetenceCourses() {
        ArrayList<CompetenceCourse> result = new ArrayList<CompetenceCourse>();
        for (CompetenceCourse competenceCourse : Bennu.getInstance().getCompetenceCoursesSet()) {
            if (competenceCourse.isBolonha()) continue;
            result.add(competenceCourse);
        }
        return result;
    }

    public static Collection<CompetenceCourse> readBolonhaCompetenceCourses() {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        for (CompetenceCourse competenceCourse : Bennu.getInstance().getCompetenceCoursesSet()) {
            if (!competenceCourse.isBolonha()) continue;
            result.add(competenceCourse);
        }
        return result;
    }

    public static Collection<CompetenceCourse> searchBolonhaCompetenceCourses(String searchName, String searchCode) {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        for (CompetenceCourse competenceCourse : Bennu.getInstance().getCompetenceCoursesSet()) {
            if (!competenceCourse.isBolonha() || !searchName.isEmpty() && !competenceCourse.matchesName(searchName) || !searchCode.isEmpty() && !competenceCourse.matchesCode(searchCode)) continue;
            result.add(competenceCourse);
        }
        return result;
    }

    public static Collection<CompetenceCourse> readApprovedBolonhaCompetenceCourses() {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        for (CompetenceCourse competenceCourse : Bennu.getInstance().getCompetenceCoursesSet()) {
            if (!competenceCourse.isBolonha() || !competenceCourse.isApproved()) continue;
            result.add(competenceCourse);
        }
        return result;
    }

    public static Collection<CompetenceCourse> readApprovedBolonhaDissertations() {
        ArrayList<CompetenceCourse> result = new ArrayList<CompetenceCourse>();
        for (CompetenceCourse competenceCourse : Bennu.getInstance().getCompetenceCoursesSet()) {
            if (!competenceCourse.isBolonha() || !competenceCourse.isApproved() || !competenceCourse.isDissertation()) continue;
            result.add(competenceCourse);
        }
        return result;
    }

    @Deprecated
    public Date getCreationDate() {
        YearMonthDay ymd = this.getCreationDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setCreationDate(Date date) {
        AccessControl.check(this, CompetenceCoursePredicates.writePredicate);
        if (date == null) {
            this.setCreationDateYearMonthDay(null);
        } else {
            this.setCreationDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    public static CompetenceCourse find(String code) {
        if (StringUtils.isNotBlank((String)code)) {
            for (CompetenceCourse iter : Bennu.getInstance().getCompetenceCoursesSet()) {
                if (!StringUtils.equals((String)code, (String)iter.getCode())) continue;
                return iter;
            }
        }
        return null;
    }

    public CompetenceCourseInformation findInformation(ExecutionInterval input) {
        CompetenceCourseInformation result = null;
        for (CompetenceCourseInformation iter : this.getCompetenceCourseInformationsSet()) {
            if (!iter.getExecutionInterval().equals((Object)input)) continue;
            if (result != null) {
                throw new DomainException("error.CompetenceCourse.found.duplicate.CompetenceCourseInformation", result.toString(), iter.toString());
            }
            result = iter;
        }
        return result;
    }

    public CompetenceCourseInformation findInformationMostRecentUntil(ExecutionInterval input) {
        CompetenceCourseInformation result = null;
        if (!this.getCompetenceCourseInformationsSet().isEmpty()) {
            TreeSet<CompetenceCourseInformation> sorted = this.getOrderedCompetenceCourseInformations();
            Object until = input == null ? ExecutionSemester.readActualExecutionSemester() : input;
            result = this.getOrderedCompetenceCourseInformations().first();
            for (CompetenceCourseInformation iter : sorted) {
                if (iter.getExecutionInterval().isAfter((ExecutionInterval)((Object)until)) || !iter.getExecutionInterval().isAfter(result.getExecutionInterval())) continue;
                result = iter;
            }
        }
        return result;
    }

    public boolean isAnual(ExecutionInterval input) {
        return this.getAcademicPeriod(input) == AcademicPeriod.YEAR;
    }

    public CompetenceCourseLevel getCompetenceCourseLevel(ExecutionInterval interval) {
        CompetenceCourseInformation information = this.findInformationMostRecentUntil(interval);
        return information != null ? information.getCompetenceCourseLevel() : null;
    }

    public AcademicPeriod getAcademicPeriod(ExecutionInterval input) {
        CompetenceCourseInformation information = this.findInformationMostRecentUntil(input);
        return information != null ? information.getAcademicPeriod() : null;
    }

    public AcademicPeriod getAcademicPeriod() {
        return this.getAcademicPeriod(null);
    }
}

