/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.CandidacyPeriodInDegreeCurricularPlan_Base;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.joda.time.DateTime;

public class CandidacyPeriodInDegreeCurricularPlan
extends CandidacyPeriodInDegreeCurricularPlan_Base {
    public CandidacyPeriodInDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, DateTime startDate, DateTime endDate) {
        this.init(degreeCurricularPlan, executionYear, startDate, endDate);
    }

    protected void init(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, DateTime startDate, DateTime endDate) {
        this.checkRuleToCreate(degreeCurricularPlan, executionYear);
        super.init(degreeCurricularPlan, executionYear.getFirstExecutionPeriod(), startDate, endDate);
    }

    private void checkRuleToCreate(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        if (degreeCurricularPlan.hasCandidacyPeriodFor(executionYear)) {
            throw new DomainException("error.CandidacyPeriodInDegreeCurricularPlan.degree.curricular.plan.already.contains.candidacy.period.for.execution.year", new String[0]);
        }
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }
}

