/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.thesis;

import java.io.Serializable;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;
import org.fenixedu.academic.util.MultiLanguageString;

public class StudentThesisInfo
implements Serializable {
    private Student student;
    private Enrolment enrolment;
    private Thesis thesis;
    private ThesisPresentationState state;

    public StudentThesisInfo(Enrolment enrolment) {
        this.setStudent(enrolment.getStudent());
        this.setEnrolment(enrolment);
        this.setThesis(enrolment.getThesis());
    }

    public Student getStudent() {
        return this.student;
    }

    protected void setStudent(Student student) {
        this.student = student;
    }

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    protected void setEnrolment(Enrolment enrolment) {
        this.enrolment = enrolment;
    }

    public Thesis getThesis() {
        return this.thesis;
    }

    protected void setThesis(Thesis thesis) {
        this.thesis = thesis;
        this.setState(thesis);
    }

    public String getSemester() {
        Enrolment enrolment = this.getEnrolment();
        CurricularCourse curricularCourse = enrolment.getCurricularCourse();
        return curricularCourse.isAnual() ? "" : enrolment.getExecutionPeriod().getSemester().toString();
    }

    public MultiLanguageString getTitle() {
        return this.thesis != null ? this.thesis.getTitle() : new MultiLanguageString();
    }

    public ThesisPresentationState getState() {
        return this.state;
    }

    private void setState(Thesis thesis) {
        this.state = ThesisPresentationState.getThesisPresentationState(thesis);
    }

    public String getThesisId() {
        Thesis thesis = this.getThesis();
        return thesis == null ? null : thesis.getExternalId();
    }

    public String getEnrolmentOID() {
        Enrolment enrolment = this.getEnrolment();
        return enrolment == null ? null : enrolment.getExternalId();
    }

    public boolean isUnassigned() {
        return this.getThesis() == null;
    }

    public boolean isDraft() {
        return this.getThesis() != null && this.getThesis().isDraft();
    }

    public boolean isSubmitted() {
        return this.getThesis() != null && this.getThesis().isSubmitted();
    }

    public boolean isWaitingConfirmation() {
        return this.getThesis() != null && this.getThesis().isWaitingConfirmation();
    }

    public boolean isConfirmed() {
        return this.getThesis() != null && this.getThesis().isConfirmed();
    }

    public boolean isEvaluated() {
        return this.getThesis() != null && this.getThesis().isEvaluated();
    }

    public boolean isPreEvaluated() {
        return this.isEvaluated() && !this.getThesis().isFinalThesis();
    }

    public boolean isSubmittedAndIsCoordinatorAndNotOrientator() {
        return this.getThesis() != null && this.getThesis().isSubmittedAndIsCoordinatorAndNotOrientator();
    }
}

