/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.ArrayList;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatterBuilder;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class DurationRenderer
extends OutputRenderer {
    private static final String SHORT = ".short";
    private static final String enumerationBundle = "ENUMERATION_RESOURCES";
    private static final String CLASS_NAME = DurationFieldType.class.getName() + ".";
    private boolean printZeroAlways = true;
    private String includedFields;

    protected Layout getLayout(Object object, Class type) {
        return new DurationRendererLayout();
    }

    private DurationFieldType[] getDurationFieldTypes() {
        ArrayList<DurationFieldType> result = new ArrayList<DurationFieldType>();
        if (this.getIncludedFields() == null) {
            result.add(DurationFieldType.hours());
            result.add(DurationFieldType.minutes());
        } else {
            PeriodType standard = PeriodType.standard();
            for (int index = 0; index < standard.size(); ++index) {
                if (!this.getIncludedFields().contains(standard.getFieldType(index).getName())) continue;
                result.add(standard.getFieldType(index));
            }
        }
        return result.toArray(new DurationFieldType[0]);
    }

    public boolean isPrintZeroAlways() {
        return this.printZeroAlways;
    }

    public void setPrintZeroAlways(boolean printZeroAlways) {
        this.printZeroAlways = printZeroAlways;
    }

    public String getIncludedFields() {
        return this.includedFields;
    }

    public void setIncludedFields(String includedFields) {
        this.includedFields = includedFields;
    }

    private class DurationRendererLayout
    extends Layout {
        private DurationRendererLayout() {
        }

        public HtmlComponent createComponent(Object object, Class type) {
            StringBuilder result = new StringBuilder();
            if (object != null) {
                MutablePeriod period;
                Duration duration = (Duration)object;
                PeriodFormatterBuilder periodFormatterBuilder = new PeriodFormatterBuilder();
                PeriodType periodType = PeriodType.forFields((DurationFieldType[])DurationRenderer.this.getDurationFieldTypes());
                if (DurationRenderer.this.printZeroAlways) {
                    periodFormatterBuilder.printZeroAlways();
                }
                if (duration.getMillis() < 0L) {
                    result.append("-");
                }
                if ((period = new MutablePeriod(Math.abs(duration.getMillis()), periodType)).isSupported(DurationFieldType.years())) {
                    periodFormatterBuilder.appendYears().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.years().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.months())) {
                    periodFormatterBuilder.appendMonths().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.months().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.weeks())) {
                    periodFormatterBuilder.appendWeeks().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.weeks().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.days())) {
                    periodFormatterBuilder.appendDays().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.days().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.hours())) {
                    periodFormatterBuilder.appendHours().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.hours().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.minutes())) {
                    periodFormatterBuilder.minimumPrintedDigits(2).appendMinutes().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.minutes().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.seconds())) {
                    periodFormatterBuilder.minimumPrintedDigits(2).appendSeconds().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.seconds().getName() + DurationRenderer.SHORT)));
                }
                if (period.isSupported(DurationFieldType.millis())) {
                    periodFormatterBuilder.minimumPrintedDigits(2).appendMillis().appendSuffix(RenderUtils.getResourceString((String)DurationRenderer.enumerationBundle, (String)(CLASS_NAME + DurationFieldType.millis().getName() + DurationRenderer.SHORT)));
                }
                result.append(periodFormatterBuilder.toFormatter().print((ReadablePeriod)period));
            }
            return new HtmlText(result.toString());
        }
    }
}

