/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.WebAddress;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class AbstractContactRenderer
extends OutputRenderer {
    private boolean publicSpace = false;
    private boolean showDefaultSuffix = true;
    private boolean showTypeSuffix = true;
    private String schema;
    private String bundle;
    private String defaultLabel;
    private String types = "PERSONAL, WORK, INSTITUTIONAL";
    private boolean showDefault;
    private boolean showType;

    protected List<MetaObject> getFilteredContacts(Collection<PartyContact> unfiltered) {
        String[] parts = this.getTypes().split(",");
        ArrayList<PartyContactType> typeEnums = new ArrayList<PartyContactType>();
        for (String part : parts) {
            typeEnums.add(PartyContactType.valueOf(part.trim()));
        }
        ArrayList<MetaObject> contacts = new ArrayList<MetaObject>();
        for (PartyContact contact : unfiltered) {
            if (!contact.isVisible() || !typeEnums.contains((Object)contact.getType())) continue;
            contacts.add(MetaObjectFactory.createObject((Object)((Object)contact), (Schema)RenderKit.getInstance().findSchema(this.getSchema())));
        }
        this.showType = this.isShowTypeSuffix() && contacts.size() > 1 && typeEnums.size() > 1;
        this.showDefault = this.isShowDefaultSuffix() && contacts.size() > 1;
        Collections.sort(contacts, new Comparator<MetaObject>(){

            @Override
            public int compare(MetaObject o1, MetaObject o2) {
                PartyContact contact1 = (PartyContact)((Object)o1.getObject());
                PartyContact contact2 = (PartyContact)((Object)o2.getObject());
                if (contact1.getType().ordinal() > contact2.getType().ordinal()) {
                    return -1;
                }
                if (contact1.getType().ordinal() < contact2.getType().ordinal()) {
                    return 1;
                }
                if (contact1.getDefaultContact().booleanValue()) {
                    return -1;
                }
                if (contact2.getDefaultContact().booleanValue()) {
                    return 1;
                }
                return contact1.getPresentationValue().compareTo(contact2.getPresentationValue());
            }
        });
        return contacts;
    }

    protected HtmlComponent getValue(PartyContact contact) {
        HtmlInlineContainer span = new HtmlInlineContainer();
        if (contact instanceof Phone) {
            span.addChild((HtmlComponent)new HtmlText(((Phone)((Object)contact)).getNumber()));
        } else if (contact instanceof MobilePhone) {
            span.addChild((HtmlComponent)new HtmlText(((MobilePhone)((Object)contact)).getNumber()));
        } else if (contact instanceof EmailAddress) {
            EmailAddress email = (EmailAddress)((Object)contact);
            if (this.isPublicSpace()) {
                HtmlImage img = new HtmlImage();
                img.setSource(RenderUtils.getContextRelativePath((String)"") + "/publico/viewHomepage.do?method=emailPng&amp;email=" + email.getExternalId());
                span.addChild((HtmlComponent)img);
            } else {
                HtmlLink link = new HtmlLink();
                link.setModuleRelative(false);
                link.setContextRelative(false);
                link.setUrl("mailto:" + email.getValue());
                link.setBody((HtmlComponent)new HtmlText(email.getValue()));
                span.addChild((HtmlComponent)link);
            }
        } else if (contact instanceof WebAddress) {
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setContextRelative(false);
            link.setUrl(((WebAddress)((Object)contact)).getPresentationValue());
            link.setBody((HtmlComponent)new HtmlText(((WebAddress)((Object)contact)).getPresentationValue()));
            span.addChild((HtmlComponent)link);
        }
        if (this.showType || this.showDefault && contact.isDefault()) {
            StringBuilder suffix = new StringBuilder();
            suffix.append(" (");
            if (this.showType) {
                suffix.append(RenderUtils.getEnumString((Enum)contact.getType()));
            }
            if (this.showDefault && contact.isDefault()) {
                if (this.showType) {
                    suffix.append(", ");
                }
                suffix.append(RenderUtils.getResourceString((String)this.getBundle(), (String)this.getDefaultLabel()));
            }
            suffix.append(")");
            span.addChild((HtmlComponent)new HtmlText(suffix.toString()));
        }
        return span;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isPublicSpace() {
        return this.publicSpace;
    }

    public void setPublicSpace(boolean publicSpace) {
        this.publicSpace = publicSpace;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public boolean isShowDefaultSuffix() {
        return this.showDefaultSuffix;
    }

    public void setShowDefaultSuffix(boolean showDefaultSuffix) {
        this.showDefaultSuffix = showDefaultSuffix;
    }

    public boolean isShowTypeSuffix() {
        return this.showTypeSuffix;
    }

    public void setShowTypeSuffix(boolean showTypeSuffix) {
        this.showTypeSuffix = showTypeSuffix;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }
}

