/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.servlet.taglib.sop.v3.ClassTimeTableWithLinksLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.ColorPicker;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.SubtitleEntry;
import org.fenixedu.academic.servlet.taglib.sop.v3.TimeTable;
import org.fenixedu.academic.servlet.taglib.sop.v3.TimeTableRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.colorPickers.ClassTimeTableColorPicker;
import org.fenixedu.academic.servlet.taglib.sop.v3.colorPickers.ExecutionCourseTimeTableColorPicker;
import org.fenixedu.academic.servlet.taglib.sop.v3.colorPickers.RoomTimeTableColorPicker;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ClassTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ClassTimeTableWithoutLinksLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ExecutionCourseTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.RoomTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ShiftEnrollmentTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ShiftTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.SopClassRoomTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.SopClassTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.SopRoomTimeTableLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.SpaceManagerRoomTimeTableLessonContentRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenderTimeTableTag
extends TagSupport {
    private static final Integer DEFAULT_END_TIME = 0;
    private static final Logger logger = LoggerFactory.getLogger(RenderTimeTableTag.class);
    private LessonSlotContentRenderer lessonSlotContentRenderer = null;
    private int type = 1;
    private String application = "";
    private String studentID = "";
    private String classID = "";
    private String executionCourseID = "";
    private String executionSemesterID = "";
    private String action = "";
    private String endTime = "";
    private Integer endTimeTableHour = new Integer(24);
    private final Integer slotSizeMinutes = new Integer(30);
    private boolean definedWidth = true;
    private ColorPicker colorPicker;
    private String name;
    protected static MessageResources messages = MessageResources.getMessageResources((String)"PublicDegreeInformation");
    private InfoCurricularYear infoCurricularYear = null;
    private InfoExecutionDegree infoExecutionDegree = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int doStartTag() throws JspException {
        try {
            this.infoCurricularYear = (InfoCurricularYear)this.pageContext.findAttribute("curricular_year");
            this.infoExecutionDegree = (InfoExecutionDegree)this.pageContext.findAttribute("execution_degree");
        }
        catch (ClassCastException e) {
            this.infoCurricularYear = null;
            this.infoExecutionDegree = null;
        }
        this.setLessonSlotRendererAndColorPicker();
        Integer startTimeTableHour = Integer.MAX_VALUE;
        this.endTimeTableHour = DEFAULT_END_TIME;
        List infoLessonList = null;
        try {
            infoLessonList = (List)this.pageContext.findAttribute(this.name);
            if (infoLessonList.size() > 0) {
                for (InfoShowOccupation occupation : infoLessonList) {
                    if (occupation.getFirstHourOfDay() < startTimeTableHour) {
                        startTimeTableHour = occupation.getFirstHourOfDay();
                    }
                    if (occupation.getLastHourOfDay() <= this.endTimeTableHour) continue;
                    this.endTimeTableHour = occupation.getLastHourOfDay();
                }
            } else {
                startTimeTableHour = DEFAULT_END_TIME;
                this.endTimeTableHour = DEFAULT_END_TIME + 1;
            }
        }
        catch (ClassCastException e) {
            logger.error(e.getMessage(), (Throwable)e);
            infoLessonList = null;
        }
        if (infoLessonList == null) {
            throw new JspException(messages.getMessage("gerarHorario.listaAulas.naoExiste", (Object)this.name));
        }
        Locale locale = (Locale)this.pageContext.findAttribute("org.apache.struts.action.LOCALE");
        JspWriter writer = this.pageContext.getOut();
        TimeTable timeTable = this.generateTimeTable(infoLessonList, locale, this.pageContext, startTimeTableHour);
        TimeTableRenderer renderer = new TimeTableRenderer(timeTable, this.lessonSlotContentRenderer, this.slotSizeMinutes, startTimeTableHour, this.endTimeTableHour, this.colorPicker);
        try {
            writer.print((Object)renderer.render(locale, this.pageContext, this.getDefinedWidth()));
            writer.print((Object)this.legenda(infoLessonList, locale));
        }
        catch (IOException e) {
            throw new JspException(messages.getMessage("gerarHorario.io", (Object)e.toString()));
        }
        return 0;
    }

    private boolean hasLessonBefore8(List<InfoShowOccupation> infoLessonList) {
        for (InfoShowOccupation infoShowOccupation : infoLessonList) {
            if (infoShowOccupation.getFirstHourOfDay() >= 8) continue;
            return true;
        }
        return false;
    }

    private TimeTable generateTimeTable(List lessonList, Locale locale, PageContext pageContext, Integer startTimeTableHour) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, startTimeTableHour);
        calendar.set(12, 0);
        Integer numberOfDays = new Integer(6);
        Integer numberOfHours = new Integer((this.endTimeTableHour - startTimeTableHour) * (60 / this.slotSizeMinutes));
        TimeTable timeTable = new TimeTable(numberOfHours, numberOfDays, calendar, this.slotSizeMinutes, locale, pageContext);
        for (InfoShowOccupation infoShowOccupation : lessonList) {
            timeTable.addLesson(infoShowOccupation);
        }
        return timeTable;
    }

    public int doEndTag() {
        return 6;
    }

    public void release() {
        super.release();
        this.application = null;
        this.studentID = null;
        this.classID = null;
        this.executionCourseID = null;
        this.executionSemesterID = null;
        this.action = null;
        this.endTime = null;
    }

    private String getMessageResource(PageContext pageContext, String key) {
        try {
            return RequestUtils.message((PageContext)pageContext, (String)"PUBLIC_DEGREE_INFORMATION", (String)"org.apache.struts.action.LOCALE", (String)key);
        }
        catch (JspException e) {
            return "???" + key + "???";
        }
    }

    private StringBuilder legenda(List listaAulas, Locale locale) {
        StringBuilder result = new StringBuilder("");
        ArrayList<SubtitleEntry> listaAuxiliar = new ArrayList<SubtitleEntry>();
        for (InfoShowOccupation elem : listaAulas) {
            SubtitleEntry subtitleEntry;
            if (!(elem instanceof InfoLesson) && !(elem instanceof InfoLessonInstance) || listaAuxiliar.contains(subtitleEntry = new SubtitleEntry(elem.getInfoShift().getInfoDisciplinaExecucao().getSigla(), elem.getInfoShift().getInfoDisciplinaExecucao().getNome()))) continue;
            listaAuxiliar.add(subtitleEntry);
        }
        if (listaAuxiliar.size() > 1) {
            Collections.sort(listaAuxiliar);
            result.append("<br/><b>");
            result.append(this.getMessageResource(this.pageContext, "public.degree.information.label.legend"));
            result.append("</b><br /><br /><table cellpadding='0' cellspacing='0' style='margin-left:5px'>");
            for (int i = 0; i < listaAuxiliar.size(); ++i) {
                boolean oddElement;
                SubtitleEntry elem = (SubtitleEntry)listaAuxiliar.get(i);
                boolean bl = oddElement = i % 2 == 1;
                if (!oddElement) {
                    result.append("<tr>\r\n");
                }
                result.append("<td width='60'><b>");
                result.append(elem.getKey());
                result.append("</b></td><td  style='vertical-align:top'>-</td><td>");
                result.append(elem.getValue());
                result.append("</td>");
                if (!oddElement) continue;
                result.append("</tr>\r\n");
            }
            if (listaAuxiliar.size() % 2 == 1) {
                result.append("<td colspan='3'>&nbsp;</td></tr>");
            }
            result.append("<tr><td style='vertical-align:top'><b>[Q]</b></td>");
            result.append("<td  style='vertical-align:top'>-</td>");
            result.append("<td>");
            result.append(this.getMessageResource(this.pageContext, "public.degree.information.label.biweekly"));
            result.append("</td></tr>");
            result.append("</table>");
        }
        return result;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int timeTableType) {
        this.type = timeTableType;
        this.setLessonSlotRendererAndColorPicker();
    }

    private void setLessonSlotRendererAndColorPicker() {
        switch (this.type) {
            case 2: {
                this.lessonSlotContentRenderer = new ShiftTimeTableLessonContentRenderer();
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 4: {
                this.lessonSlotContentRenderer = new ExecutionCourseTimeTableLessonContentRenderer();
                this.colorPicker = new ExecutionCourseTimeTableColorPicker();
                break;
            }
            case 3: {
                this.lessonSlotContentRenderer = new RoomTimeTableLessonContentRenderer();
                this.colorPicker = new RoomTimeTableColorPicker();
                break;
            }
            case 5: {
                this.lessonSlotContentRenderer = new SopClassTimeTableLessonContentRenderer(this.infoExecutionDegree, this.infoCurricularYear);
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 6: {
                this.lessonSlotContentRenderer = new SopRoomTimeTableLessonContentRenderer();
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 10: {
                this.lessonSlotContentRenderer = new SpaceManagerRoomTimeTableLessonContentRenderer();
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 8: {
                this.lessonSlotContentRenderer = new SopClassRoomTimeTableLessonContentRenderer();
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 7: {
                this.lessonSlotContentRenderer = new ClassTimeTableWithoutLinksLessonContentRenderer();
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 1: {
                this.lessonSlotContentRenderer = new ClassTimeTableWithLinksLessonContentRenderer(this.getApplication());
                this.colorPicker = new ClassTimeTableColorPicker();
                break;
            }
            case 9: {
                Integer defaultTime;
                this.lessonSlotContentRenderer = new ShiftEnrollmentTimeTableLessonContentRenderer(this.getStudentID(), this.getApplication(), this.getClassID(), this.getExecutionCourseID(), this.getExecutionSemesterID(), this.getAction());
                this.colorPicker = new ClassTimeTableColorPicker();
                Integer endTime = defaultTime = new Integer(19);
                if (!this.getEndTime().equals("") && (endTime = new Integer(this.getEndTime())) < defaultTime) {
                    endTime = defaultTime;
                }
                this.endTimeTableHour = endTime;
                break;
            }
            default: {
                this.lessonSlotContentRenderer = new ClassTimeTableLessonContentRenderer();
                this.colorPicker = new ClassTimeTableColorPicker();
            }
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getStudentID() {
        return this.studentID;
    }

    public void setStudentID(String studentID) {
        this.studentID = studentID;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getClassID() {
        return this.classID;
    }

    public void setClassID(String classID) {
        this.classID = classID;
    }

    public String getExecutionCourseID() {
        return this.executionCourseID;
    }

    public void setExecutionCourseID(String executionCourseID) {
        this.executionCourseID = executionCourseID;
    }

    public String getExecutionSemesterID() {
        return this.executionSemesterID;
    }

    public void setExecutionSemesterID(String executionSemesterID) {
        this.executionSemesterID = executionSemesterID;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public boolean getDefinedWidth() {
        return this.definedWidth;
    }

    public void setDefinedWidth(boolean definedWidth) {
        this.definedWidth = definedWidth;
    }
}

