/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.EnrolmentCertificateRequestPR;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class EnrolmentCertificate
extends AdministrativeOfficeDocument {
    protected EnrolmentCertificate(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        EnrolmentCertificateRequest request = this.getDocumentRequest();
        Registration registration = this.getDocumentRequest().getRegistration();
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        String student = registration.getStudent().getPerson().isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolment.declaration.maleEnrolment", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolment.declaration.femaleEnrolment", (String[])new String[0]);
        this.addParameter("enrolmentsInfo", this.getEnrolmentsInfo());
        this.fillFirstParagraph(coordinator, coordinatorTitle);
        this.fillthirdthParagraph(registration, request, student);
        this.fillInstitutionAndStaffFields();
        this.setFooter((DocumentRequest)((Object)this.getDocumentRequest()));
    }

    protected EnrolmentCertificateRequest getDocumentRequest() {
        return (EnrolmentCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void addPriceFields() {
        EnrolmentCertificateRequest request = this.getDocumentRequest();
        PostingRule postingRule = this.getPostingRule();
        if (postingRule instanceof EnrolmentCertificateRequestPR) {
            EnrolmentCertificateRequestPR requestPR = (EnrolmentCertificateRequestPR)((Object)postingRule);
            this.addParameter("printed", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.printingPriceLabel", (String[])new String[0]));
            this.addParameter("printPriceLabel", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.issuingPriceLabel", (String[])new String[0]));
            this.addParameter("urgency", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.fastDeliveryPriceLabel", (String[])new String[0]));
            this.addParameter("total", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.totalsPriceLabel", (String[])new String[0]));
            this.addParameter("amountPerPage", requestPR.getAmountPerPage());
            this.addParameter("baseAmountPlusAmountForUnits", this.calculateAmountToPayPlusUnits(request, requestPR));
            this.addParameter("urgencyAmount", request.getUrgentRequest() != false ? requestPR.getBaseAmount() : Money.ZERO);
            this.addParameter("printPriceFields", this.printPriceParameters((CertificateRequest)((Object)request)));
        } else {
            super.addPriceFields();
        }
    }

    protected void fillFirstParagraph(Person coordinator, String coordinatorTitle) {
        String institutionName = this.getInstitutionName();
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String universityName = this.getUniversityName(new DateTime());
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", "     " + MessageFormat.format(stringTemplate, coordinator.getName(), coordinatorTitle, adminOfficeName.toUpperCase(this.getLocale()), institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
        this.addParameter("certificate", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.standaloneEnrolmentCertificate.secondParagraph", (String[])new String[0]));
    }

    private void fillthirdthParagraph(Registration registration, EnrolmentCertificateRequest request, String student) {
        String situation = "";
        if (request.getExecutionYear() != null) {
            situation = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)(this.getExecutionYear().containsDate(new DateTime()) ? "label.is" : "label.was"), (String[])new String[0]);
        }
        String detailed = request.getDetailed() != false ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolmentCertificate.detailed", (String[])new String[0]) : ".";
        String executionYear = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.declaration.registration.execution.year.prefix", (String[])new String[0]);
        String stringTemplate1 = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.academicDocument.enrolmentCertificate", (String[])new String[0]);
        this.addParameter("secondParagraph", MessageFormat.format(stringTemplate1, situation, student, executionYear, this.getDocumentRequest().getExecutionYear().getYear().toString(), this.getCurricularYear(), this.getDegreeDescription(), detailed));
    }

    private Money calculateAmountToPayPlusUnits(EnrolmentCertificateRequest request, EnrolmentCertificateRequestPR requestPR) {
        Money total = requestPR.getBaseAmount();
        if (request.isDetailed()) {
            total = total.add(this.getAmountForUnits(request, requestPR));
        }
        return total;
    }

    private Money getAmountForUnits(EnrolmentCertificateRequest request, EnrolmentCertificateRequestPR requestPR) {
        return requestPR.getAmountForUnits(request.getNumberOfUnits());
    }

    @Override
    protected String getDegreeDescription() {
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.getDegreeType().isComposite() && this.hasMoreThanOneCycle(registration)) {
            return registration.getDegreeDescription(this.getDocumentRequest().getExecutionYear(), (ProgramConclusion)null, this.getLocale());
        }
        DegreeType degreeType = registration.getDegreeType();
        CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
        return registration.getDegreeDescription(this.getExecutionYear(), cycleType, this.getLocale());
    }

    private boolean hasMoreThanOneCycle(Registration registration) {
        return registration.getInternalCycleCurriculumGrops().size() > 1;
    }

    private final String getCurricularYear() {
        StringBuilder result = new StringBuilder();
        DegreeCurricularPlan degreeCurricularPlan = this.getRegistration().getStudentCurricularPlan(this.getExecutionYear()).getDegreeCurricularPlan();
        if (degreeCurricularPlan.getDurationInYears() != 1) {
            Integer curricularYear = this.getDocumentRequest().getRegistration().getCurricularYear(this.getExecutionYear());
            result.append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)(curricularYear.toString() + ".ordinal"), (String[])new String[0]).toUpperCase());
            result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolment.declaration.curricularYear", (String[])new String[0]));
        }
        return result.toString();
    }

    private final String getEnrolmentsInfo() {
        StringBuilder result = new StringBuilder();
        EnrolmentCertificateRequest request = this.getDocumentRequest();
        if (request.getDetailed().booleanValue()) {
            TreeSet<Enrolment> enrolments = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_EXECUTION_YEAR_AND_NAME_AND_ID);
            enrolments.addAll(request.getEntriesToReport());
            this.reportEnrolments(result, enrolments);
            enrolments.clear();
            enrolments.addAll(request.getExtraCurricularEntriesToReport());
            if (!enrolments.isEmpty()) {
                this.reportRemainingEnrolments(result, enrolments, "Extra-Curriculares");
            }
            enrolments.clear();
            enrolments.addAll(request.getPropaedeuticEntriesToReport());
            if (!enrolments.isEmpty()) {
                this.reportRemainingEnrolments(result, enrolments, "Propedeuticas");
            }
            enrolments.clear();
            result.append(this.generateEndLine());
        }
        return result.toString();
    }

    private final void reportEnrolments(StringBuilder result, Collection<Enrolment> enrolments) {
        for (Enrolment enrolment : enrolments) {
            this.reportEnrolment(result, enrolment);
        }
    }

    private final void reportRemainingEnrolments(StringBuilder result, Collection<Enrolment> enrolments, String title) {
        result.append(this.generateEndLine()).append("\n").append(title).append(":").append("\n");
        for (Enrolment enrolment : enrolments) {
            this.reportEnrolment(result, enrolment);
        }
    }

    private final void reportEnrolment(StringBuilder result, Enrolment enrolment) {
        result.append(FenixStringTools.multipleLineRightPadWithSuffix(this.getPresentationNameFor(enrolment).toUpperCase(), 64, '-', this.getCreditsInfo(enrolment))).append("\n");
    }

    private final String getCreditsInfo(Enrolment enrolment) {
        StringBuilder result = new StringBuilder();
        if (this.getDocumentRequest().isToShowCredits()) {
            result.append(enrolment.getCurricularCourse().getEctsCredits(enrolment.getExecutionPeriod()).toString()).append(this.getCreditsDescription());
        }
        return result.toString();
    }
}

