/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class ThesisPredicates {
    public static final AccessControlPredicate<Thesis> waitingConfirmation = new AccessControlPredicate<Thesis>(){

        @Override
        public boolean evaluate(Thesis thesis) {
            return thesis.isWaitingConfirmation() || isScientificCouncil.evaluate(thesis);
        }
    };
    public static final AccessControlPredicate<Thesis> isScientificCouncil = new AccessControlPredicate<Thesis>(){

        @Override
        public boolean evaluate(Thesis thesis) {
            return RoleType.SCIENTIFIC_COUNCIL.isMember(AccessControl.getPerson().getUser());
        }
    };
    public static final AccessControlPredicate<Thesis> isScientificCouncilOrCoordinatorAndNotOrientatorOrCoorientator = new AccessControlPredicate<Thesis>(){

        @Override
        public boolean evaluate(Thesis thesis) {
            return isScientificCouncil.evaluate(thesis) || thesis.isCoordinatorAndNotOrientator();
        }
    };
    public static final AccessControlPredicate<Thesis> studentOrAcademicAdministrativeOfficeOrScientificCouncil = new AccessControlPredicate<Thesis>(){

        @Override
        public boolean evaluate(Thesis thesis) {
            Person person = AccessControl.getPerson();
            return person.getStudent() == thesis.getStudent() && thesis.isWaitingConfirmation() || AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.MANAGE_MARKSHEETS, (AcademicProgram)((Object)thesis.getDegree()), person.getUser()) || RoleType.SCIENTIFIC_COUNCIL.isMember(person.getUser());
        }
    };
    public static final AccessControlPredicate<Thesis> isScientificCommission = new AccessControlPredicate<Thesis>(){

        @Override
        public boolean evaluate(Thesis thesis) {
            Enrolment enrolment = thesis.getEnrolment();
            ExecutionYear executionYear = enrolment.getExecutionYear();
            DegreeCurricularPlan degreeCurricularPlan = enrolment.getDegreeCurricularPlanOfDegreeModule();
            return degreeCurricularPlan.isScientificCommissionMember(executionYear);
        }
    };
}

