/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.accounting.paymentPlan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.dto.accounting.PaymentsBean;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;

public class PaymentPlanBean
implements Serializable,
PaymentsBean {
    private static final long serialVersionUID = -103744109361724129L;
    private List<InstallmentBean> installments = new ArrayList<InstallmentBean>();
    private boolean forStudentEnroledOnSecondSemesterOnly;
    private boolean main;
    private boolean forPartialRegime;
    private boolean forSecondCurricularYear;
    private boolean forFirstTimeInstitutionStudents;
    private boolean forAlien;
    private List<DegreeCurricularPlan> degreeCurricularPlans = new ArrayList<DegreeCurricularPlan>();
    private ExecutionYear executionYear;

    public PaymentPlanBean(ExecutionYear executionYear) {
        this.setExecutionYear(executionYear);
    }

    public List<DegreeCurricularPlan> getDegreeCurricularPlans() {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan each : this.degreeCurricularPlans) {
            result.add(each);
        }
        return result;
    }

    public void setDegreeCurricularPlans(List<DegreeCurricularPlan> degreeCurricularPlans) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan each : degreeCurricularPlans) {
            result.add(each);
        }
        this.degreeCurricularPlans = result;
    }

    public void addInstallment(InstallmentBean installment) {
        this.installments.add(installment);
    }

    public List<InstallmentBean> getInstallments() {
        return Collections.unmodifiableList(this.installments);
    }

    public boolean isForStudentEnroledOnSecondSemesterOnly() {
        return this.forStudentEnroledOnSecondSemesterOnly;
    }

    public void setForStudentEnroledOnSecondSemesterOnly(boolean forStudentEnroledOnSecondSemesterOnly) {
        this.forStudentEnroledOnSecondSemesterOnly = forStudentEnroledOnSecondSemesterOnly;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public boolean isForPartialRegime() {
        return this.forPartialRegime;
    }

    public void setForPartialRegime(boolean forPartialRegime) {
        this.forPartialRegime = forPartialRegime;
    }

    public boolean isForFirstTimeInstitutionStudents() {
        return this.forFirstTimeInstitutionStudents;
    }

    public void setForFirstTimeInstitutionStudents(boolean forFirstTimeInstitutionStudents) {
        this.forFirstTimeInstitutionStudents = forFirstTimeInstitutionStudents;
    }

    public boolean isForAlien() {
        return this.forAlien;
    }

    public void setForAlien(boolean isForAlien) {
        this.forAlien = isForAlien;
    }

    @Override
    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public boolean isForSecondCurricularYear() {
        return this.forSecondCurricularYear;
    }

    public void setForSecondCurricularYear(boolean forSecondCurricularYear) {
        this.forSecondCurricularYear = forSecondCurricularYear;
    }

    public List<InstallmentBean> getSelectedInstallments() {
        ArrayList<InstallmentBean> result = new ArrayList<InstallmentBean>();
        for (InstallmentBean installmentBean : this.getInstallments()) {
            if (!installmentBean.isSelected()) continue;
            result.add(installmentBean);
        }
        return result;
    }

    public void removeSelectedInstallments() {
        for (InstallmentBean each : this.getSelectedInstallments()) {
            this.installments.remove(each);
        }
    }
}

