/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.StringTokenizer;
import org.fenixedu.academic.domain.Branch;
import org.fenixedu.academic.domain.branch.BranchType;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.commons.i18n.I18N;

public class InfoBranch
extends InfoObject {
    private final Branch branch;
    private final boolean showEnVersion = I18N.getLocale().equals(MultiLanguageString.en);

    public Branch getBranch() {
        return this.branch;
    }

    public InfoBranch(Branch branch) {
        this.branch = branch;
    }

    public String toString() {
        return this.getBranch().toString();
    }

    public Boolean representsCommonBranch() {
        return this.getName() != null && this.getName().equals("") && this.getCode() != null && this.getCode().equals("");
    }

    public String getPrettyCode() {
        if (this.representsCommonBranch().booleanValue()) {
            return "";
        }
        StringBuilder prettyCode = new StringBuilder();
        String namePart = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getName(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            namePart = stringTokenizer.nextToken();
            if (namePart.equalsIgnoreCase("RAMO") || namePart.length() <= 2) continue;
            prettyCode = prettyCode.append(namePart.substring(0, 1));
        }
        return prettyCode.toString();
    }

    public String getCode() {
        return this.getBranch().getCode();
    }

    public String getName() {
        return this.showEnVersion && this.getBranch().getNameEn() != null && this.getBranch().getNameEn().length() > 0 ? this.getBranch().getNameEn() : this.getBranch().getName();
    }

    public InfoDegreeCurricularPlan getInfoDegreeCurricularPlan() {
        return InfoDegreeCurricularPlan.newInfoFromDomain(this.getBranch().getDegreeCurricularPlan());
    }

    public String getAcronym() {
        return this.getBranch().getAcronym();
    }

    public Integer getSecondaryCredits() {
        return this.getBranch().getSecondaryCredits();
    }

    public Integer getSpecializationCredits() {
        return this.getBranch().getSpecializationCredits();
    }

    public BranchType getBranchType() {
        return this.getBranch().getBranchType();
    }

    public static InfoBranch newInfoFromDomain(Branch branch) {
        return branch == null ? null : new InfoBranch(branch);
    }

    public String getNameEn() {
        return this.getBranch().getNameEn();
    }

    @Override
    public String getExternalId() {
        return this.getBranch().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }
}

