/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Comparator;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentDataByExecutionYear_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class StudentDataByExecutionYear
extends StudentDataByExecutionYear_Base {
    public static final Comparator<StudentDataByExecutionYear> COMPARATOR_BY_EXECUTION_YEAR = new Comparator<StudentDataByExecutionYear>(){

        @Override
        public int compare(StudentDataByExecutionYear o1, StudentDataByExecutionYear o2) {
            return o1.getExecutionYear().compareTo(o2.getExecutionYear());
        }
    };

    private StudentDataByExecutionYear() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWorkingStudent(false);
    }

    public StudentDataByExecutionYear(Student student) {
        this();
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        this.checkParameters(student, executionYear);
        this.checkConditions(student, executionYear);
        this.setStudent(student);
        this.setExecutionYear(executionYear);
    }

    public StudentDataByExecutionYear(Student student, ExecutionYear executionYear) {
        this();
        this.checkParameters(student, executionYear);
        this.checkConditions(student, executionYear);
        this.setStudent(student);
        this.setExecutionYear(executionYear);
    }

    private void checkParameters(Student student, ExecutionYear executionYear) {
        if (student == null) {
            throw new RuntimeException("error.StudentDataByExecutionYear.student.cannot.be.null");
        }
        if (executionYear == null) {
            throw new RuntimeException("error.StudentDataByExecutionYear.executionYear.cannot.be.null");
        }
    }

    private void checkConditions(Student student, ExecutionYear executionYear) {
        if (student.getStudentDataByExecutionYear(executionYear) != null) {
            throw new DomainException("error.StudentDataByExecutionYear.student.already.has.data.for.given.executionYear", new String[0]);
        }
    }

    public void delete() {
        this.setExecutionYear(null);
        this.setResidenceCandidacy(null);
        this.setStudent(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }
}

