/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.DuplicateRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public class DuplicateRequest
extends DuplicateRequest_Base {
    protected DuplicateRequest() {
    }

    public DuplicateRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setDescription(bean.getDescription());
        super.setAmountToPay(bean.getAmountToPay());
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        if (StringUtils.isEmpty((String)bean.getDescription())) {
            throw new DomainException("error.DuplicateRequest.invalid.description", new String[0]);
        }
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public EventType getEventType() {
        return EventType.DUPLICATE_REQUEST;
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.DUPLICATE_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return false;
    }

    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType()) + " - " + super.getDescription();
    }
}

