/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProcessState$callable$editStateDate;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProcessState_Base;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessStateBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PhdProcessState
extends PhdProcessState_Base {
    public static final Comparator<PhdProcessState> COMPARATOR_BY_DATE;
    public static final Advice advice$editStateDate;

    protected PhdProcessState() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
    }

    protected void init(Person person, String remarks, DateTime stateDate, PhdProcessStateType type) {
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("error.PhdProcessState.invalid.person", args);
        }
        String[] args1 = new String[]{};
        if (stateDate == null) {
            throw new DomainException("error.PhdProcessState.invalid.stateDate", args1);
        }
        this.checkStateDate(stateDate, type);
        this.setPerson(person);
        this.setRemarks(remarks);
        this.setStateDate(stateDate);
    }

    private void checkStateDate(DateTime stateDate, PhdProcessStateType type) {
        Collection<? extends PhdProcessState> orderedStates = this.getProcess().getOrderedStates();
        for (PhdProcessState phdProcessState : orderedStates) {
            if (phdProcessState == this || phdProcessState.getStateDate() == null || !phdProcessState.getStateDate().isAfter((ReadableInstant)stateDate)) continue;
            String newStateDate = stateDate.toString("dd/MM/yyyy") + " - " + type.getLocalizedName();
            String actualStateDate = phdProcessState.getStateDate().toString("dd/MM/yyyy") + " - " + phdProcessState.getType().getLocalizedName();
            throw new PhdDomainOperationException("error.PhdProcessState.state.date.is.previous.of.actual.state.on.process", newStateDate, actualStateDate);
        }
    }

    public void delete() {
        this.disconnect();
        this.deleteDomainObject();
    }

    protected void disconnect() {
        this.setPerson(null);
        this.setRootDomainObject(null);
    }

    public abstract PhdProcessStateType getType();

    public abstract boolean isLast();

    public abstract PhdProgramProcess getProcess();

    public void editStateDate(PhdProcessStateBean phdProcessStateBean) {
        Object object = advice$editStateDate.perform((Callable)new PhdProcessState$callable$editStateDate(this, phdProcessStateBean));
    }

    static /* synthetic */ void advised$editStateDate(PhdProcessState this_, PhdProcessStateBean bean) {
        if (bean.getStateDate() == null) {
            throw new PhdDomainOperationException("error.PhdProcessState.state.date.required", new String[0]);
        }
        this_.setStateDate(bean.getStateDate());
    }

    protected static String buildExpectedStatesDescription(List<? extends PhdProcessStateType> possibleNextStates) {
        if (possibleNextStates.isEmpty()) {
            return BundleUtil.getString((String)"resources.PhdResources", (Locale)Locale.getDefault(), (String)"message.phd.process.state.none", (String[])new String[0]);
        }
        StringBuilder builder = new StringBuilder();
        for (PhdProcessStateType phdProcessStateType : possibleNextStates) {
            Locale locale = Locale.getDefault();
            builder.append(phdProcessStateType.getLocalizedName(locale)).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    static {
        advice$editStateDate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_DATE = new Comparator<PhdProcessState>(){

            @Override
            public int compare(PhdProcessState o1, PhdProcessState o2) {
                int result = o1.getWhenCreated().compareTo((ReadableInstant)o2.getWhenCreated());
                return result != 0 ? result : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

