/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.ExternalPhdProgram_Base;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class ExternalPhdProgram
extends ExternalPhdProgram_Base {
    public ExternalPhdProgram() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
    }

    private ExternalPhdProgram(String name, String nameEn, String acronym, PhdIndividualProgramCollaborationType forCollaborationType) {
        this();
        this.check(name, nameEn, acronym, forCollaborationType);
        MultiLanguageString nameI18N = new MultiLanguageString(MultiLanguageString.pt, name).with(MultiLanguageString.en, nameEn);
        this.setName(nameI18N);
        this.setAcronym(acronym);
        this.setForCollaborationType(forCollaborationType);
    }

    private void check(String name, String nameEn, String acronym, PhdIndividualProgramCollaborationType forCollaborationType) {
        if (StringUtils.isEmpty((String)name)) {
            throw new DomainException("error.external.phd.program.name.is.empty", new String[0]);
        }
        if (StringUtils.isEmpty((String)nameEn)) {
            throw new DomainException("error.external.phd.program.name.en.is.empty", new String[0]);
        }
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.external.phd.program.acronym.is.empty", new String[0]);
        }
        if (forCollaborationType == null) {
            throw new DomainException("error.external.phd.program.for.collaboration.type.is.null", new String[0]);
        }
    }

    public boolean isForCollaborationType(PhdIndividualProgramCollaborationType type) {
        return this.getForCollaborationType() == type;
    }

    public static ExternalPhdProgram createExternalPhdProgram(String name, String nameEn, String acronym, PhdIndividualProgramCollaborationType forCollaborationType) {
        if (ExternalPhdProgram.readExternalPhdProgramByName(name) != null) {
            throw new DomainException("error.external.phd.program.with.same.name.exists", new String[0]);
        }
        if (ExternalPhdProgram.readExternalPhdProgramByAcronym(acronym) != null) {
            throw new DomainException("error.external.phd.program.with.same.acronym.exists", new String[0]);
        }
        return new ExternalPhdProgram(name, nameEn, acronym, forCollaborationType);
    }

    public static List<ExternalPhdProgram> readExternalPhdProgramsForCollaborationType(final PhdIndividualProgramCollaborationType type) {
        ArrayList<ExternalPhdProgram> phdProgramList = new ArrayList<ExternalPhdProgram>();
        CollectionUtils.select((Collection)Bennu.getInstance().getExternalPhdProgramsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((ExternalPhdProgram)((Object)arg0)).isForCollaborationType(type);
            }
        }, phdProgramList);
        return phdProgramList;
    }

    public static ExternalPhdProgram readExternalPhdProgramByName(final String name) {
        return (ExternalPhdProgram)((Object)CollectionUtils.find((Collection)Bennu.getInstance().getExternalPhdProgramsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return name.equals(((ExternalPhdProgram)((Object)object)).getName().getContent());
            }
        }));
    }

    public static ExternalPhdProgram readExternalPhdProgramByAcronym(final String acronym) {
        return (ExternalPhdProgram)((Object)CollectionUtils.find((Collection)Bennu.getInstance().getExternalPhdProgramsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return acronym.equals(((ExternalPhdProgram)((Object)object)).getAcronym());
            }
        }));
    }
}

