/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.person;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.commons.StringNormalizer;

public class HumanName {
    private final String prefix;
    private final String givenNames;
    private final String familyNames;
    private final String suffix;
    private static final Set<String> knwonPrefixes = new HashSet<String>();
    private static final Set<String> knwonSuffixes = new HashSet<String>();
    private static final Set<String> prepositions = new HashSet<String>();
    private static String[] capitalizationDelimiters = new String[]{" ", "-", "Mc"};

    public HumanName(String prefix, String givenNames, String familyNames, String suffix) {
        this.prefix = HumanName.cleanupName(prefix);
        this.givenNames = HumanName.cleanupName(givenNames);
        this.familyNames = HumanName.cleanupName(familyNames);
        this.suffix = HumanName.cleanupName(suffix);
    }

    public static boolean namesMatch(String name, String query) {
        List<String> nameParts = Arrays.asList(StringNormalizer.normalizeAndRemoveAccents((String)name).toLowerCase().trim().split("\\s+"));
        List<String> queryParts = Arrays.asList(StringNormalizer.normalizeAndRemoveAccents((String)query).toLowerCase().trim().split("\\s+"));
        return nameParts.containsAll(queryParts);
    }

    public static HumanName decompose(String fullname, boolean normalizeCapitalization) {
        return HumanName.decompose(normalizeCapitalization ? HumanName.nameCapitalization(fullname) : fullname);
    }

    private static HumanName decompose(String fullname) {
        int k;
        int j;
        int i;
        String[] parts = fullname.split("\\s+");
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> given = new ArrayList<String>();
        ArrayList<String> family = new ArrayList<String>();
        ArrayList sufixes = new ArrayList();
        Joiner joiner = Joiner.on((char)' ');
        for (i = 0; i < parts.length && knwonPrefixes.contains(parts[i].toLowerCase().replace('.', ' ').trim()); ++i) {
            prefixes.add(parts[i]);
        }
        for (j = parts.length - 1; j > 0 && knwonSuffixes.contains(parts[j].toLowerCase().replace('.', ' ').trim()); --j) {
            prefixes.add(parts[j]);
        }
        Collections.reverse(sufixes);
        int givenCount = j - i + 1 >= 4 ? 2 : 1;
        for (k = i; k < parts.length && givenCount > 0; ++k) {
            given.add(parts[k]);
            if (prepositions.contains(parts[k])) continue;
            --givenCount;
        }
        while (k <= j) {
            family.add(parts[k]);
            ++k;
        }
        return new HumanName(Strings.emptyToNull((String)joiner.join(prefixes)), joiner.join(given), joiner.join(family), Strings.emptyToNull((String)joiner.join(sufixes)));
    }

    public HumanName normalizeCapitalization() {
        return new HumanName(HumanName.nameCapitalization(this.prefix), HumanName.nameCapitalization(this.givenNames), HumanName.nameCapitalization(this.familyNames), HumanName.nameCapitalization(this.suffix));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getGivenNames() {
        return this.givenNames;
    }

    public String getFamilyNames() {
        return this.familyNames;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getFullname() {
        return (this.prefix != null ? this.prefix + " " : "") + this.givenNames + " " + this.familyNames + (this.suffix != null ? this.suffix + " " : "");
    }

    public static String cleanupName(String name) {
        if (name == null) {
            return null;
        }
        return Strings.emptyToNull((String)CharMatcher.WHITESPACE.trimAndCollapseFrom((CharSequence)name, ' '));
    }

    public static String nameCapitalization(String name) {
        return HumanName.capitalizeFully(name, prepositions, capitalizationDelimiters);
    }

    public static String capitalizeFully(String str, Set<String> exceptions, String ... delimiters) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        return HumanName.capitalize(str.toLowerCase(), exceptions, delimiters);
    }

    public static String capitalize(String str, Set<String> exceptions, String ... delimiters) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        HashMultimap exceptionBySize = HashMultimap.create();
        for (String exception : exceptions) {
            exceptionBySize.put((Object)(exception.length() + 1), (Object)(" " + exception));
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (capitalizeNext) {
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
            }
            if (!HumanName.isDelimiterEnd(buffer, i, delimiters) || HumanName.isException(buffer, i, (Multimap<Integer, String>)exceptionBySize)) continue;
            capitalizeNext = true;
        }
        return new String(buffer);
    }

    private static boolean isDelimiterEnd(char[] buffer, int i, String[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(buffer[i]);
        }
        for (String delimiter : delimiters) {
            if (i - delimiter.length() + 1 < 0 || !delimiter.equals(String.valueOf(buffer, i - delimiter.length() + 1, delimiter.length()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isException(char[] buffer, int i, Multimap<Integer, String> exceptionBySize) {
        for (Integer size : exceptionBySize.keySet()) {
            if (i + size > buffer.length || !exceptionBySize.get((Object)size).contains(String.valueOf(buffer, i, size))) continue;
            return true;
        }
        return false;
    }

    static {
        knwonPrefixes.add("mr");
        knwonPrefixes.add("master");
        knwonPrefixes.add("mister");
        knwonPrefixes.add("mrs");
        knwonPrefixes.add("miss");
        knwonPrefixes.add("ms");
        knwonPrefixes.add("rev");
        knwonPrefixes.add("fr");
        knwonPrefixes.add("dr");
        knwonPrefixes.add("prof");
        knwonPrefixes.add("pres");
        knwonPrefixes.add("gov");
        knwonPrefixes.add("amb");
        knwonPrefixes.add("sen");
        knwonPrefixes.add("sec");
        knwonPrefixes.add("coach");
        knwonPrefixes.add("ofc");
        knwonPrefixes.add("pvt");
        knwonPrefixes.add("cpl");
        knwonPrefixes.add("sgt");
        knwonPrefixes.add("maj");
        knwonPrefixes.add("capt");
        knwonPrefixes.add("cmdr");
        knwonPrefixes.add("lt");
        knwonPrefixes.add("col");
        knwonPrefixes.add("gen");
        knwonPrefixes.add("sr");
        knwonPrefixes.add("sra");
        knwonPrefixes.add("dr");
        knwonPrefixes.add("prof");
        prepositions.add("da");
        prepositions.add("das");
        prepositions.add("do");
        prepositions.add("dos");
        prepositions.add("de");
    }
}

