/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;

public class DegreeModuleToEnrol
implements Serializable,
IDegreeModuleToEvaluate {
    private static final long serialVersionUID = -6337658191828772384L;
    private CurriculumGroup curriculumGroup;
    private Context context;
    private ExecutionSemester executionSemester;

    protected DegreeModuleToEnrol() {
    }

    public DegreeModuleToEnrol(CurriculumGroup curriculumGroup, Context context, ExecutionSemester executionSemester) {
        this.curriculumGroup = curriculumGroup;
        this.context = context;
        this.executionSemester = executionSemester;
    }

    @Override
    public CurriculumGroup getCurriculumGroup() {
        return this.curriculumGroup;
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        this.curriculumGroup = curriculumGroup;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    @Override
    public String getKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getContext().getClass().getName()).append(":").append(this.getContext().getExternalId()).append(",").append(((Object)((Object)this.getCurriculumGroup())).getClass().getName()).append(":").append(this.getCurriculumGroup().getExternalId()).append(",").append(this.getExecutionPeriod().getClass().getName()).append(":").append(this.getExecutionPeriod().getExternalId());
        return stringBuilder.toString();
    }

    @Override
    public boolean isLeaf() {
        return this.getDegreeModule().isLeaf();
    }

    @Override
    public final boolean isEnroling() {
        return true;
    }

    @Override
    public final boolean isEnroled() {
        return false;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isDissertation() {
        return this.getDegreeModule().isDissertation();
    }

    @Override
    public boolean canCollectRules() {
        return true;
    }

    @Override
    public DegreeModule getDegreeModule() {
        return this.getContext().getChildDegreeModule();
    }

    @Override
    public Double getEctsCredits(ExecutionSemester executionSemester) {
        return this.isLeaf() ? ((CurricularCourse)((Object)this.getDegreeModule())).getEctsCredits(executionSemester) : Double.valueOf(0.0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DegreeModuleToEnrol) {
            DegreeModuleToEnrol degreeModuleToEnrol = (DegreeModuleToEnrol)obj;
            return this.getContext().equals(degreeModuleToEnrol.getContext()) && this.getCurriculumGroup().equals((Object)degreeModuleToEnrol.getCurriculumGroup());
        }
        return false;
    }

    public int hashCode() {
        return this.getContext().hashCode() + this.getCurriculumGroup().hashCode();
    }

    @Override
    public List<CurricularRule> getCurricularRulesFromDegreeModule(ExecutionSemester executionSemester) {
        return this.getDegreeModule().getCurricularRules(this.getContext(), executionSemester);
    }

    @Override
    public Set<ICurricularRule> getCurricularRulesFromCurriculumGroup(ExecutionSemester executionSemester) {
        return this.getCurriculumGroup().getCurricularRules(executionSemester);
    }

    @Override
    public double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        if (this.isLeaf()) {
            return this.getCurriculumGroup().getStudentCurricularPlan().getAccumulatedEctsCredits(executionSemester, (CurricularCourse)((Object)this.getDegreeModule()));
        }
        return 0.0;
    }

    @Override
    public String getName() {
        return this.getDegreeModule().getName();
    }

    @Override
    public String getYearFullLabel() {
        return this.getContext().getCurricularPeriod().getFullLabel();
    }

    @Override
    public boolean isOptionalCurricularCourse() {
        if (this.getDegreeModule().isLeaf()) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)this.getDegreeModule());
            return curricularCourse.isOptionalCurricularCourse();
        }
        return false;
    }

    @Override
    public Double getEctsCredits() {
        return this.getEctsCredits(this.getExecutionPeriod());
    }

    @Override
    public boolean isFor(DegreeModule degreeModule) {
        return this.getDegreeModule() == degreeModule;
    }

    @Override
    public boolean isAnnualCurricularCourse(ExecutionYear executionYear) {
        if (this.getDegreeModule().isLeaf()) {
            return ((CurricularCourse)((Object)this.getDegreeModule())).isAnual(executionYear);
        }
        return false;
    }

    protected StudentCurricularPlan getStudentCurricularPlan() {
        return this.getCurriculumGroup().getStudentCurricularPlan();
    }
}

